/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.antx.config.entry;

import com.alibaba.antx.config.ConfigException;
import com.alibaba.antx.config.ConfigResource;
import com.alibaba.antx.config.ConfigSettings;
import com.alibaba.antx.config.descriptor.ConfigDescriptor;
import com.alibaba.antx.config.descriptor.ConfigGenerate;
import com.alibaba.antx.config.entry.ConfigEntry;
import com.alibaba.antx.config.generator.ConfigGeneratorCallback;
import com.alibaba.antx.util.scanner.ScannerException;
import com.alibaba.antx.util.scanner.ScannerHandler;
import com.alibaba.antx.util.scanner.ZipScanner;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class ZipConfigEntry
extends ConfigEntry {
    public ZipConfigEntry(ConfigResource resource, File outputFile, ConfigSettings settings) {
        super(resource, outputFile, settings);
    }

    protected void scan(InputStream istream) {
        ConfigEntry.Handler handler = new ConfigEntry.Handler();
        ZipScanner scanner = new ZipScanner(this.getConfigEntryResource().getURL(), (ScannerHandler)handler);
        scanner.setInputStream(istream);
        try {
            scanner.scan();
        }
        catch (ScannerException e) {
            throw new ConfigException(e);
        }
        this.subEntries = handler.getSubEntries();
        this.getGenerator().init();
    }

    /*
     * Loose catch block
     */
    protected boolean generate(InputStream istream, OutputStream ostream) {
        boolean allSuccess;
        block39: {
            IOException e222;
            ZipOutputStream zos;
            File outputFile;
            File destfile;
            boolean success;
            boolean needCloseInputStream;
            boolean needCloseOutputStream;
            block36: {
                ZipEntry zipEntry;
                needCloseOutputStream = false;
                needCloseInputStream = false;
                success = false;
                destfile = null;
                outputFile = this.getOutputFile();
                this.getConfigSettings().debug("Processing files in " + this.getConfigEntryResource());
                ZipInputStream zis = null;
                zos = null;
                HashSet dirs = new HashSet();
                allSuccess = true;
                if (ostream == null) {
                    if (outputFile == null) {
                        destfile = this.getConfigEntryResource().getFile();
                        if (destfile == null || !destfile.exists()) {
                            throw new ConfigException("Could not find " + this.getConfigEntryResource().getURL());
                        }
                        outputFile = new File(destfile.getParentFile(), destfile.getName() + ".tmp");
                    }
                    outputFile.getParentFile().mkdirs();
                    ostream = new BufferedOutputStream(new FileOutputStream(outputFile), 8192);
                    needCloseOutputStream = true;
                }
                if (istream == null) {
                    istream = this.getConfigEntryResource().getURL().openStream();
                    if (!(istream instanceof BufferedInputStream)) {
                        istream = new BufferedInputStream(istream, 8192);
                    }
                    needCloseInputStream = true;
                }
                zis = new ZipInputStream(istream);
                zos = new ZipOutputStream(ostream);
                this.getGenerator().startSession(this.getConfigSettings().getPropertiesSet());
                while ((zipEntry = zis.getNextEntry()) != null) {
                    allSuccess &= this.processZipEntry(zipEntry, zis, zos, dirs);
                }
                allSuccess &= this.getGenerator().getSession().generateLazyItems(new ZipCallback(zos, dirs));
                this.getGenerator().getSession().checkNonprocessedTemplates();
                this.getGenerator().getSession().generateLog(new ZipCallback(zos, dirs));
                success = true;
                Object var14_14 = null;
                this.getGenerator().closeSession();
                if (zos == null) break block36;
                try {
                    zos.finish();
                }
                catch (IOException e222) {
                    // empty catch block
                }
            }
            if (needCloseInputStream && istream != null) {
                try {
                    istream.close();
                }
                catch (IOException e222) {
                    // empty catch block
                }
            }
            if (!needCloseOutputStream || ostream == null) break block39;
            try {
                ostream.flush();
                ostream.close();
            }
            catch (IOException e222) {
                // empty catch block
            }
            if (success) {
                if (this.getOutputFile() == null) {
                    int retryTimes = 10;
                    boolean succ = false;
                    String message = String.format("Moving file %s to %s failed.", outputFile.getName(), destfile.getName());
                    for (int i = 0; i < retryTimes; ++i) {
                        destfile.delete();
                        succ = outputFile.renameTo(destfile);
                        if (succ) break;
                        this.getConfigSettings().warn(String.format(message + "  Wait 0.5s and try again...%d of %d", i + 1, retryTimes));
                        try {
                            System.gc();
                            Thread.sleep(500L);
                            continue;
                        }
                        catch (InterruptedException e3) {
                            // empty catch block
                        }
                    }
                    if (!succ) {
                        throw new ConfigException(message);
                    }
                }
            } else {
                outputFile.delete();
                {
                    break block39;
                    catch (IOException e4) {
                        throw new ConfigException(e4);
                    }
                }
                catch (Throwable throwable) {
                    Object var14_15 = null;
                    this.getGenerator().closeSession();
                    if (zos != null) {
                        try {
                            zos.finish();
                        }
                        catch (IOException e222) {
                            // empty catch block
                        }
                    }
                    if (needCloseInputStream && istream != null) {
                        try {
                            istream.close();
                        }
                        catch (IOException e222) {
                            // empty catch block
                        }
                    }
                    if (needCloseOutputStream && ostream != null) {
                        try {
                            ostream.flush();
                            ostream.close();
                        }
                        catch (IOException e222) {
                            // empty catch block
                        }
                        if (success) {
                            if (this.getOutputFile() == null) {
                                int retryTimes = 10;
                                boolean succ = false;
                                String message = String.format("Moving file %s to %s failed.", outputFile.getName(), destfile.getName());
                                for (int i = 0; i < retryTimes; ++i) {
                                    destfile.delete();
                                    succ = outputFile.renameTo(destfile);
                                    if (succ) break;
                                    this.getConfigSettings().warn(String.format(message + "  Wait 0.5s and try again...%d of %d", i + 1, retryTimes));
                                    try {
                                        System.gc();
                                        Thread.sleep(500L);
                                        continue;
                                    }
                                    catch (InterruptedException e3) {
                                        // empty catch block
                                    }
                                }
                                if (!succ) {
                                    throw new ConfigException(message);
                                }
                            }
                        } else {
                            outputFile.delete();
                        }
                    }
                    throw throwable;
                }
            }
        }
        return allSuccess;
    }

    private boolean processZipEntry(ZipEntry zipEntry, ZipInputStream zis, ZipOutputStream zos, Set dirs) throws IOException {
        String name = zipEntry.getName();
        ConfigEntry subEntry = this.getSubEntry(name);
        if (subEntry != null) {
            ZipEntry zipEntryToWrite = new ZipEntry(zipEntry.getName());
            zos.putNextEntry(zipEntryToWrite);
            return subEntry.generate(zis, zos);
        }
        if (this.getGenerator().isTemplateFile(name)) {
            byte[] bytes = this.streamToBytes(zis);
            if (this.getGenerator().isDestFile(name)) {
                this.getGenerator().getSession().addLazyGenerateItem(name, bytes);
                return true;
            }
            this.copyFile(zipEntry, new ByteArrayInputStream(bytes), zos);
            return this.getGenerator().getSession().generate(name, new ZipCallback(bytes, zos, dirs));
        }
        if (!this.getGenerator().isDestFile(name) && !this.getGenerator().isDescriptorLogFile(name)) {
            if (zipEntry.isDirectory()) {
                this.mkdirs(zipEntry.getName(), zos, dirs);
            } else {
                this.copyFile(zipEntry, zis, zos);
            }
        }
        return true;
    }

    private byte[] streamToBytes(ZipInputStream zis) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.io(zis, baos);
        return baos.toByteArray();
    }

    private void mkdirs(String dir, ZipOutputStream zos, Set dirs) throws IOException {
        dir = dir.replace('\\', '/');
        while (dir.startsWith("/")) {
            dir = dir.substring(1);
        }
        if (!dir.endsWith("/")) {
            dir = dir + "/";
        }
        int index = dir.indexOf("/");
        while (index > 0) {
            String subDir = dir.substring(0, index + 1);
            if (!dirs.contains(subDir)) {
                zos.putNextEntry(new ZipEntry(subDir));
                dirs.add(subDir);
            }
            index = dir.indexOf("/", index + 1);
        }
    }

    private void copyFile(ZipEntry zipEntry, InputStream istream, ZipOutputStream zos) throws IOException {
        zos.putNextEntry(new ZipEntry(zipEntry));
        this.io(istream, zos);
    }

    private void io(InputStream in, OutputStream out) throws IOException {
        int amount;
        byte[] buffer = new byte[8192];
        while ((amount = in.read(buffer)) >= 0) {
            out.write(buffer, 0, amount);
        }
    }

    private ConfigEntry getSubEntry(String name) {
        ConfigEntry[] entries;
        for (ConfigEntry subEntry : entries = this.getSubEntries()) {
            if (!subEntry.getName().equals(name.replace('\\', '/'))) continue;
            return subEntry;
        }
        return null;
    }

    public String toString() {
        return "ZipConfigEntry[" + this.getConfigEntryResource() + "]";
    }

    private final class ZipCallback
    implements ConfigGeneratorCallback {
        private final byte[] bytes;
        private final ZipOutputStream zos;
        private final Set dirs;

        private ZipCallback(ZipOutputStream zos, Set dirs) {
            this(null, zos, dirs);
        }

        private ZipCallback(byte[] bytes, ZipOutputStream zos, Set dirs) {
            this.bytes = bytes;
            this.zos = zos;
            this.dirs = dirs;
        }

        public String nextEntry(String template, ConfigGenerate generate) {
            this.nextEntry(generate.getConfigDescriptor(), new ByteArrayInputStream(this.bytes), generate.getDestfile());
            return template;
        }

        public void nextEntry(ConfigDescriptor descriptor, InputStream is, String dest) {
            try {
                this.makeParentDirs(dest);
                this.zos.putNextEntry(new ZipEntry(dest));
            }
            catch (IOException e) {
                throw new ConfigException(e);
            }
            ZipConfigEntry.this.getGenerator().getSession().setInputStream(is);
            ZipConfigEntry.this.getGenerator().getSession().setOutputStream(this.zos);
        }

        public void logEntry(ConfigDescriptor descriptor, String logfileName) {
            try {
                this.makeParentDirs(logfileName);
                this.zos.putNextEntry(new ZipEntry(logfileName));
            }
            catch (IOException e) {
                throw new ConfigException(e);
            }
            ZipConfigEntry.this.getGenerator().getSession().setOutputStream(this.zos);
        }

        public void closeEntry() {
        }

        private void makeParentDirs(String name) throws IOException {
            int index = name.lastIndexOf("/");
            if (index > 0) {
                ZipConfigEntry.this.mkdirs(name.substring(0, index + 1), this.zos, this.dirs);
            }
        }
    }
}

