/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.antx.config.generator;

import com.alibaba.antx.config.ConfigException;
import com.alibaba.antx.config.ConfigLogger;
import com.alibaba.antx.config.ConfigResource;
import com.alibaba.antx.config.descriptor.ConfigDescriptor;
import com.alibaba.antx.config.descriptor.ConfigDescriptorLoader;
import com.alibaba.antx.config.descriptor.ConfigGenerate;
import com.alibaba.antx.config.generator.ConfigGeneratorSession;
import com.alibaba.antx.config.props.PropertiesSet;
import com.alibaba.antx.util.FileUtil;
import com.alibaba.antx.util.StringUtil;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigGenerator {
    final ConfigLogger logger;
    private List<ConfigDescriptor> configDescriptors = new LinkedList<ConfigDescriptor>();
    Map<String, List<ConfigGenerate>> generateTemplateFiles = new HashMap<String, List<ConfigGenerate>>();
    Map<String, List<ConfigGenerate>> generateTemplateFilesIncludingMetaInfos = new HashMap<String, List<ConfigGenerate>>();
    Map<String, ConfigGenerate> generateDestFiles = new HashMap<String, ConfigGenerate>();
    private ConfigGeneratorSession session;
    private boolean initialized = false;

    public ConfigGenerator(ConfigLogger logger) {
        this.logger = logger;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ConfigDescriptor addConfigDescriptor(ConfigResource descriptorResource) {
        ConfigDescriptor configDescriptor;
        URL descriptorURL = descriptorResource.getURL();
        InputStream istream = null;
        try {
            try {
                istream = descriptorURL.openStream();
                if (!(istream instanceof BufferedInputStream)) {
                    istream = new BufferedInputStream(istream, 8192);
                }
                configDescriptor = this.addConfigDescriptor(descriptorResource, istream);
                Object var6_6 = null;
                if (istream == null) return configDescriptor;
            }
            catch (IOException e) {
                throw new ConfigException(e);
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (istream == null) throw throwable;
            try {
                istream.close();
                throw throwable;
            }
            catch (IOException e2) {
                throw throwable;
            }
        }
        try {}
        catch (IOException e2) {
            // empty catch block
            return configDescriptor;
        }
        istream.close();
        return configDescriptor;
    }

    public ConfigDescriptor addConfigDescriptor(ConfigResource descriptorResource, InputStream istream) {
        if (this.initialized) {
            throw new IllegalStateException("Cannot add config descriptors after initialization");
        }
        ConfigDescriptorLoader loader = new ConfigDescriptorLoader();
        ConfigDescriptor descriptor = loader.load(descriptorResource, istream);
        this.configDescriptors.add(descriptor);
        return descriptor;
    }

    public void init() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        for (ConfigDescriptor descriptor : this.configDescriptors) {
            String basename = FileUtil.normalizeUnixPath(descriptor.getName() + "/../");
            for (int j = 0; j < descriptor.getGenerates().length; ++j) {
                ConfigGenerate generate = descriptor.getGenerates()[j];
                String template = generate.getTemplate();
                String destFile = generate.getDestfile();
                if (StringUtil.isBlank(template)) {
                    this.logger.warn("Missing template attribute in <generate>: file=" + descriptor.getURL());
                    descriptor.removeGenerate(generate);
                    continue;
                }
                if (StringUtil.isBlank(destFile)) {
                    destFile = template;
                }
                template = FileUtil.normalizeUnixPath("./" + template);
                destFile = FileUtil.normalizeUnixPath("./" + destFile);
                generate.setTemplateBase(basename);
                generate.setTemplate(template);
                generate.setDestfile(destFile);
                if (this.generateDestFiles.containsKey(destFile)) {
                    ConfigGenerate originalGenerate = this.generateDestFiles.get(destFile);
                    if (originalGenerate.getConfigDescriptor() == descriptor) {
                        this.logger.info("Duplicated destfile " + destFile + "\n  in " + descriptor.getURL());
                    } else {
                        this.logger.info("Duplicated destfile " + destFile + "\n  in  " + descriptor.getURL() + "\n  and " + originalGenerate.getConfigDescriptor().getURL());
                    }
                    descriptor.removeGenerate(generate);
                    continue;
                }
                this.generateDestFiles.put(destFile, generate);
                this.addToTemplateList(this.generateTemplateFiles, template, generate);
                this.addToTemplateList(this.generateTemplateFilesIncludingMetaInfos, template, generate);
                if (template.startsWith(basename)) continue;
                this.addToTemplateList(this.generateTemplateFilesIncludingMetaInfos, basename + template, generate);
            }
        }
    }

    private void addToTemplateList(Map<String, List<ConfigGenerate>> generateTemplateFiles, String template, ConfigGenerate generate) {
        List<ConfigGenerate> generates = generateTemplateFiles.get(template);
        if (generates == null) {
            generates = new LinkedList<ConfigGenerate>();
            generateTemplateFiles.put(template, generates);
        }
        generates.add(generate);
    }

    private void ensureInitialized() {
        if (!this.initialized) {
            throw new IllegalStateException("Cannot call this method before initialization");
        }
    }

    public ConfigDescriptor[] getConfigDescriptors() {
        this.ensureInitialized();
        return this.configDescriptors.toArray(new ConfigDescriptor[this.configDescriptors.size()]);
    }

    public boolean isTemplateFile(String template) {
        this.ensureInitialized();
        return this.generateTemplateFilesIncludingMetaInfos.containsKey(template);
    }

    public boolean isDestFile(String destfile) {
        this.ensureInitialized();
        return this.generateDestFiles.containsKey(destfile);
    }

    public String getDescriptorLogFile(ConfigDescriptor descriptor) {
        return descriptor.getName() + ".log";
    }

    public boolean isDescriptorLogFile(String name) {
        this.ensureInitialized();
        for (ConfigDescriptor descriptor : this.configDescriptors) {
            if (!this.getDescriptorLogFile(descriptor).equals(name)) continue;
            return true;
        }
        return false;
    }

    public ConfigGeneratorSession getSession() {
        this.ensureInitialized();
        if (this.session == null) {
            throw new IllegalStateException("ConfigGeneratorSession has not yet been initialized");
        }
        return this.session;
    }

    public ConfigGeneratorSession startSession(PropertiesSet propSet) {
        this.ensureInitialized();
        this.session = new ConfigGeneratorSession(this, propSet);
        return this.session;
    }

    public void closeSession() {
        this.ensureInitialized();
        if (this.session != null) {
            this.session.close();
            this.session = null;
        }
    }
}

