/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.antx.config.generator;

import com.alibaba.antx.config.ConfigConstant;
import com.alibaba.antx.config.ConfigException;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.Formatter;
import java.util.TreeSet;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.log.LogChute;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VelocityTemplateEngine {
    private static Logger log = LoggerFactory.getLogger(VelocityTemplateEngine.class);
    private static VelocityTemplateEngine instance;
    private VelocityEngine engine = new VelocityEngine();

    public static VelocityTemplateEngine getInstance() {
        if (instance == null) {
            instance = new VelocityTemplateEngine();
        }
        return instance;
    }

    public VelocityTemplateEngine() {
        this.engine.setProperty("parser.pool.size", new Integer(1));
        this.engine.setProperty("runtime.log.logsystem", new LogSystem());
        this.engine.setProperty("velocimacro.context.localscope", "true");
        this.engine.setProperty("resource.loader", "classpath");
        this.engine.setProperty("classpath.resource.loader.class", ClasspathResourceLoader.class.getName());
        this.engine.setProperty("velocimacro.library", ConfigConstant.VELOCITY_MACRO_FILE);
        try {
            this.engine.init();
        }
        catch (Exception e) {
            throw new ConfigException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean render(Context context, Reader reader, Writer writer, String templateName, String configName, URL baseURL) throws Exception {
        TreeSet unknwonRefs = new TreeSet();
        context.put("_unknwonRefs", unknwonRefs);
        try {
            this.engine.evaluate(context, writer, templateName, reader);
            Object var9_8 = null;
            context.remove("_unknwonRefs");
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            context.remove("_unknwonRefs");
            throw throwable;
        }
        if (!unknwonRefs.isEmpty()) {
            StringBuilder buf = new StringBuilder();
            Formatter fmt = new Formatter(buf);
            fmt.format("Undefined placeholders found in template:%n", new Object[0]);
            fmt.format("- Template:   %s%n", templateName);
            fmt.format("- Descriptor: %s%n", configName);
            fmt.format("- Base URL:   %s%n", baseURL.toExternalForm());
            fmt.format("---------------------------------------------------------------%n", new Object[0]);
            for (String ref : unknwonRefs) {
                fmt.format("-> %s%n", ref);
            }
            fmt.format("---------------------------------------------------------------%n", new Object[0]);
            log.error(fmt.toString());
            return false;
        }
        return true;
    }

    private class LogSystem
    implements LogChute {
        private LogSystem() {
        }

        public void init(RuntimeServices runtimeServices) {
        }

        public boolean isLevelEnabled(int level) {
            switch (level) {
                case 3: {
                    return log.isErrorEnabled();
                }
                case 2: {
                    return log.isWarnEnabled();
                }
                case 1: {
                    return log.isInfoEnabled();
                }
                case 0: {
                    return log.isDebugEnabled();
                }
                case -1: {
                    return log.isTraceEnabled();
                }
            }
            return false;
        }

        public void log(int level, String message) {
            this.log(level, message, null);
        }

        public void log(int level, String message, Throwable t) {
            message = this.processMessage(message);
            switch (level) {
                case 3: {
                    log.error(message);
                    break;
                }
                case 2: {
                    log.warn(message);
                    break;
                }
                case 1: {
                    log.info(message);
                    break;
                }
                case 0: {
                    log.debug(message);
                    break;
                }
                case -1: {
                    log.trace(message);
                    break;
                }
            }
        }

        private String processMessage(String message) {
            if (message != null) {
                message = message.replaceFirst("^[\\w\\.\\$]+Exception: ", "");
            }
            return message;
        }
    }
}

