/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.antx.config.resource;

import com.alibaba.antx.config.ConfigException;
import com.alibaba.antx.config.resource.AuthenticationHandler;
import com.alibaba.antx.config.resource.DefaultAuthenticationHandler;
import com.alibaba.antx.config.resource.Resource;
import com.alibaba.antx.config.resource.ResourceDriver;
import com.alibaba.antx.config.resource.ResourceURI;
import com.alibaba.antx.config.resource.Session;
import com.alibaba.antx.config.resource.file.FileResourceDriver;
import com.alibaba.antx.config.resource.http.HttpResourceDriver;
import com.alibaba.antx.config.resource.ssh.SshResourceDriver;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ResourceManager {
    private final Map drivers = new HashMap();
    private final Map sessions = Collections.synchronizedMap(new HashMap());
    private AuthenticationHandler authHandlerDefault = new DefaultAuthenticationHandler(this);
    private AuthenticationHandler authHandler;
    private PrintWriter out;
    private BufferedReader in;

    public ResourceManager() {
        this.registerDefaultDrivers();
    }

    private void registerDefaultDrivers() {
        this.drivers.put("file", new FileResourceDriver(this));
        this.drivers.put("http", new HttpResourceDriver(this));
        this.drivers.put("https", this.drivers.get("http"));
        this.drivers.put("ssh", new SshResourceDriver(this));
    }

    public AuthenticationHandler getAuthenticationHandler() {
        return this.authHandler == null ? this.authHandlerDefault : this.authHandler;
    }

    public void setAuthenticationHandler(AuthenticationHandler authHandler) {
        this.authHandler = authHandler;
    }

    public Resource getResource(URI uri) {
        Session session = this.getSession(uri.getScheme());
        return session.getResource(new ResourceURI(uri, session));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Session getSession(String type) {
        Session session;
        ResourceDriver driver = (ResourceDriver)this.drivers.get(type);
        if (driver == null) {
            throw new ConfigException("No drivers for resource type: " + type);
        }
        Map map = this.sessions;
        synchronized (map) {
            session = (Session)this.sessions.get(driver);
            if (session == null) {
                session = driver.open();
                this.sessions.put(driver, session);
            }
        }
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Map map = this.sessions;
        synchronized (map) {
            Iterator i = this.sessions.values().iterator();
            while (i.hasNext()) {
                Session session = (Session)i.next();
                i.remove();
                session.close();
            }
        }
    }

    public void log(String message) {
        this.getOut().println(message);
        this.getOut().flush();
    }

    public PrintWriter getOut() {
        if (this.out == null) {
            this.out = new PrintWriter(System.out, true);
        }
        return this.out;
    }

    public void setOut(PrintWriter out) {
        this.out = out;
    }

    public BufferedReader getIn() {
        if (this.in == null) {
            this.in = new BufferedReader(new InputStreamReader(System.in));
        }
        return this.in;
    }

    public void setIn(BufferedReader in) {
        this.in = in;
    }
}

