/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.antx.config.resource.util;

import com.alibaba.antx.config.resource.ResourceURI;
import com.alibaba.antx.config.resource.util.ResourceUtil;
import com.alibaba.antx.util.StringUtil;
import java.io.Serializable;
import java.net.URI;

public class ResourceKey
implements Serializable {
    private static final long serialVersionUID = -2027481344124093795L;
    private final String scheme;
    private final String user;
    private final String host;
    private final int port;

    public ResourceKey(String uri) {
        this(new ResourceURI(URI.create(uri)));
    }

    public ResourceKey(ResourceURI uri) {
        this(uri.getURI().getScheme(), ResourceUtil.getUsername(uri.getURI()), uri.getURI().getHost(), uri.getURI().getPort());
    }

    public ResourceKey(String scheme, String user, String host, int port) {
        this.scheme = scheme;
        this.user = user;
        this.host = host;
        this.port = port <= 0 ? 22 : port;
    }

    public String getUser() {
        return this.user;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.host == null ? 0 : this.host.hashCode());
        result = 31 * result + this.port;
        result = 31 * result + (this.scheme == null ? 0 : this.scheme.hashCode());
        result = 31 * result + (this.user == null ? 0 : this.user.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ResourceKey other = (ResourceKey)obj;
        if (this.host == null ? other.host != null : !this.host.equals(other.host)) {
            return false;
        }
        if (this.port != other.port) {
            return false;
        }
        if (this.scheme == null ? other.scheme != null : !this.scheme.equals(other.scheme)) {
            return false;
        }
        return !(this.user == null ? other.user != null : !this.user.equals(other.user));
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.scheme).append("://");
        if (!StringUtil.isEmpty(this.user)) {
            buf.append(this.user).append("@");
        }
        buf.append(this.host);
        if (this.port > 0) {
            buf.append(":").append(this.port);
        }
        return buf.toString();
    }
}

