/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.antx.config.wizard.text;

import com.alibaba.antx.config.descriptor.ConfigDescriptor;
import com.alibaba.antx.config.descriptor.ConfigGroup;
import com.alibaba.antx.config.descriptor.ConfigProperty;
import com.alibaba.antx.config.descriptor.ConfigValidator;
import com.alibaba.antx.config.generator.expr.CompositeExpression;
import com.alibaba.antx.config.generator.expr.Expression;
import com.alibaba.antx.config.generator.expr.ExpressionContext;
import com.alibaba.antx.config.props.PropertiesSet;
import com.alibaba.antx.config.wizard.text.ConfigWizardException;
import com.alibaba.antx.util.ObjectUtil;
import com.alibaba.antx.util.StringUtil;
import com.alibaba.antx.util.i18n.LocaleInfo;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class ConfigWizard {
    private static final int PREVIOUS = -1;
    private static final int NEXT = -2;
    private static final int QUIT = -3;
    private static final int MAX_ALIGN = 40;
    private ConfigGroup[] groups;
    private PropertiesSet propSet;
    private String confirmMessage;
    private BufferedReader in;
    private PrintWriter out;
    private PrintWriter fileWriter;
    private int step;
    private ConfigGroup group;
    private ConfigProperty[] props;
    private ConfigProperty validatorProperty;
    private String validatorMessage;
    private int validatorIndex;

    public ConfigWizard(ConfigDescriptor[] descriptors, PropertiesSet propSet, String charset) {
        this.propSet = propSet;
        try {
            this.in = new BufferedReader(new InputStreamReader(System.in, charset));
            this.out = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)System.out, charset), true);
        }
        catch (UnsupportedEncodingException e) {
            throw new ConfigWizardException(e);
        }
        ArrayList<ConfigGroup> groups = new ArrayList<ConfigGroup>();
        for (ConfigDescriptor descriptor : descriptors) {
            ConfigGroup[] descriptorGroups;
            for (ConfigGroup descriptorGroup : descriptorGroups = descriptor.getGroups()) {
                groups.add(descriptorGroup);
            }
        }
        this.groups = groups.toArray(new ConfigGroup[groups.size()]);
        this.setStep(0);
    }

    public void setConfirmMessage(String confirmMessage) {
        this.confirmMessage = confirmMessage;
    }

    public boolean validate() {
        for (int i = 0; i < this.groups.length; ++i) {
            this.setStep(i);
            for (int j = 0; j < this.props.length; ++j) {
                ConfigProperty prop = this.props[j];
                String value = this.evaluatePropertyValue(prop, false);
                for (ConfigValidator element : prop.getValidators()) {
                    ConfigValidator validator = element;
                    if (validator.validate(value)) continue;
                    this.validatorIndex = j;
                    this.validatorProperty = prop;
                    this.validatorMessage = validator.getMessage();
                    return false;
                }
            }
        }
        return true;
    }

    private String getURI() {
        return this.propSet.getUserPropertiesFile().getURI().toString();
    }

    private Set getKeys() {
        return this.propSet.getMergedKeys();
    }

    private Map getValues() {
        return this.propSet.getMergedProperties();
    }

    private void fillDefaultValues() {
        int savedStep = this.step;
        for (int i = 0; i < this.groups.length; ++i) {
            this.setStep(i);
            ConfigProperty[] arr$ = this.props;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                ConfigProperty prop2;
                ConfigProperty prop = prop2 = arr$[i$];
                if (this.getValues().get(prop.getName()) != null && this.getKeys().contains(prop.getName())) continue;
                String value = this.getPropertyValue(prop, true);
                this.setProperty(prop.getName(), value == null ? "" : value);
            }
        }
        this.setStep(savedStep);
    }

    public void start() {
        boolean continueWizard = true;
        if (this.group == null) {
            this.confirmAndSave();
            return;
        }
        if (this.confirmMessage != null) {
            this.print(this.confirmMessage + " [Yes][No] ");
            try {
                String input = this.in.readLine();
                String string = input = input == null ? "" : input.trim().toLowerCase();
                if (input.equals("n") || input.equals("no")) {
                    continueWizard = false;
                }
            }
            catch (IOException e) {
                throw new ConfigWizardException(e);
            }
        }
        this.println();
        if (continueWizard) {
            this.fillDefaultValues();
        }
        block7: while (continueWizard) {
            this.printTitle();
            this.printGroup();
            int toStep = this.processMenu();
            switch (toStep) {
                case -1: {
                    this.setStep(this.step - 1);
                    continue block7;
                }
                case -2: {
                    this.setStep(this.step + 1);
                    continue block7;
                }
                case -3: {
                    continueWizard = this.confirmAndSave();
                    continue block7;
                }
            }
            this.processInput(toStep);
        }
    }

    private boolean confirmAndSave() {
        boolean continueWizard = true;
        if (this.confirmSave()) {
            if (this.validateSave()) {
                this.save();
                continueWizard = false;
            }
        } else {
            this.propSet.reloadUserProperties();
            continueWizard = false;
        }
        return continueWizard;
    }

    private void print(Object message) {
        String messageString = message == null ? "" : message.toString();
        this.out.print(messageString);
        this.out.flush();
        if (this.fileWriter != null) {
            this.fileWriter.print(messageString);
            this.fileWriter.flush();
        }
    }

    private void println(Object message) {
        String messageString = message == null ? "" : message.toString();
        this.out.println((this.fileWriter == null ? "" : "\u2502") + messageString);
        if (this.fileWriter != null) {
            this.fileWriter.println(messageString);
        }
    }

    private void println() {
        this.println(null);
    }

    private void printTitle() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("\u256d\u2500\u2500\u2500\u2500\u2500\u2500\u252c\u2500 Step ").append(this.step + 1);
        buffer.append(" of ").append(this.groups.length).append(" \u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2508\u2508\u2508\u2508\n");
        buffer.append("\u2502            \u2502\n");
        if (this.group.getConfigDescriptor().getDescription() != null) {
            buffer.append(this.formatLines(this.group.getConfigDescriptor().getDescription(), 60, LocaleInfo.getDefault().getLocale(), "\u2502Description \u2502 ", "\u2502            \u2502   ")).append("\n");
            buffer.append("\u2502\u2508\u2508\u2508\u2508\u2508\u2508\u2502\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\n");
        }
        buffer.append(this.formatLines(this.group.getConfigDescriptor().getURL().toString(), 60, LocaleInfo.getDefault().getLocale(), "\u2502Descriptor  \u2502 ", "\u2502            \u2502   ")).append("\n");
        buffer.append("\u2502\u2508\u2508\u2508\u2508\u2508\u2508\u2502\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\n");
        buffer.append(this.formatLines(this.getURI(), 60, LocaleInfo.getDefault().getLocale(), "\u2502Properties  \u2502 ", "\u2502            \u2502   ")).append("\n");
        buffer.append("\u2502            \u2502").append("\n");
        buffer.append("\u2514\u2500\u2500\u2500\u2500\u2500\u2500\u2534\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508").append("\n");
        this.println();
        this.println(buffer);
    }

    private void printGroup() {
        if (this.group.getDescription() != null) {
            this.println(" " + this.group.getDescription() + " (? - \u8be5\u503c\u5728\u7528\u6237\u914d\u7f6e\u6587\u4ef6\u4e2d\u4e0d\u5b58\u5728\uff0c* - \u5fc5\u586b\u9879\uff0cS - \u8986\u76d6\u5171\u4eab\u9ed8\u8ba4\u503c\uff0cs - \u5171\u4eab\u503c)");
        } else {
            this.println(" (? - \u8be5\u503c\u5728\u7528\u6237\u914d\u7f6e\u6587\u4ef6\u4e2d\u4e0d\u5b58\u5728\uff0c* - \u5fc5\u586b\u9879\uff0cS - \u8986\u76d6\u5171\u4eab\u9ed8\u8ba4\u503c\uff0cs - \u5171\u4eab\u503c)");
        }
        this.println();
        int maxLength = -1;
        int maxLengthValue = -1;
        for (ConfigProperty prop : this.props) {
            int length = prop.getName().length();
            if (length <= maxLength || length >= 40) continue;
            maxLength = length;
        }
        for (ConfigProperty prop : this.props) {
            String value = this.getPropertyValue(prop, true);
            int length = Math.max(prop.getName().length(), maxLength) + (value == null ? 0 : "  = ".length() + value.length());
            if (length <= maxLengthValue || length >= 80) continue;
            maxLengthValue = length;
        }
        for (int i = 0; i < this.props.length; ++i) {
            String evaluatedValue;
            int j;
            ConfigProperty prop = this.props[i];
            StringBuffer buffer = new StringBuffer();
            boolean absent = !this.getKeys().contains(prop.getName());
            boolean required = prop.isRequired();
            boolean shared = this.propSet.isShared(prop.getName());
            if (shared) {
                if (absent) {
                    buffer.append("s");
                } else {
                    buffer.append("S");
                }
            } else if (absent) {
                buffer.append("?");
            } else {
                buffer.append(" ");
            }
            if (required) {
                buffer.append("* ");
            } else {
                buffer.append("  ");
            }
            buffer.append(i + 1).append(" - ");
            buffer.append(prop.getName());
            String value = this.getPropertyValue(prop, true);
            if (value != null) {
                for (int j2 = 0; j2 < maxLength - prop.getName().length(); ++j2) {
                    buffer.append(' ');
                }
                buffer.append("  = ").append(value);
            }
            if (prop.getDescription() != null) {
                int length = value == null ? prop.getName().length() : Math.max(prop.getName().length(), maxLength) + "  = ".length() + value.length();
                for (j = 0; j < maxLengthValue - length; ++j) {
                    buffer.append(' ');
                }
                buffer.append("   # ").append(prop.getDescription());
            }
            if ((evaluatedValue = this.evaluatePropertyValue(prop, true)) != null && !ObjectUtil.equals(value, evaluatedValue)) {
                buffer.append("\n");
                for (j = 0; j < maxLength; ++j) {
                    buffer.append(' ');
                }
                buffer.append("          (").append(evaluatedValue).append(")");
                if (i < this.props.length - 1) {
                    buffer.append("\n");
                }
            }
            this.println(buffer);
        }
        this.println();
    }

    private int processMenu() {
        while (true) {
            StringBuffer buffer = new StringBuffer(" \u8bf7\u9009\u62e9");
            if (this.props.length > 0) {
                buffer.append("[1-").append(this.props.length).append("]");
            }
            buffer.append("[Quit]");
            if (this.step > 0) {
                buffer.append("[Previous]");
            }
            if (this.step < this.groups.length - 1) {
                buffer.append("[Next]");
            }
            buffer.append(" ");
            this.print(buffer);
            String input = null;
            try {
                input = this.in.readLine();
            }
            catch (IOException e) {
                throw new ConfigWizardException(e);
            }
            String string = input = input == null ? "" : input.trim().toLowerCase();
            if ((input.equals("n") || input.equals("next")) && this.step < this.groups.length - 1) {
                return -2;
            }
            if ((input.equals("p") || input.equals("previous")) && this.step > 0) {
                return -1;
            }
            if (input.equals("q") || input.equals("quit")) {
                return -3;
            }
            try {
                int inputValue = Integer.parseInt(input) - 1;
                if (inputValue < 0 || inputValue >= this.props.length) continue;
                return inputValue;
            }
            catch (NumberFormatException numberFormatException) {
                continue;
            }
            break;
        }
    }

    private void processInput(int index) {
        ConfigProperty prop = this.props[index];
        StringBuffer buffer = new StringBuffer(" \u8bf7\u8f93\u5165");
        if (prop.getDescription() != null) {
            buffer.append(prop.getDescription()).append(" ");
        }
        buffer.append(prop.getName()).append(" = ");
        String value = this.getPropertyValue(prop, true);
        if (value != null) {
            buffer.append("[").append(value).append("] ");
        }
        this.print(buffer);
        String input = null;
        try {
            input = this.in.readLine();
        }
        catch (IOException e) {
            throw new ConfigWizardException(e);
        }
        String string = input = input == null ? "" : input.trim();
        if (input == null || input.length() == 0) {
            input = value;
        }
        this.setProperty(prop.getName(), input);
    }

    private boolean confirmSave() {
        this.println();
        this.print(" \u5373\u5c06\u4fdd\u5b58\u5230\u6587\u4ef6\"" + this.getURI() + "\"\u4e2d, \u786e\u5b9a? [Yes][No] ");
        String input = null;
        try {
            input = this.in.readLine();
        }
        catch (IOException e) {
            throw new ConfigWizardException(e);
        }
        String string = input = input == null ? "" : input.trim().toLowerCase();
        return !input.equals("n") && !input.equals("no");
    }

    private boolean validateSave() {
        if (!this.validate()) {
            this.println();
            this.println(" \u5b57\u6bb5" + this.validatorProperty.getName() + "\u4e0d\u5408\u6cd5: " + this.validatorMessage);
            this.println();
            this.print(" \u60a8\u4ecd\u7136\u8981\u4fdd\u5b58\u5417? [Yes=\u5f3a\u5236\u4fdd\u5b58/No=\u7ee7\u7eed\u7f16\u8f91] ");
            String input = null;
            try {
                input = this.in.readLine();
            }
            catch (IOException e) {
                throw new ConfigWizardException(e);
            }
            String string = input = input == null ? "" : input.trim().toLowerCase();
            if (input.equals("y") || input.equals("yes")) {
                return true;
            }
            this.printTitle();
            this.printGroup();
            this.processInput(this.validatorIndex);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void save() {
        Map modifiedProperties = this.propSet.getModifiedProperties();
        this.println();
        this.println("\u256d\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2508\u2508\u2508\u2508");
        this.println("\u2502 \u4fdd\u5b58\u6587\u4ef6 " + this.getURI() + "...");
        this.println("\u2502\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508");
        try {
            OutputStream os = this.propSet.getUserPropertiesFile().getResource().getOutputStream();
            String charset = this.propSet.getUserPropertiesFile().getCharset();
            this.fileWriter = new PrintWriter((Writer)new OutputStreamWriter(os, charset), true);
        }
        catch (IOException e) {
            throw new ConfigWizardException(e);
        }
        try {
            List[] keyGroups = this.getSortedKeys(modifiedProperties, 2);
            for (int i = 0; i < keyGroups.length; ++i) {
                List keys = keyGroups[i];
                int maxLength = -1;
                for (String key : keys) {
                    int length = key.length();
                    if (length <= maxLength || length >= 40) continue;
                    maxLength = length;
                }
                for (String key : keys) {
                    String value = (String)modifiedProperties.get(key);
                    if (value == null) {
                        value = "";
                    }
                    value = value.replaceAll("\\\\", "\\\\\\\\");
                    StringBuffer buffer = new StringBuffer();
                    buffer.append(key);
                    for (int k = 0; k < maxLength - key.length(); ++k) {
                        buffer.append(' ');
                    }
                    buffer.append("  = ").append(value);
                    this.println(buffer);
                }
                if (i >= keyGroups.length - 1) continue;
                this.println();
            }
            Object var12_14 = null;
            this.fileWriter.close();
            this.fileWriter = null;
        }
        catch (Throwable throwable) {
            Object var12_15 = null;
            this.fileWriter.close();
            this.fileWriter = null;
            throw throwable;
        }
        this.println("\u2514\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508");
        this.println(" \u5df2\u4fdd\u5b58\u81f3\u6587\u4ef6: " + this.getURI());
        this.propSet.reloadUserProperties();
    }

    private List[] getSortedKeys(Map props, int level) {
        ArrayList keys = new ArrayList(props.keySet());
        Collections.sort(keys);
        ArrayList groups = new ArrayList();
        ArrayList<String> group = null;
        String prefix = null;
        for (String key : keys) {
            String[] parts = StringUtil.split(key, ".");
            StringBuffer buffer = new StringBuffer();
            for (int j = 0; j < parts.length - 1 && j < level; ++j) {
                if (buffer.length() > 0) {
                    buffer.append('.');
                }
                buffer.append(parts[j]);
            }
            String keyPrefix = buffer.toString();
            if (!keyPrefix.equals(prefix)) {
                if (group != null) {
                    groups.add(group);
                }
                prefix = keyPrefix;
                group = new ArrayList<String>();
            }
            group.add(key);
        }
        if (group != null && group.size() > 0) {
            groups.add(group);
        }
        return groups.toArray(new List[groups.size()]);
    }

    private void setProperty(String name, String value) {
        Object expr = value;
        if (value != null) {
            expr = CompositeExpression.parse(value);
        }
        if (expr == null) {
            this.getValues().remove(name);
            this.getKeys().remove(name);
        } else {
            this.getValues().put(name, expr);
            this.getValues().put(StringUtil.getValidIdentifier(name), expr);
            this.getKeys().add(name);
        }
    }

    private String getPropertyValue(ConfigProperty prop, boolean defaultValue) {
        Object value = this.getValues().get(prop.getName());
        if (defaultValue && value == null) {
            value = prop.getDefaultValue();
        }
        if (value instanceof Expression) {
            value = ((Expression)value).getExpressionText();
        }
        if (value instanceof String) {
            String stringValue = (String)value;
            if (stringValue != null) {
                stringValue = stringValue.trim();
            }
            if (stringValue == null || stringValue.length() == 0) {
                stringValue = null;
            }
            return stringValue;
        }
        return value == null ? null : value.toString();
    }

    private String evaluatePropertyValue(ConfigProperty prop, boolean defaultValue) {
        Expression expr;
        final String ref = prop.getName();
        Object value = this.getValues().get(ref);
        if (defaultValue && value == null && (value = prop.getDefaultValue()) instanceof String && (expr = CompositeExpression.parse((String)value)) != null) {
            value = expr;
        }
        if (value instanceof Expression) {
            value = ((Expression)value).evaluate(new ExpressionContext(){

                public Object get(String key) {
                    if (ref.equals(key) || StringUtil.getValidIdentifier(ref).equals(StringUtil.getValidIdentifier(key))) {
                        return null;
                    }
                    return ConfigWizard.this.getValues().get(key);
                }

                public void put(String key, Object value) {
                    ConfigWizard.this.getValues().put(key, value);
                }
            });
        }
        if (value instanceof String) {
            String stringValue = (String)value;
            if (stringValue != null) {
                stringValue = stringValue.trim();
            }
            if (stringValue == null || stringValue.length() == 0) {
                stringValue = null;
            }
            return stringValue;
        }
        return value == null ? null : value.toString();
    }

    private void setStep(int step) {
        if (step >= this.groups.length) {
            step = this.groups.length - 1;
        }
        if (step < 0) {
            step = 0;
        }
        this.step = step;
        if (step < this.groups.length) {
            this.group = this.groups[step];
            this.props = this.group.getProperties();
        } else {
            this.group = null;
        }
    }

    private String formatLines(String text, int maxLength, Locale locale, String prefix1, String prefix) {
        BreakIterator boundary = BreakIterator.getLineInstance(locale);
        StringBuffer result = new StringBuffer(prefix1);
        boundary.setText(text);
        int start = boundary.first();
        int end = boundary.next();
        int lineLength = 0;
        while (end != -1) {
            String word = text.substring(start, end);
            if ((lineLength += word.length()) >= maxLength) {
                result.append("\n").append(prefix);
                lineLength = word.length();
            }
            result.append(word);
            start = end;
            end = boundary.next();
        }
        return result.toString();
    }
}

