/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.toolkit.util.enumeration;

import com.alibaba.toolkit.util.collection.ArrayHashMap;
import com.alibaba.toolkit.util.collection.ListMap;
import com.alibaba.toolkit.util.enumeration.FlagSet;
import com.alibaba.toolkit.util.enumeration.Flags;
import com.alibaba.toolkit.util.enumeration.IntegralNumber;
import com.alibaba.toolkit.util.typeconvert.ConvertChain;
import com.alibaba.toolkit.util.typeconvert.Converter;
import com.alibaba.toolkit.util.typeconvert.Convertible;
import java.io.InvalidClassException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;

public abstract class Enum
implements IntegralNumber,
Comparable,
Serializable,
Convertible {
    private static final long serialVersionUID = -3420208858441821772L;
    private static final Map entries = new WeakHashMap();
    private final String name;
    private final Object value;

    protected Enum(String name) {
        this(name, null, false);
    }

    protected Enum(String name, Object value) {
        this(name, value, true);
    }

    private Enum(String name, Object value, boolean withValue) {
        if (name == null || (name = name.trim()).length() == 0) {
            throw new IllegalArgumentException("The Enum name must not be empty");
        }
        if (withValue && value == null) {
            throw new NullPointerException("The Enum value must not be null");
        }
        this.name = name;
        Class<?> enumClass = this.getClass();
        EnumType enumType = Enum.getEnumType(enumClass);
        boolean flagMode = this instanceof Flags;
        this.value = withValue ? enumType.setValue(value, flagMode) : enumType.getNextValue(flagMode);
        if (enumType.nameMap.containsKey(name)) {
            throw new IllegalArgumentException(MessageFormat.format("Duplicated name \"{0}\" of Enum class \"{1}\"", name, enumClass.getName()));
        }
        enumType.nameMap.put(name, this);
        if (!enumType.valueMap.containsKey(this.value)) {
            enumType.valueMap.put(this.value, this);
        }
        if (flagMode) {
            if (enumType.fullSet == null) {
                try {
                    enumType.fullSet = Enum.createFlagSet(enumClass);
                }
                catch (UnsupportedOperationException e) {
                    // empty catch block
                }
            }
            if (enumType.fullSet != null) {
                enumType.fullSet.set((Flags)((Object)this));
            }
        }
    }

    public static Class getUnderlyingClass(Class enumClass) {
        return Enum.getEnumType(enumClass).getUnderlyingClass();
    }

    public static boolean isNameDefined(Class enumClass, String name) {
        return Enum.getEnumType((Class)enumClass).nameMap.containsKey(name);
    }

    public static boolean isValueDefined(Class enumClass, Object value) {
        return Enum.getEnumType((Class)enumClass).valueMap.containsKey(value);
    }

    public static Enum getEnumByName(Class enumClass, String name) {
        return (Enum)Enum.getEnumType((Class)enumClass).nameMap.get(name);
    }

    public static Enum getEnumByValue(Class enumClass, Object value) {
        return (Enum)Enum.getEnumType((Class)enumClass).valueMap.get(value);
    }

    public static Map getEnumMap(Class enumClass) {
        return Collections.unmodifiableMap(Enum.getEnumType((Class)enumClass).nameMap);
    }

    public static Iterator iterator(Class enumClass) {
        return Enum.getEnumMap(enumClass).values().iterator();
    }

    public static FlagSet createFlagSet(Class enumClass) {
        if (!Flags.class.isAssignableFrom(enumClass)) {
            throw new UnsupportedOperationException(MessageFormat.format("The Enum class \"{0}\" is not an implementation of Flags", enumClass.getName()));
        }
        EnumType enumType = Enum.getEnumType(enumClass);
        if (enumType.flagSetClassExists && enumType.flagSetClass == null) {
            enumType.flagSetClass = Enum.findStaticInnerClass(enumClass, "FlagSet", FlagSet.class);
            if (enumType.flagSetClass == null) {
                enumType.flagSetClassExists = false;
            }
        }
        if (enumType.flagSetClassExists && enumType.flagSetClass != null) {
            try {
                return (FlagSet)enumType.flagSetClass.newInstance();
            }
            catch (IllegalAccessException e) {
            }
            catch (InstantiationException instantiationException) {
                // empty catch block
            }
        }
        throw new UnsupportedOperationException(MessageFormat.format("Creating FlagSet is not supported by Enum class \"{0}\".  Make sure there is a static inner class \"{0}.FlagSet\" with a constructor without parameters", enumClass.getName()));
    }

    public static FlagSet createFullSet(Class enumClass) {
        FlagSet flagSet = Enum.createFlagSet(enumClass);
        EnumType enumType = Enum.getEnumType(enumClass);
        if (flagSet != null && enumType.fullSet != null) {
            flagSet.set(enumType.fullSet);
        }
        return flagSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map getEnumEntryMap(Class enumClass) {
        ClassLoader classLoader = enumClass.getClassLoader();
        Hashtable entryMap = null;
        Map map = entries;
        synchronized (map) {
            entryMap = (Hashtable)entries.get(classLoader);
            if (entryMap == null) {
                entryMap = new Hashtable();
                entries.put(classLoader, entryMap);
            }
        }
        return entryMap;
    }

    private static EnumType getEnumType(Class enumClass) {
        if (enumClass == null) {
            throw new NullPointerException("The Enum class must not be null");
        }
        if (!Enum.class.isAssignableFrom(enumClass)) {
            throw new IllegalArgumentException(MessageFormat.format("Class \"{0}\" is not a subclass of Enum", enumClass.getName()));
        }
        Map entryMap = Enum.getEnumEntryMap(enumClass);
        EnumType enumType = (EnumType)entryMap.get(enumClass.getName());
        if (enumType == null) {
            Method createEnumTypeMethod = Enum.findStaticMethod(enumClass, "createEnumType", new Class[0]);
            if (createEnumTypeMethod != null) {
                try {
                    enumType = (EnumType)createEnumTypeMethod.invoke(null, new Object[0]);
                }
                catch (IllegalAccessException e) {
                }
                catch (IllegalArgumentException e) {
                }
                catch (InvocationTargetException e) {
                }
                catch (ClassCastException e) {
                    // empty catch block
                }
            }
            if (enumType != null) {
                entryMap.put(enumClass.getName(), enumType);
            }
        }
        if (enumType == null) {
            throw new UnsupportedOperationException(MessageFormat.format("Could not create EnumType for class \"{0}\"", enumClass.getName()));
        }
        return enumType;
    }

    private static Method findStaticMethod(Class enumClass, String methodName, Class[] paramTypes) {
        Method method = null;
        Class clazz = enumClass;
        while (!clazz.equals(Enum.class)) {
            try {
                method = clazz.getDeclaredMethod(methodName, paramTypes);
                break;
            }
            catch (NoSuchMethodException e) {
                clazz = clazz.getSuperclass();
            }
        }
        if (method != null && Modifier.isStatic(method.getModifiers())) {
            return method;
        }
        return null;
    }

    private static Class findStaticInnerClass(Class enumClass, String innerClassName, Class superClass) {
        innerClassName = enumClass.getName() + "$" + innerClassName;
        Class<?> innerClass = null;
        Class clazz = enumClass;
        while (!clazz.equals(Enum.class)) {
            Class<?>[] classes;
            for (Class<?> classe : classes = clazz.getDeclaredClasses()) {
                if (!classe.getName().equals(innerClassName) || !superClass.isAssignableFrom(classe)) continue;
                innerClass = classe;
                break;
            }
            clazz = clazz.getSuperclass();
        }
        if (innerClass != null && Modifier.isStatic(innerClass.getModifiers())) {
            return innerClass;
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public Object getValue() {
        return this.value;
    }

    public byte byteValue() {
        return (byte)this.intValue();
    }

    public short shortValue() {
        return (short)this.intValue();
    }

    public Converter getConverter(Class targetType) {
        return new Converter(){

            public Object convert(Object value, ConvertChain chain) {
                Enum enumObj = (Enum)value;
                Class targetType = chain.getTargetType();
                if (String.class.equals((Object)targetType)) {
                    return enumObj.toString();
                }
                return chain.convert(enumObj.getValue());
            }
        };
    }

    public FlagSet createFlagSet() {
        FlagSet flagSet = Enum.createFlagSet(this.getClass());
        if (flagSet != null) {
            return (FlagSet)flagSet.set((Flags)((Object)this));
        }
        return null;
    }

    public Flags setImmutable() {
        return this.createFlagSet().setImmutable();
    }

    public Flags and(Flags flags) {
        return this.createFlagSet().and(flags);
    }

    public Flags andNot(Flags flags) {
        return this.createFlagSet().andNot(flags);
    }

    public Flags or(Flags flags) {
        return this.createFlagSet().or(flags);
    }

    public Flags xor(Flags flags) {
        return this.createFlagSet().xor(flags);
    }

    public Flags clear() {
        return this.createFlagSet().clear();
    }

    public Flags clear(Flags flags) {
        return this.createFlagSet().clear(flags);
    }

    public Flags set(Flags flags) {
        return this.createFlagSet().set(flags);
    }

    public boolean test(Flags flags) {
        return this.createFlagSet().test(flags);
    }

    public boolean testAll(Flags flags) {
        return this.createFlagSet().test(flags);
    }

    public int compareTo(Object otherEnum) {
        if (!this.getClass().equals(otherEnum.getClass())) {
            throw new IllegalArgumentException(MessageFormat.format("Could not compare object of \"{0}\" with object of \"{1}\"", this.getClass().getName(), otherEnum.getClass().getName()));
        }
        return ((Comparable)this.value).compareTo(((Enum)otherEnum).value);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        return this.value.equals(((Enum)obj).value);
    }

    public int hashCode() {
        return this.getClass().hashCode() ^ this.value.hashCode();
    }

    public String toString() {
        return this.name;
    }

    protected Object readResolve() throws ObjectStreamException {
        Enum enumObj = Enum.getEnumByName(this.getClass(), this.getName());
        if (enumObj == null || !enumObj.value.equals(this.value)) {
            throw new InvalidClassException(this.getClass().getName());
        }
        return enumObj;
    }

    protected static abstract class EnumType {
        private Object value;
        final ListMap nameMap = new ArrayHashMap();
        final ListMap valueMap = new ArrayHashMap();
        boolean flagSetClassExists = true;
        Class flagSetClass;
        FlagSet fullSet;

        protected EnumType() {
        }

        final Object setValue(Object value, boolean flagMode) {
            this.value = value;
            if (flagMode && !this.isPowerOfTwo(value)) {
                throw new IllegalArgumentException(MessageFormat.format("The flag value \"{0}\" is not the power of 2", value));
            }
            return value;
        }

        final Object getNextValue(boolean flagMode) {
            this.value = this.getNextValue(this.value, flagMode);
            if (flagMode && this.isZero(this.value)) {
                throw new UnsupportedOperationException("The flag value is out of range");
            }
            return this.value;
        }

        protected abstract Class getUnderlyingClass();

        protected abstract Object getNextValue(Object var1, boolean var2);

        protected abstract boolean isZero(Object var1);

        protected abstract boolean isPowerOfTwo(Object var1);
    }
}

