/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.toolkit.util.resourcebundle.xml;

import com.alibaba.toolkit.util.ContextClassLoader;
import com.alibaba.toolkit.util.collection.ArrayHashMap;
import com.alibaba.toolkit.util.collection.ListMap;
import com.alibaba.toolkit.util.enumeration.Enum;
import com.alibaba.toolkit.util.resourcebundle.ResourceBundle;
import com.alibaba.toolkit.util.resourcebundle.ResourceBundleCreateException;
import com.alibaba.toolkit.util.resourcebundle.ResourceBundleEnumeration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import org.dom4j.Document;
import org.dom4j.Node;

public class XMLResourceBundle
extends ResourceBundle {
    protected ListMap values = new ArrayHashMap();

    public XMLResourceBundle(Document doc) throws ResourceBundleCreateException {
        for (Node groupNode : doc.selectNodes("/resource-bundle/group")) {
            this.initGroup(groupNode);
        }
        for (Node resourceNode : doc.selectNodes("/resource-bundle/message | /resource-bundle/map | /resource-bundle/list")) {
            this.initResource(resourceNode, null);
        }
    }

    protected void initGroup(Node groupNode) throws ResourceBundleCreateException {
        String enumTypeName = (String)groupNode.selectObject("string(@enum)");
        Class enumType = null;
        if (enumTypeName.length() > 0) {
            try {
                enumType = ContextClassLoader.loadClass(enumTypeName);
            }
            catch (ClassNotFoundException e) {
                throw new ResourceBundleCreateException("Specified Enum class \"{0}\" not found in context class loader \"{1}\"", new Object[]{enumTypeName, ContextClassLoader.getClassLoader()}, e);
            }
        }
        for (Node resourceNode : groupNode.selectNodes("message | map | list")) {
            this.initResource(resourceNode, enumType);
        }
    }

    protected void initResource(Node resourceNode, Class enumType) throws ResourceBundleCreateException {
        String id = (String)resourceNode.selectObject("string(@id)");
        if (enumType != null) {
            Enum enumObj = Enum.getEnumByName(enumType, id);
            if (enumObj == null) {
                throw new ResourceBundleCreateException("Invalid Enum ID \"{0}\" for Enum class \"{1}\"", new Object[]{id, enumType.getName()}, null);
            }
            id = enumObj.toString();
        }
        Object value = null;
        String type = resourceNode.getName();
        if ("message".equals(type)) {
            value = this.getMessageResource(id, resourceNode);
        } else if ("map".equals(type)) {
            value = this.getMapResource(id, resourceNode);
        } else if ("list".equals(type)) {
            value = this.getListResource(id, resourceNode);
        }
        if (this.values.containsKey(id)) {
            throw new ResourceBundleCreateException("Duplicated resource key \"{0}\"", new Object[]{id}, null);
        }
        this.values.put(id, value);
    }

    protected Object getMessageResource(String id, Node resourceNode) throws ResourceBundleCreateException {
        return resourceNode.selectObject("normalize-space(data)");
    }

    protected Object getMapResource(String id, Node resourceNode) throws ResourceBundleCreateException {
        ArrayHashMap map = new ArrayHashMap();
        for (Node mapItemNode : resourceNode.selectNodes("message | map | list")) {
            Object mapKey = mapItemNode.selectObject("string(@id)");
            if (map.containsKey(id)) {
                throw new ResourceBundleCreateException("Duplicated mapped resource key \"{0}\" for resource \"{1}\"", new Object[]{mapKey, id}, null);
            }
            String mapItemType = mapItemNode.getName();
            Object value = null;
            if ("message".equals(mapItemType)) {
                value = this.getMessageResource(id, mapItemNode);
            } else if ("map".equals(mapItemType)) {
                value = this.getMapResource(id, mapItemNode);
            } else if ("list".equals(mapItemType)) {
                value = this.getListResource(id, mapItemNode);
            }
            map.put(mapKey, value);
        }
        return Collections.unmodifiableMap(map);
    }

    protected Object getListResource(String id, Node resourceNode) throws ResourceBundleCreateException {
        ArrayList<Object> list = new ArrayList<Object>();
        for (Node listItemNode : resourceNode.selectNodes("message | map | list")) {
            String listItemType = listItemNode.getName();
            Object value = null;
            if ("message".equals(listItemType)) {
                value = this.getMessageResource(id, listItemNode);
            } else if ("map".equals(listItemType)) {
                value = this.getMapResource(id, listItemNode);
            } else if ("list".equals(listItemType)) {
                value = this.getListResource(id, listItemNode);
            }
            list.add(value);
        }
        return Collections.unmodifiableList(list);
    }

    protected Object handleGetObject(String key) {
        return this.values.get(key);
    }

    public Enumeration getKeys() {
        java.util.ResourceBundle parent = this.getParent();
        return new ResourceBundleEnumeration(this.values.keySet(), parent != null ? parent.getKeys() : null);
    }
}

