/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.maven.plugin.autoconfig;

import com.alibaba.antx.config.ConfigRuntimeImpl;
import com.alibaba.antx.expand.ExpanderRuntimeImpl;
import com.alibaba.antx.util.CharsetUtil;
import com.alibaba.citrus.logconfig.LogConfigurator;
import java.io.File;
import java.io.OutputStream;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

public class AutoconfigMojo
extends AbstractMojo {
    private File dest;
    private File explodedDirectory;
    private boolean exploding;
    private String charset;
    private boolean strict;
    private Boolean interactive;
    private boolean skip;
    private String type;
    private File userProperties;
    private Patterns descriptors;
    private Patterns packages;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            return;
        }
        String interactiveMode = this.interactive == null ? "auto" : (this.interactive != false ? "on" : "off");
        if (this.dest.exists()) {
            if (this.charset == null) {
                this.charset = CharsetUtil.detectedSystemCharset();
            }
            this.getLog().info((CharSequence)"-------------------------------------------------");
            this.getLog().info((CharSequence)("Detected system charset encoding: " + this.charset));
            this.getLog().info((CharSequence)"If your can't read the following text, specify correct one like this: ");
            this.getLog().info((CharSequence)"");
            this.getLog().info((CharSequence)"  mvn -Dautoconfig.charset=yourcharset");
            this.getLog().info((CharSequence)"");
            LogConfigurator.getConfigurator().configureDefault(false, this.charset);
            ConfigRuntimeImpl runtimeImpl = new ConfigRuntimeImpl(System.in, (OutputStream)System.out, (OutputStream)System.err, this.charset);
            runtimeImpl.setInteractiveMode(interactiveMode);
            runtimeImpl.setDests(new String[]{this.dest.getAbsolutePath()});
            runtimeImpl.setType(this.type);
            if (this.descriptors != null) {
                runtimeImpl.setDescriptorPatterns(this.descriptors.getIncludes(), this.descriptors.getExcludes());
            }
            if (this.packages != null) {
                runtimeImpl.setPackagePatterns(this.packages.getIncludes(), this.packages.getExcludes());
            }
            if (this.userProperties != null) {
                runtimeImpl.setUserPropertiesFile(this.userProperties.getAbsolutePath(), null);
            }
            this.getLog().info((CharSequence)("Configuring " + this.dest.getAbsolutePath() + ", interactiveMode=" + interactiveMode + ", strict=" + this.strict));
            this.getLog().info((CharSequence)"-------------------------------------------------");
            try {
                if (!runtimeImpl.start() && this.strict) {
                    throw new RuntimeException("undefined placeholders");
                }
            }
            catch (Exception e) {
                runtimeImpl.error((Throwable)e);
                throw new MojoExecutionException("Autoconfig failed", e);
            }
            if (this.exploding && this.explodedDirectory != null) {
                this.unpack(this.dest, this.explodedDirectory);
            }
        } else {
            this.getLog().error((CharSequence)("Dest directory or file for autoconfig does not exist: " + this.dest.getAbsolutePath()));
        }
    }

    public void unpack(File srcfile, File destdir) throws MojoExecutionException {
        ExpanderRuntimeImpl expander = new ExpanderRuntimeImpl(System.in, (OutputStream)System.out, (OutputStream)System.err, this.charset);
        expander.getExpander().setSrcfile(srcfile.getAbsolutePath());
        expander.getExpander().setDestdir(destdir.getAbsolutePath());
        expander.start();
    }

    public static class Patterns {
        private String[] includes;
        private String[] excludes;

        public String[] getIncludes() {
            return this.includes;
        }

        public void setIncludes(String[] includes) {
            this.includes = includes;
        }

        public String[] getExcludes() {
            return this.excludes;
        }

        public void setExcludes(String[] excludes) {
            this.excludes = excludes;
        }
    }
}

