/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.autoconfigure.memory;

import com.alibaba.cloud.ai.autoconfigure.memory.OracleChatMemoryProperties;
import com.alibaba.cloud.ai.memory.jdbc.OracleChatMemoryRepository;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jdbc.JdbcTemplateAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.jdbc.core.JdbcTemplate;

@AutoConfiguration(after={JdbcTemplateAutoConfiguration.class})
@ConditionalOnClass(value={OracleChatMemoryRepository.class, DataSource.class, JdbcTemplate.class})
@ConditionalOnProperty(prefix="spring.ai.memory.oracle", name={"enabled"}, havingValue="true", matchIfMissing=false)
@EnableConfigurationProperties(value={OracleChatMemoryProperties.class})
public class OracleChatMemoryAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(OracleChatMemoryAutoConfiguration.class);

    @Bean
    @Qualifier(value="oracleChatMemoryRepository")
    @ConditionalOnMissingBean(name={"oracleChatMemoryRepository"})
    OracleChatMemoryRepository oracleChatMemoryRepository(JdbcTemplate jdbcTemplate) {
        logger.info("Configuring Oracle chat memory repository");
        return OracleChatMemoryRepository.oracleBuilder().jdbcTemplate(jdbcTemplate).build();
    }
}

