/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.circuitbreaker.sentinel.feign;

import com.alibaba.cloud.circuitbreaker.sentinel.SentinelConfigBuilder;
import com.alibaba.cloud.circuitbreaker.sentinel.feign.SentinelFeignClientProperties;
import com.alibaba.csp.sentinel.EntryType;
import com.alibaba.csp.sentinel.slots.block.degrade.DegradeRuleManager;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.cloud.client.circuitbreaker.AbstractCircuitBreakerFactory;
import org.springframework.cloud.context.scope.refresh.RefreshScopeRefreshedEvent;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationListener;
import org.springframework.core.annotation.AnnotationUtils;

public class CircuitBreakerRuleChangeListener
implements ApplicationContextAware,
ApplicationListener<RefreshScopeRefreshedEvent>,
SmartInitializingSingleton {
    private static final Logger LOGGER = LoggerFactory.getLogger(CircuitBreakerRuleChangeListener.class);
    private SentinelFeignClientProperties properties;
    private SentinelFeignClientProperties propertiesBackup;
    private AbstractCircuitBreakerFactory circuitBreakerFactory;
    private ApplicationContext applicationContext;

    public void onApplicationEvent(RefreshScopeRefreshedEvent event) {
        this.ensureReady();
        if (Objects.equals(this.properties, this.propertiesBackup)) {
            return;
        }
        this.clearRules();
        this.configureDefault();
        this.configureCustom();
        this.updateBackup();
        LOGGER.info("Sentinel circuit beaker rules refreshed: \n" + this.prettyPrint(this.properties.getRules()));
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void afterSingletonsInstantiated() {
        this.propertiesBackup = ((SentinelFeignClientProperties)this.applicationContext.getBean(SentinelFeignClientProperties.class)).copy();
    }

    private void ensureReady() {
        String[] names;
        if (this.circuitBreakerFactory == null && (names = this.applicationContext.getBeanNamesForType(AbstractCircuitBreakerFactory.class)).length >= 1) {
            this.circuitBreakerFactory = (AbstractCircuitBreakerFactory)this.applicationContext.getBean(names[0], AbstractCircuitBreakerFactory.class);
        }
        if (this.properties == null) {
            this.properties = (SentinelFeignClientProperties)this.applicationContext.getBean(SentinelFeignClientProperties.class);
        }
    }

    private void clearRules() {
        this.clearCircuitBreakerFactory();
        this.clearFeignClientRulesInDegradeManager();
    }

    private void configureDefault() {
        CircuitBreakerRuleChangeListener.configureDefault(this.properties, this.circuitBreakerFactory);
    }

    private void configureCustom() {
        CircuitBreakerRuleChangeListener.configureCustom(this.properties, this.circuitBreakerFactory);
    }

    private void clearCircuitBreakerFactory() {
        Optional.ofNullable(CircuitBreakerRuleChangeListener.getConfigurations(this.circuitBreakerFactory)).ifPresent(Map::clear);
    }

    private void clearFeignClientRulesInDegradeManager() {
        this.propertiesBackup.getRules().keySet().stream().filter(key -> !Objects.equals(key, this.propertiesBackup.getDefaultRule())).forEach(resource -> Optional.ofNullable(DegradeRuleManager.getRulesOfResource((String)resource)).ifPresent(Set::clear));
        Arrays.stream(this.applicationContext.getBeanNamesForAnnotation(FeignClient.class)).filter(beanName -> beanName.contains(".")).map(beanName -> {
            try {
                return Class.forName(beanName);
            }
            catch (ClassNotFoundException ignore) {
                return null;
            }
        }).filter(Objects::nonNull).forEach(clazz -> {
            FeignClient anno = clazz.getAnnotation(FeignClient.class);
            if (anno == null || AnnotationUtils.getValue((Annotation)anno) == null) {
                return;
            }
            String feignClientName = AnnotationUtils.getValue((Annotation)anno).toString();
            Optional.ofNullable(DegradeRuleManager.getRulesOfResource((String)feignClientName)).ifPresent(Set::clear);
        });
    }

    private void updateBackup() {
        this.propertiesBackup = this.properties.copy();
    }

    private String prettyPrint(Object o) {
        try {
            return new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT).writeValueAsString(o);
        }
        catch (JsonProcessingException e) {
            LOGGER.error("JSON serialization err.", (Throwable)e);
            return "__JSON format err__";
        }
    }

    public static void configureCustom(SentinelFeignClientProperties properties, AbstractCircuitBreakerFactory factory) {
        properties.getRules().forEach((resourceName, degradeRules) -> {
            if (!Objects.equals(properties.getDefaultRule(), resourceName)) {
                factory.configure(builder -> ((SentinelConfigBuilder)builder).rules(properties.getRules().getOrDefault(resourceName, new ArrayList())), new String[]{resourceName});
            }
        });
    }

    public static void configureDefault(SentinelFeignClientProperties properties, AbstractCircuitBreakerFactory factory) {
        List defaultConfigurations = properties.getRules().getOrDefault(properties.getDefaultRule(), new ArrayList());
        factory.configureDefault(resourceName -> new SentinelConfigBuilder(resourceName.toString()).entryType(EntryType.OUT).rules(defaultConfigurations).build());
    }

    public static Map getConfigurations(AbstractCircuitBreakerFactory circuitBreakerFactory) {
        try {
            Method method = AbstractCircuitBreakerFactory.class.getDeclaredMethod("getConfigurations", new Class[0]);
            method.setAccessible(true);
            return (Map)method.invoke((Object)circuitBreakerFactory, new Object[0]);
        }
        catch (Exception exception) {
            return Collections.emptyMap();
        }
    }
}

