/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.circuitbreaker.sentinel.feign;

import com.alibaba.cloud.circuitbreaker.sentinel.feign.CircuitBreakerRuleChangeListener;
import feign.Feign;
import feign.Target;
import java.lang.reflect.Method;
import java.util.Map;
import org.springframework.cloud.client.circuitbreaker.AbstractCircuitBreakerFactory;
import org.springframework.cloud.openfeign.CircuitBreakerNameResolver;

public class FeignClientCircuitNameResolver
implements CircuitBreakerNameResolver {
    private final Map configurations;

    public FeignClientCircuitNameResolver(AbstractCircuitBreakerFactory factory) {
        this.configurations = CircuitBreakerRuleChangeListener.getConfigurations(factory);
    }

    public String resolveCircuitBreakerName(String feignClientName, Target<?> target, Method method) {
        String key = this.getKey(feignClientName, target, method);
        if (this.configurations != null && this.configurations.containsKey(key)) {
            return key;
        }
        return feignClientName;
    }

    private String getKey(String feignClientName, Target<?> target, Method method) {
        String key = Feign.configKey((Class)target.type(), (Method)method);
        return feignClientName + key.substring(key.indexOf(35));
    }
}

