/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.nacos.config.server.environment;

import com.alibaba.nacos.config.server.model.ConfigInfo;
import com.alibaba.nacos.config.server.service.PersistService;
import java.io.IOException;
import java.io.StringReader;
import java.util.Map;
import java.util.Properties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.config.environment.Environment;
import org.springframework.cloud.config.environment.PropertySource;
import org.springframework.cloud.config.server.environment.EnvironmentRepository;
import org.springframework.util.StringUtils;

public class NacosEnvironmentRepository
implements EnvironmentRepository {
    @Autowired
    private PersistService persistService;

    public Environment findOne(String application, String profile, String label) {
        String dataId = application + "-" + profile + ".properties";
        ConfigInfo configInfo = this.persistService.findConfigInfo(dataId, "DEFAULT_GROUP", label);
        return this.createEnvironment(configInfo, application, profile);
    }

    private Environment createEnvironment(ConfigInfo configInfo, String application, String profile) {
        Environment environment = new Environment(application, new String[]{profile});
        Properties properties = this.createProperties(configInfo);
        String propertySourceName = String.format("Nacos[application : %s , profile : %s]", application, profile);
        PropertySource propertySource = new PropertySource(propertySourceName, (Map)properties);
        environment.add(propertySource);
        return environment;
    }

    private Properties createProperties(ConfigInfo configInfo) {
        String content;
        Properties properties = new Properties();
        String string = content = configInfo == null ? null : configInfo.getContent();
        if (StringUtils.hasText((String)content)) {
            try {
                properties.load(new StringReader(content));
            }
            catch (IOException e) {
                throw new IllegalStateException("The format of content is a properties");
            }
        }
        return properties;
    }

    private static String[] of(String ... values) {
        return values;
    }
}

