/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.dubbo.openfeign;

import com.alibaba.cloud.dubbo.metadata.RestMethodMetadata;
import com.alibaba.cloud.dubbo.openfeign.FeignMethodMetadata;
import com.alibaba.cloud.dubbo.service.DubboGenericServiceExecutionContext;
import com.alibaba.cloud.dubbo.service.DubboGenericServiceExecutionContextFactory;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Map;
import org.apache.dubbo.common.utils.PojoUtils;
import org.apache.dubbo.rpc.service.GenericService;
import org.springframework.util.ClassUtils;

public class DubboInvocationHandler
implements InvocationHandler {
    private final Map<Method, FeignMethodMetadata> feignMethodMetadataMap;
    private final InvocationHandler defaultInvocationHandler;
    private final DubboGenericServiceExecutionContextFactory contextFactory;
    private final ClassLoader classLoader;

    public DubboInvocationHandler(Map<Method, FeignMethodMetadata> feignMethodMetadataMap, InvocationHandler defaultInvocationHandler, ClassLoader classLoader, DubboGenericServiceExecutionContextFactory contextFactory) {
        this.feignMethodMetadataMap = feignMethodMetadataMap;
        this.defaultInvocationHandler = defaultInvocationHandler;
        this.classLoader = classLoader;
        this.contextFactory = contextFactory;
    }

    @Override
    public Object invoke(Object proxy, Method feignMethod, Object[] args) throws Throwable {
        FeignMethodMetadata feignMethodMetadata = this.feignMethodMetadataMap.get(feignMethod);
        if (feignMethodMetadata == null) {
            return this.defaultInvocationHandler.invoke(proxy, feignMethod, args);
        }
        GenericService dubboGenericService = feignMethodMetadata.getDubboGenericService();
        RestMethodMetadata dubboRestMethodMetadata = feignMethodMetadata.getDubboRestMethodMetadata();
        RestMethodMetadata feignRestMethodMetadata = feignMethodMetadata.getFeignMethodMetadata();
        DubboGenericServiceExecutionContext context = this.contextFactory.create(dubboRestMethodMetadata, feignRestMethodMetadata, args);
        String methodName = context.getMethodName();
        String[] parameterTypes = context.getParameterTypes();
        Object[] parameters = context.getParameters();
        Object result = dubboGenericService.$invoke(methodName, parameterTypes, parameters);
        Class<?> returnType = this.getReturnType(dubboRestMethodMetadata);
        return PojoUtils.realize((Object)result, returnType);
    }

    private Class<?> getReturnType(RestMethodMetadata dubboRestMethodMetadata) {
        String returnType = dubboRestMethodMetadata.getReturnType();
        return ClassUtils.resolveClassName((String)returnType, (ClassLoader)this.classLoader);
    }
}

