/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.dubbo.registry;

import com.alibaba.cloud.dubbo.metadata.repository.DubboServiceMetadataRepository;
import com.alibaba.cloud.dubbo.registry.SpringCloudRegistry;
import com.alibaba.cloud.dubbo.service.DubboGenericServiceFactory;
import com.alibaba.cloud.dubbo.service.DubboMetadataServiceProxy;
import com.alibaba.cloud.dubbo.util.JSONUtils;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.registry.Registry;
import org.apache.dubbo.registry.RegistryFactory;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.context.ConfigurableApplicationContext;

public class SpringCloudRegistryFactory
implements RegistryFactory {
    public static String PROTOCOL = "spring-cloud";
    public static String ADDRESS = "localhost";
    private static String SERVICES_LOOKUP_SCHEDULER_THREAD_NAME_PREFIX = System.getProperty("dubbo.services.lookup.scheduler.thread.name.prefix ", "dubbo-services-lookup-");
    private static ConfigurableApplicationContext applicationContext;
    private DiscoveryClient discoveryClient;
    private DubboServiceMetadataRepository dubboServiceMetadataRepository;
    private DubboMetadataServiceProxy dubboMetadataConfigServiceProxy;
    private JSONUtils jsonUtils;
    private DubboGenericServiceFactory dubboGenericServiceFactory;
    private volatile boolean initialized = false;

    public static void setApplicationContext(ConfigurableApplicationContext applicationContext) {
        SpringCloudRegistryFactory.applicationContext = applicationContext;
    }

    protected void init() {
        if (this.initialized || applicationContext == null) {
            return;
        }
        this.discoveryClient = (DiscoveryClient)applicationContext.getBean(DiscoveryClient.class);
        this.dubboServiceMetadataRepository = (DubboServiceMetadataRepository)applicationContext.getBean(DubboServiceMetadataRepository.class);
        this.dubboMetadataConfigServiceProxy = (DubboMetadataServiceProxy)applicationContext.getBean(DubboMetadataServiceProxy.class);
        this.jsonUtils = (JSONUtils)applicationContext.getBean(JSONUtils.class);
        this.dubboGenericServiceFactory = (DubboGenericServiceFactory)applicationContext.getBean(DubboGenericServiceFactory.class);
    }

    public Registry getRegistry(URL url) {
        this.init();
        return new SpringCloudRegistry(url, this.discoveryClient, this.dubboServiceMetadataRepository, this.dubboMetadataConfigServiceProxy, this.jsonUtils, this.dubboGenericServiceFactory, applicationContext);
    }
}

