/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.dubbo.registry;

import com.alibaba.cloud.dubbo.metadata.repository.DubboServiceMetadataRepository;
import com.alibaba.cloud.dubbo.registry.event.ServiceInstancesChangedEvent;
import com.alibaba.cloud.dubbo.service.DubboGenericServiceFactory;
import com.alibaba.cloud.dubbo.service.DubboMetadataService;
import com.alibaba.cloud.dubbo.service.DubboMetadataServiceProxy;
import com.alibaba.cloud.dubbo.util.DubboMetadataUtils;
import com.alibaba.cloud.dubbo.util.JSONUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.URLBuilder;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.registry.NotifyListener;
import org.apache.dubbo.registry.support.FailbackRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.annotation.Order;
import org.springframework.util.StringUtils;

public class DubboCloudRegistry
extends FailbackRegistry {
    public static final String SERVICES_LOOKUP_INTERVAL_PARAM_NAME = "dubbo.services.lookup.interval";
    protected static final String DUBBO_METADATA_SERVICE_CLASS_NAME = DubboMetadataService.class.getName();
    private static final Set<String> REGISTER_LISTENERS = new HashSet<String>();
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final DiscoveryClient discoveryClient;
    private final DubboServiceMetadataRepository repository;
    private final DubboMetadataServiceProxy dubboMetadataConfigServiceProxy;
    private final JSONUtils jsonUtils;
    private final DubboGenericServiceFactory dubboGenericServiceFactory;
    private final DubboMetadataUtils dubboMetadataUtils;
    private final long servicesLookupInterval;
    private final ConfigurableApplicationContext applicationContext;
    private final String currentApplicationName;

    public DubboCloudRegistry(URL url, DiscoveryClient discoveryClient, DubboServiceMetadataRepository repository, DubboMetadataServiceProxy dubboMetadataConfigServiceProxy, JSONUtils jsonUtils, DubboGenericServiceFactory dubboGenericServiceFactory, ConfigurableApplicationContext applicationContext) {
        super(url);
        this.servicesLookupInterval = url.getParameter(SERVICES_LOOKUP_INTERVAL_PARAM_NAME, 60L);
        this.discoveryClient = discoveryClient;
        this.repository = repository;
        this.dubboMetadataConfigServiceProxy = dubboMetadataConfigServiceProxy;
        this.jsonUtils = jsonUtils;
        this.dubboGenericServiceFactory = dubboGenericServiceFactory;
        this.applicationContext = applicationContext;
        this.dubboMetadataUtils = this.getBean(DubboMetadataUtils.class);
        this.currentApplicationName = this.dubboMetadataUtils.getCurrentApplicationName();
    }

    private <T> T getBean(Class<T> beanClass) {
        return (T)this.applicationContext.getBean(beanClass);
    }

    protected boolean shouldRegister(URL url) {
        String side = url.getParameter("side");
        boolean should = "provider".equals(side);
        if (!should && this.logger.isDebugEnabled()) {
            this.logger.debug("The URL[{}] should not be registered.", (Object)url.toString());
        }
        return should;
    }

    public final void doRegister(URL url) {
        if (!this.shouldRegister(url)) {
            return;
        }
        this.repository.exportURL(url);
    }

    public final void doUnregister(URL url) {
        if (!this.shouldRegister(url)) {
            return;
        }
        this.repository.unexportURL(url);
    }

    public final void doSubscribe(URL url, NotifyListener listener) {
        if (this.isAdminURL(url)) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("This feature about admin will be supported in the future.");
            }
        } else if (this.isDubboMetadataServiceURL(url)) {
            this.subscribeDubboMetadataServiceURLs(url, listener);
        } else {
            this.subscribeURLs(url, listener);
        }
    }

    private void subscribeURLs(final URL url, final NotifyListener listener) {
        this.subscribeURLs(url, this.getServices(url), listener);
        this.registerServiceInstancesChangedListener(url, new ApplicationListener<ServiceInstancesChangedEvent>(){
            private final URL url2subscribe;
            {
                this.url2subscribe = url;
            }

            @Order
            public void onApplicationEvent(ServiceInstancesChangedEvent event) {
                String serviceName;
                Set serviceNames = DubboCloudRegistry.this.getServices(url);
                if (serviceNames.contains(serviceName = event.getServiceName())) {
                    DubboCloudRegistry.this.subscribeURLs(url, serviceNames, listener);
                }
            }

            public String toString() {
                return "ServiceInstancesChangedEventListener:" + url.getServiceKey();
            }
        });
    }

    private void subscribeURLs(URL url, Set<String> serviceNames, NotifyListener listener) {
        LinkedList<URL> subscribedURLs = new LinkedList<URL>();
        serviceNames.forEach(serviceName -> this.subscribeURLs(url, (List<URL>)subscribedURLs, (String)serviceName, () -> this.getServiceInstances((String)serviceName)));
        this.notifyAllSubscribedURLs(url, subscribedURLs, listener);
    }

    private void registerServiceInstancesChangedListener(URL url, ApplicationListener<ServiceInstancesChangedEvent> listener) {
        String listenerId = this.generateId(url);
        if (REGISTER_LISTENERS.add(listenerId)) {
            this.applicationContext.addApplicationListener(listener);
        }
    }

    private void subscribeURLs(URL subscribedURL, List<URL> subscribedURLs, String serviceName, Supplier<List<ServiceInstance>> serviceInstancesSupplier) {
        List<ServiceInstance> serviceInstances = serviceInstancesSupplier.get();
        this.subscribeURLs(subscribedURL, subscribedURLs, serviceName, serviceInstances);
    }

    private void subscribeURLs(URL subscribedURL, List<URL> subscribedURLs, String serviceName, List<ServiceInstance> serviceInstances) {
        if (org.springframework.util.CollectionUtils.isEmpty(serviceInstances) && this.logger.isWarnEnabled()) {
            this.logger.warn(String.format("There is no instance in service[name : %s]", serviceName));
        }
        List<URL> exportedURLs = this.getExportedURLs(subscribedURL, serviceName, serviceInstances);
        subscribedURLs.addAll(exportedURLs);
    }

    private List<URL> getExportedURLs(URL subscribedURL, String serviceName, List<ServiceInstance> serviceInstances) {
        List<ServiceInstance> validServiceInstances = this.filter(serviceInstances);
        if (CollectionUtils.isEmpty(validServiceInstances)) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("There is no instance from service[name : {}], and then Dubbo Service[key : {}] will not be available , please make sure the further impact", (Object)serviceName, (Object)subscribedURL.getServiceKey());
            }
            return Collections.emptyList();
        }
        List<URL> subscribedURLs = this.cloneExportedURLs(subscribedURL, serviceInstances);
        validServiceInstances.clear();
        return subscribedURLs;
    }

    private List<URL> cloneExportedURLs(URL subscribedURL, List<ServiceInstance> serviceInstances) {
        LinkedList<URL> clonedExportedURLs = new LinkedList<URL>();
        serviceInstances.forEach(serviceInstance -> {
            String host = serviceInstance.getHost();
            this.getTemplateExportedURLs(subscribedURL, serviceInstances).stream().map(templateURL -> templateURL.removeParameter("timestamp")).map(templateURL -> templateURL.removeParameter("pid")).map(templateURL -> {
                String protocol = templateURL.getProtocol();
                Integer port = this.repository.getDubboProtocolPort((ServiceInstance)serviceInstance, protocol);
                if (Objects.equals(templateURL.getHost(), host) && Objects.equals(templateURL.getPort(), port)) {
                    return templateURL;
                }
                if (port == null) {
                    if (this.logger.isWarnEnabled()) {
                        this.logger.warn("The protocol[{}] port of Dubbo  service instance[host : {}] can't be resolved", (Object)protocol, (Object)host);
                    }
                    return null;
                }
                URLBuilder clonedURLBuilder = URLBuilder.from((URL)templateURL).setHost(host).setPort(port.intValue());
                return clonedURLBuilder.build();
            }).filter(Objects::nonNull).forEach(clonedExportedURLs::add);
        });
        return clonedExportedURLs;
    }

    private List<URL> getTemplateExportedURLs(URL subscribedURL, List<ServiceInstance> serviceInstances) {
        DubboMetadataService dubboMetadataService = this.getProxy(serviceInstances);
        List<URL> templateExportedURLs = Collections.emptyList();
        if (dubboMetadataService != null) {
            templateExportedURLs = this.getExportedURLs(dubboMetadataService, subscribedURL);
        } else if (this.logger.isWarnEnabled()) {
            this.logger.warn("The metadata of Dubbo service[key : {}] still can't be found, it could effect the further Dubbo service invocation", (Object)subscribedURL.getServiceKey());
        }
        return templateExportedURLs;
    }

    private DubboMetadataService getProxy(List<ServiceInstance> serviceInstances) {
        return this.dubboMetadataConfigServiceProxy.getProxy(serviceInstances);
    }

    private List<ServiceInstance> filter(Collection<ServiceInstance> serviceInstances) {
        return serviceInstances.stream().filter(this::isDubboServiceInstance).collect(Collectors.toList());
    }

    private boolean isDubboServiceInstance(ServiceInstance serviceInstance) {
        Map metadata = serviceInstance.getMetadata();
        return metadata.containsKey("dubbo.metadata-service.urls");
    }

    private Set<String> getServices(URL url) {
        Set<String> subscribedServices = this.repository.getSubscribedServices();
        return subscribedServices;
    }

    private void notifyAllSubscribedURLs(URL url, List<URL> subscribedURLs, NotifyListener listener) {
        if (CollectionUtils.isEmpty(subscribedURLs)) {
            subscribedURLs.add(this.emptyURL(url));
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("The subscribed URL[{}] will notify all URLs : {}", (Object)url, subscribedURLs);
        }
        listener.notify(subscribedURLs);
    }

    private List<ServiceInstance> getServiceInstances(Iterable<String> serviceNames) {
        return StreamSupport.stream(serviceNames.spliterator(), false).map(this::getServiceInstances).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private List<ServiceInstance> getServiceInstances(String serviceName) {
        return StringUtils.hasText((String)serviceName) ? this.doGetServiceInstances(serviceName) : Collections.emptyList();
    }

    private List<ServiceInstance> doGetServiceInstances(String serviceName) {
        List serviceInstances;
        block2: {
            serviceInstances = Collections.emptyList();
            try {
                serviceInstances = this.discoveryClient.getInstances(serviceName);
            }
            catch (Exception e) {
                if (!this.logger.isErrorEnabled()) break block2;
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return serviceInstances;
    }

    private String generateId(URL url) {
        return url.toString();
    }

    private URL emptyURL(URL url) {
        return URLBuilder.from((URL)url).setProtocol("empty").removeParameter("category").build();
    }

    private List<URL> getExportedURLs(DubboMetadataService dubboMetadataService, URL subscribedURL) {
        String serviceInterface = subscribedURL.getServiceInterface();
        String group = subscribedURL.getParameter("group");
        String version = subscribedURL.getParameter("version");
        String subscribedProtocol = subscribedURL.getParameter("protocol");
        String exportedURLsJSON = dubboMetadataService.getExportedURLs(serviceInterface, group, version);
        return this.jsonUtils.toURLs(exportedURLsJSON).stream().filter((? super T exportedURL) -> subscribedProtocol == null || subscribedProtocol.equalsIgnoreCase(exportedURL.getProtocol())).collect(Collectors.toList());
    }

    private void subscribeDubboMetadataServiceURLs(final URL subscribedURL, final NotifyListener listener) {
        this.subscribeDubboMetadataServiceURLs(subscribedURL, listener, this.getServiceName(subscribedURL));
        if (this.containsProviderCategory(subscribedURL)) {
            this.registerServiceInstancesChangedListener(subscribedURL, new ApplicationListener<ServiceInstancesChangedEvent>(){
                private final URL url2subscribe;
                {
                    this.url2subscribe = subscribedURL;
                }

                @Order(value=0x7FFFFFFE)
                public void onApplicationEvent(ServiceInstancesChangedEvent event) {
                    String serviceName;
                    String sourceServiceName = event.getServiceName();
                    if (Objects.equals(sourceServiceName, serviceName = DubboCloudRegistry.this.getServiceName(subscribedURL))) {
                        DubboCloudRegistry.this.subscribeDubboMetadataServiceURLs(subscribedURL, listener, sourceServiceName);
                    }
                }

                public String toString() {
                    return "ServiceInstancesChangedEventListener:" + subscribedURL.getServiceKey();
                }
            });
        }
    }

    private String getServiceName(URL subscribedURL) {
        return subscribedURL.getParameter("group");
    }

    private void subscribeDubboMetadataServiceURLs(URL subscribedURL, NotifyListener listener, String serviceName) {
        String serviceInterface = subscribedURL.getServiceInterface();
        String version = subscribedURL.getParameter("version");
        String protocol = subscribedURL.getParameter("protocol");
        List<ServiceInstance> serviceInstances = this.getServiceInstances(serviceName);
        List<URL> urls = this.dubboMetadataUtils.getDubboMetadataServiceURLs(serviceInstances, serviceInterface, version, protocol);
        this.notifyAllSubscribedURLs(subscribedURL, urls, listener);
    }

    private boolean containsProviderCategory(URL subscribedURL) {
        String category = subscribedURL.getParameter("category");
        return category == null ? false : category.contains("provider");
    }

    public final void doUnsubscribe(URL url, NotifyListener listener) {
    }

    public boolean isAvailable() {
        return !this.discoveryClient.getServices().isEmpty();
    }

    protected boolean isAdminURL(URL url) {
        return "admin".equals(url.getProtocol());
    }

    protected boolean isDubboMetadataServiceURL(URL url) {
        return DUBBO_METADATA_SERVICE_CLASS_NAME.equals(url.getServiceInterface());
    }
}

