/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.dubbo.registry;

import com.alibaba.cloud.dubbo.env.DubboCloudProperties;
import com.alibaba.cloud.dubbo.registry.DubboCloudRegistry;
import com.alibaba.cloud.dubbo.registry.event.ServiceInstancesChangedEvent;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.client.ServiceInstance;

public class ReSubscribeManager {
    private final Logger logger = LoggerFactory.getLogger(ReSubscribeManager.class);
    private final Map<String, ReSubscribeMetadataJob> reConnectJobMap = new ConcurrentHashMap<String, ReSubscribeMetadataJob>();
    private final ScheduledThreadPoolExecutor reConnectPool = new ScheduledThreadPoolExecutor(5);
    private final DubboCloudRegistry registry;
    private final DubboCloudProperties properties;

    public ReSubscribeManager(DubboCloudRegistry registry) {
        this.registry = registry;
        this.properties = registry.getBean(DubboCloudProperties.class);
        this.reConnectPool.setKeepAliveTime(10L, TimeUnit.MINUTES);
        this.reConnectPool.allowCoreThreadTimeOut(true);
    }

    public void onRefreshSuccess(ServiceInstancesChangedEvent event) {
        this.reConnectJobMap.remove(event.getServiceName());
    }

    public void onRefreshFail(ServiceInstancesChangedEvent event) {
        String serviceName = event.getServiceName();
        int count = 1;
        if (event instanceof FakeServiceInstancesChangedEvent) {
            count = ((FakeServiceInstancesChangedEvent)event).getCount() + 1;
        }
        if (count >= this.properties.getMaxReSubscribeMetadataTimes()) {
            this.logger.error("reSubscribe failed too many times, serviceName = {}, count = {}", (Object)serviceName, (Object)count);
            return;
        }
        ReSubscribeMetadataJob job = new ReSubscribeMetadataJob(serviceName, count);
        this.reConnectPool.schedule(job, (long)this.properties.getReSubscribeMetadataIntervial(), TimeUnit.SECONDS);
    }

    private static final class FakeServiceInstancesChangedEvent
    extends ServiceInstancesChangedEvent {
        private static final long serialVersionUID = -2832478604601472915L;
        private final int count;

        private FakeServiceInstancesChangedEvent(String serviceName, List<ServiceInstance> serviceInstances, int count) {
            super(serviceName, serviceInstances);
            this.count = count;
        }

        public int getCount() {
            return this.count;
        }
    }

    private final class ReSubscribeMetadataJob
    implements Runnable {
        private final String serviceName;
        private final int errorCounts;

        private ReSubscribeMetadataJob(String serviceName, int errorCounts) {
            this.errorCounts = errorCounts;
            this.serviceName = serviceName;
        }

        @Override
        public void run() {
            if (!ReSubscribeManager.this.reConnectJobMap.containsKey(this.serviceName) || ReSubscribeManager.this.reConnectJobMap.get(this.serviceName) != this) {
                return;
            }
            List<ServiceInstance> list = ReSubscribeManager.this.registry.getServiceInstances(this.serviceName);
            FakeServiceInstancesChangedEvent event = new FakeServiceInstancesChangedEvent(this.serviceName, list, this.errorCounts);
            ReSubscribeManager.this.registry.onApplicationEvent(event);
        }
    }
}

