/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.dubbo.registry;

import com.alibaba.cloud.dubbo.env.DubboCloudProperties;
import com.alibaba.cloud.dubbo.metadata.repository.DubboServiceMetadataRepository;
import com.alibaba.cloud.dubbo.registry.DubboCloudRegistry;
import com.alibaba.cloud.dubbo.registry.SpringCloudRegistry;
import com.alibaba.cloud.dubbo.service.DubboGenericServiceFactory;
import com.alibaba.cloud.dubbo.service.DubboMetadataServiceProxy;
import com.alibaba.cloud.dubbo.util.JSONUtils;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.registry.Registry;
import org.apache.dubbo.registry.support.AbstractRegistryFactory;
import org.apache.dubbo.registry.support.FailbackRegistry;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.context.ConfigurableApplicationContext;

public class SpringCloudRegistryFactory
extends AbstractRegistryFactory {
    public static String PROTOCOL = "spring-cloud";
    public static String ADDRESS = "localhost";
    private static ConfigurableApplicationContext applicationContext;
    private DiscoveryClient discoveryClient;
    private DubboServiceMetadataRepository dubboServiceMetadataRepository;
    private DubboMetadataServiceProxy dubboMetadataConfigServiceProxy;
    private JSONUtils jsonUtils;
    private DubboGenericServiceFactory dubboGenericServiceFactory;

    public static void setApplicationContext(ConfigurableApplicationContext applicationContext) {
        SpringCloudRegistryFactory.applicationContext = applicationContext;
    }

    protected void init() {
        this.discoveryClient = (DiscoveryClient)applicationContext.getBean(DiscoveryClient.class);
        this.dubboServiceMetadataRepository = (DubboServiceMetadataRepository)applicationContext.getBean(DubboServiceMetadataRepository.class);
        this.dubboMetadataConfigServiceProxy = (DubboMetadataServiceProxy)applicationContext.getBean(DubboMetadataServiceProxy.class);
        this.jsonUtils = (JSONUtils)applicationContext.getBean(JSONUtils.class);
        this.dubboGenericServiceFactory = (DubboGenericServiceFactory)applicationContext.getBean(DubboGenericServiceFactory.class);
    }

    public Registry createRegistry(URL url) {
        FailbackRegistry registry;
        this.init();
        DubboCloudProperties dubboCloudProperties = (DubboCloudProperties)applicationContext.getBean(DubboCloudProperties.class);
        switch (dubboCloudProperties.getRegistryType()) {
            case "spring-cloud": {
                registry = new SpringCloudRegistry(url, this.discoveryClient, this.dubboServiceMetadataRepository, this.dubboMetadataConfigServiceProxy, this.jsonUtils, this.dubboGenericServiceFactory, applicationContext);
                break;
            }
            default: {
                registry = new DubboCloudRegistry(url, this.discoveryClient, this.dubboServiceMetadataRepository, this.dubboMetadataConfigServiceProxy, this.jsonUtils, applicationContext);
            }
        }
        return registry;
    }
}

