/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.dubbo.service.parameter;

import com.alibaba.cloud.dubbo.http.HttpServerRequest;
import com.alibaba.cloud.dubbo.http.converter.HttpMessageConverterHolder;
import com.alibaba.cloud.dubbo.http.util.HttpMessageConverterResolver;
import com.alibaba.cloud.dubbo.metadata.MethodParameterMetadata;
import com.alibaba.cloud.dubbo.metadata.RestMethodMetadata;
import com.alibaba.cloud.dubbo.service.parameter.AbstractDubboGenericServiceParameterResolver;
import java.io.IOException;
import java.util.Collections;
import java.util.Objects;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.http.HttpMessageConverters;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;

public class RequestBodyServiceParameterResolver
extends AbstractDubboGenericServiceParameterResolver {
    public static final int DEFAULT_ORDER = 7;
    @Autowired
    private ObjectProvider<HttpMessageConverters> httpMessageConverters;
    private HttpMessageConverterResolver httpMessageConverterResolver;

    public RequestBodyServiceParameterResolver() {
        this.setOrder(7);
    }

    @PostConstruct
    public void init() {
        HttpMessageConverters httpMessageConverters = (HttpMessageConverters)this.httpMessageConverters.getIfAvailable();
        this.httpMessageConverterResolver = new HttpMessageConverterResolver(httpMessageConverters == null ? Collections.emptyList() : httpMessageConverters.getConverters(), this.getClassLoader());
    }

    private boolean supportParameter(RestMethodMetadata restMethodMetadata, MethodParameterMetadata methodParameterMetadata) {
        Integer bodyIndex;
        Integer index = methodParameterMetadata.getIndex();
        if (!Objects.equals(index, bodyIndex = restMethodMetadata.getBodyIndex())) {
            return false;
        }
        Class<?> parameterType = this.resolveClass(methodParameterMetadata.getType());
        Class<?> bodyType = this.resolveClass(restMethodMetadata.getBodyType());
        return Objects.equals(parameterType, bodyType);
    }

    @Override
    public Object resolve(RestMethodMetadata restMethodMetadata, MethodParameterMetadata methodParameterMetadata, HttpServerRequest request) {
        if (!this.supportParameter(restMethodMetadata, methodParameterMetadata)) {
            return null;
        }
        Object result = null;
        Class<?> parameterType = this.resolveClass(methodParameterMetadata.getType());
        HttpMessageConverterHolder holder = this.httpMessageConverterResolver.resolve(request, parameterType);
        if (holder != null) {
            HttpMessageConverter<?> converter = holder.getConverter();
            try {
                result = converter.read(parameterType, (HttpInputMessage)request);
            }
            catch (IOException e) {
                throw new HttpMessageNotReadableException("I/O error while reading input message", (Throwable)e, null);
            }
        }
        return result;
    }

    @Override
    public Object resolve(RestMethodMetadata restMethodMetadata, MethodParameterMetadata methodParameterMetadata, RestMethodMetadata clientRestMethodMetadata, Object[] arguments) {
        if (!this.supportParameter(restMethodMetadata, methodParameterMetadata)) {
            return null;
        }
        Integer clientBodyIndex = clientRestMethodMetadata.getBodyIndex();
        return arguments[clientBodyIndex];
    }
}

