/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.cluster.client.codec;

import com.alibaba.csp.sentinel.cluster.codec.request.RequestEntityWriter;
import com.alibaba.csp.sentinel.cluster.codec.response.ResponseEntityDecoder;
import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.spi.SpiLoader;

public final class ClientEntityCodecProvider {
    private static RequestEntityWriter requestEntityWriter = null;
    private static ResponseEntityDecoder responseEntityDecoder = null;

    private static void resolveInstance() {
        RequestEntityWriter writer = (RequestEntityWriter)SpiLoader.of(RequestEntityWriter.class).loadFirstInstance();
        if (writer == null) {
            RecordLog.warn((String)"[ClientEntityCodecProvider] No existing request entity writer, resolve failed", (Object[])new Object[0]);
        } else {
            requestEntityWriter = writer;
            RecordLog.info((String)"[ClientEntityCodecProvider] Request entity writer resolved: {}", (Object[])new Object[]{requestEntityWriter.getClass().getCanonicalName()});
        }
        ResponseEntityDecoder decoder = (ResponseEntityDecoder)SpiLoader.of(ResponseEntityDecoder.class).loadFirstInstance();
        if (decoder == null) {
            RecordLog.warn((String)"[ClientEntityCodecProvider] No existing response entity decoder, resolve failed", (Object[])new Object[0]);
        } else {
            responseEntityDecoder = decoder;
            RecordLog.info((String)"[ClientEntityCodecProvider] Response entity decoder resolved: {}", (Object[])new Object[]{responseEntityDecoder.getClass().getCanonicalName()});
        }
    }

    public static RequestEntityWriter getRequestEntityWriter() {
        return requestEntityWriter;
    }

    public static ResponseEntityDecoder getResponseEntityDecoder() {
        return responseEntityDecoder;
    }

    private ClientEntityCodecProvider() {
    }

    static {
        ClientEntityCodecProvider.resolveInstance();
    }
}

