/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.adapter.spring.webmvc;

import com.alibaba.csp.sentinel.Entry;
import com.alibaba.csp.sentinel.EntryType;
import com.alibaba.csp.sentinel.SphU;
import com.alibaba.csp.sentinel.Tracer;
import com.alibaba.csp.sentinel.adapter.spring.webmvc.config.BaseWebMvcConfig;
import com.alibaba.csp.sentinel.context.ContextUtil;
import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.slots.block.BlockException;
import com.alibaba.csp.sentinel.util.AssertUtil;
import com.alibaba.csp.sentinel.util.StringUtil;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

public abstract class AbstractSentinelInterceptor
implements HandlerInterceptor {
    public static final String SENTINEL_SPRING_WEB_CONTEXT_NAME = "sentinel_spring_web_context";
    private static final String EMPTY_ORIGIN = "";
    private final BaseWebMvcConfig baseWebMvcConfig;

    public AbstractSentinelInterceptor(BaseWebMvcConfig config) {
        AssertUtil.notNull((Object)config, (String)"BaseWebMvcConfig should not be null");
        AssertUtil.assertNotBlank((String)config.getRequestAttributeName(), (String)"requestAttributeName should not be blank");
        this.baseWebMvcConfig = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        try {
            String resourceName = this.getResourceName(request);
            if (StringUtil.isNotEmpty((String)resourceName)) {
                String origin = this.parseOrigin(request);
                String contextName = this.getContextName(request);
                ContextUtil.enter((String)contextName, (String)origin);
                Entry entry = SphU.entry((String)resourceName, (int)1, (EntryType)EntryType.IN);
                this.setEntryInRequest(request, this.baseWebMvcConfig.getRequestAttributeName(), entry);
            }
            return true;
        }
        catch (BlockException e) {
            try {
                this.handleBlockException(request, response, e);
            }
            finally {
                ContextUtil.exit();
            }
            return false;
        }
    }

    protected abstract String getResourceName(HttpServletRequest var1);

    protected String getContextName(HttpServletRequest request) {
        return SENTINEL_SPRING_WEB_CONTEXT_NAME;
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        Entry entry = this.getEntryInRequest(request, this.baseWebMvcConfig.getRequestAttributeName());
        if (entry != null) {
            this.traceExceptionAndExit(entry, ex);
            this.removeEntryInRequest(request);
        }
        ContextUtil.exit();
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
    }

    protected void setEntryInRequest(HttpServletRequest request, String name, Entry entry) {
        Object attrVal = request.getAttribute(name);
        if (attrVal != null) {
            RecordLog.warn((String)"[{}] The attribute key '{}' already exists in request, please set `requestAttributeName`", (Object[])new Object[]{this.getClass().getSimpleName(), name});
        } else {
            request.setAttribute(name, (Object)entry);
        }
    }

    protected Entry getEntryInRequest(HttpServletRequest request, String attrKey) {
        Object entryObject = request.getAttribute(attrKey);
        return entryObject == null ? null : (Entry)entryObject;
    }

    protected void removeEntryInRequest(HttpServletRequest request) {
        request.removeAttribute(this.baseWebMvcConfig.getRequestAttributeName());
    }

    protected void traceExceptionAndExit(Entry entry, Exception ex) {
        if (entry != null) {
            if (ex != null) {
                Tracer.traceEntry((Throwable)ex, (Entry)entry);
            }
            entry.exit();
        }
    }

    protected void handleBlockException(HttpServletRequest request, HttpServletResponse response, BlockException e) throws Exception {
        if (this.baseWebMvcConfig.getBlockExceptionHandler() == null) {
            throw e;
        }
        this.baseWebMvcConfig.getBlockExceptionHandler().handle(request, response, e);
    }

    protected String parseOrigin(HttpServletRequest request) {
        String origin = EMPTY_ORIGIN;
        if (this.baseWebMvcConfig.getOriginParser() != null && StringUtil.isEmpty((String)(origin = this.baseWebMvcConfig.getOriginParser().parseOrigin(request)))) {
            return EMPTY_ORIGIN;
        }
        return origin;
    }
}

