/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.transport.config;

import com.alibaba.csp.sentinel.config.SentinelConfig;
import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.transport.endpoint.Endpoint;
import com.alibaba.csp.sentinel.transport.endpoint.Protocol;
import com.alibaba.csp.sentinel.util.HostNameUtil;
import com.alibaba.csp.sentinel.util.StringUtil;
import java.util.ArrayList;
import java.util.List;

public class TransportConfig {
    public static final String CONSOLE_SERVER = "csp.sentinel.dashboard.server";
    public static final String SERVER_PORT = "csp.sentinel.api.port";
    public static final String HEARTBEAT_INTERVAL_MS = "csp.sentinel.heartbeat.interval.ms";
    public static final String HEARTBEAT_CLIENT_IP = "csp.sentinel.heartbeat.client.ip";
    public static final String HEARTBEAT_API_PATH = "csp.sentinel.heartbeat.api.path";
    public static final String HEARTBEAT_DEFAULT_PATH = "/registry/machine";
    private static int runtimePort = -1;

    public static Long getHeartbeatIntervalMs() {
        String interval = SentinelConfig.getConfig((String)HEARTBEAT_INTERVAL_MS);
        try {
            return interval == null ? null : Long.valueOf(Long.parseLong(interval));
        }
        catch (Exception ex) {
            RecordLog.warn((String)("[TransportConfig] Failed to parse heartbeat interval: " + interval), (Object[])new Object[0]);
            return null;
        }
    }

    public static List<Endpoint> getConsoleServerList() {
        String config = SentinelConfig.getConfig((String)CONSOLE_SERVER);
        ArrayList<Endpoint> list = new ArrayList<Endpoint>();
        if (StringUtil.isBlank((String)config)) {
            return list;
        }
        int pos = -1;
        int cur = 0;
        while (true) {
            pos = config.indexOf(44, cur);
            if (cur < config.length() - 1 && pos < 0) {
                pos = config.length();
            }
            if (pos < 0) break;
            if (pos <= cur) {
                ++cur;
                continue;
            }
            String ipPortStr = config.substring(cur, pos);
            cur = pos + 1;
            if (StringUtil.isBlank((String)ipPortStr)) continue;
            ipPortStr = ipPortStr.trim();
            int port = 80;
            Protocol protocol = Protocol.HTTP;
            if (ipPortStr.startsWith("http://")) {
                ipPortStr = ipPortStr.substring(7);
            } else if (ipPortStr.startsWith("https://")) {
                ipPortStr = ipPortStr.substring(8);
                port = 443;
                protocol = Protocol.HTTPS;
            }
            int index = ipPortStr.indexOf(":");
            if (index == 0) continue;
            String host = ipPortStr;
            if (index >= 0) {
                try {
                    port = Integer.parseInt(ipPortStr.substring(index + 1));
                    if (port <= 1 || port >= 65535) {
                        throw new RuntimeException("Port number [" + port + "] over range");
                    }
                }
                catch (Exception e) {
                    RecordLog.warn((String)("Parse port of dashboard server failed: " + ipPortStr), (Throwable)e);
                    continue;
                }
                host = ipPortStr.substring(0, index);
            }
            list.add(new Endpoint(protocol, host, port));
        }
        return list;
    }

    public static int getRuntimePort() {
        return runtimePort;
    }

    public static String getPort() {
        if (runtimePort > 0) {
            return String.valueOf(runtimePort);
        }
        return SentinelConfig.getConfig((String)SERVER_PORT, (boolean)true);
    }

    public static void setRuntimePort(int port) {
        runtimePort = port;
    }

    public static String getHeartbeatClientIp() {
        String ip = SentinelConfig.getConfig((String)HEARTBEAT_CLIENT_IP, (boolean)true);
        if (StringUtil.isBlank((String)ip)) {
            ip = HostNameUtil.getIp();
        }
        return ip;
    }

    public static String getHeartbeatApiPath() {
        String apiPath = SentinelConfig.getConfig((String)HEARTBEAT_API_PATH);
        if (StringUtil.isBlank((String)apiPath)) {
            return HEARTBEAT_DEFAULT_PATH;
        }
        if (!apiPath.startsWith("/")) {
            apiPath = "/" + apiPath;
        }
        return apiPath;
    }
}

