/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.ast.statement;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLLimit;
import com.alibaba.druid.sql.ast.SQLObjectImpl;
import com.alibaba.druid.sql.ast.SQLOrderBy;
import com.alibaba.druid.sql.ast.SQLReplaceable;
import com.alibaba.druid.sql.ast.expr.SQLAllColumnExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLIntegerExpr;
import com.alibaba.druid.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.druid.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.ast.statement.SQLSelectGroupByClause;
import com.alibaba.druid.sql.ast.statement.SQLSelectItem;
import com.alibaba.druid.sql.ast.statement.SQLSelectOrderByItem;
import com.alibaba.druid.sql.ast.statement.SQLSelectQuery;
import com.alibaba.druid.sql.ast.statement.SQLSubqueryTableSource;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import com.alibaba.druid.util.FnvHash;
import java.util.ArrayList;
import java.util.List;

public class SQLSelectQueryBlock
extends SQLObjectImpl
implements SQLSelectQuery,
SQLReplaceable {
    private boolean bracket = false;
    protected int distionOption;
    protected final List<SQLSelectItem> selectList = new ArrayList<SQLSelectItem>();
    protected SQLTableSource from;
    protected SQLExprTableSource into;
    protected SQLExpr where;
    protected SQLExpr startWith;
    protected SQLExpr connectBy;
    protected boolean prior = false;
    protected boolean noCycle = false;
    protected SQLOrderBy orderBySiblings;
    protected SQLSelectGroupByClause groupBy;
    protected SQLOrderBy orderBy;
    protected boolean parenthesized = false;
    protected boolean forUpdate = false;
    protected boolean noWait = false;
    protected SQLExpr waitTime;
    protected SQLLimit limit;
    protected List<SQLExpr> forUpdateOf;
    protected List<SQLExpr> distributeBy;
    protected List<SQLSelectOrderByItem> sortBy;

    public SQLExprTableSource getInto() {
        return this.into;
    }

    public void setInto(SQLExpr into) {
        this.setInto(new SQLExprTableSource(into));
    }

    public void setInto(SQLExprTableSource into) {
        if (into != null) {
            into.setParent(this);
        }
        this.into = into;
    }

    public SQLSelectGroupByClause getGroupBy() {
        return this.groupBy;
    }

    public void setGroupBy(SQLSelectGroupByClause groupBy) {
        if (groupBy != null) {
            groupBy.setParent(this);
        }
        this.groupBy = groupBy;
    }

    public SQLExpr getWhere() {
        return this.where;
    }

    public void setWhere(SQLExpr where) {
        if (where != null) {
            where.setParent(this);
        }
        this.where = where;
    }

    public void addWhere(SQLExpr condition) {
        if (condition == null) {
            return;
        }
        this.where = this.where == null ? condition : SQLBinaryOpExpr.and(this.where, condition);
    }

    public SQLOrderBy getOrderBy() {
        return this.orderBy;
    }

    public void setOrderBy(SQLOrderBy orderBy) {
        if (orderBy != null) {
            orderBy.setParent(this);
        }
        this.orderBy = orderBy;
    }

    public SQLOrderBy getOrderBySiblings() {
        return this.orderBySiblings;
    }

    public void setOrderBySiblings(SQLOrderBy orderBySiblings) {
        if (orderBySiblings != null) {
            orderBySiblings.setParent(this);
        }
        this.orderBySiblings = orderBySiblings;
    }

    public int getDistionOption() {
        return this.distionOption;
    }

    public void setDistionOption(int distionOption) {
        this.distionOption = distionOption;
    }

    public List<SQLSelectItem> getSelectList() {
        return this.selectList;
    }

    public void addSelectItem(SQLSelectItem item) {
        this.selectList.add(item);
        item.setParent(this);
    }

    public void addSelectItem(SQLExpr expr) {
        this.addSelectItem(new SQLSelectItem(expr));
    }

    public void addSelectItem(SQLExpr expr, String alias) {
        this.addSelectItem(new SQLSelectItem(expr, alias));
    }

    public SQLTableSource getFrom() {
        return this.from;
    }

    public void setFrom(SQLTableSource from) {
        if (from != null) {
            from.setParent(this);
        }
        this.from = from;
    }

    public void setFrom(SQLSelectQueryBlock queryBlock, String alias) {
        if (queryBlock == null) {
            this.from = null;
            return;
        }
        this.setFrom(new SQLSelect(queryBlock), alias);
    }

    public void setFrom(SQLSelect select, String alias) {
        if (select == null) {
            this.from = null;
            return;
        }
        SQLSubqueryTableSource from = new SQLSubqueryTableSource(select);
        from.setAlias(alias);
        this.setFrom(from);
    }

    public void setFrom(String tableName, String alias) {
        SQLExprTableSource from = tableName == null || tableName.length() == 0 ? null : new SQLExprTableSource(new SQLIdentifierExpr(tableName), alias);
        this.setFrom(from);
    }

    public boolean isParenthesized() {
        return this.parenthesized;
    }

    public void setParenthesized(boolean parenthesized) {
        this.parenthesized = parenthesized;
    }

    public boolean isForUpdate() {
        return this.forUpdate;
    }

    public void setForUpdate(boolean forUpdate) {
        this.forUpdate = forUpdate;
    }

    public boolean isNoWait() {
        return this.noWait;
    }

    public void setNoWait(boolean noWait) {
        this.noWait = noWait;
    }

    public SQLExpr getWaitTime() {
        return this.waitTime;
    }

    public void setWaitTime(SQLExpr waitTime) {
        if (waitTime != null) {
            waitTime.setParent(this);
        }
        this.waitTime = waitTime;
    }

    public SQLLimit getLimit() {
        return this.limit;
    }

    public void setLimit(SQLLimit limit) {
        if (limit != null) {
            limit.setParent(this);
        }
        this.limit = limit;
    }

    public SQLExpr getFirst() {
        if (this.limit == null) {
            return null;
        }
        return this.limit.getRowCount();
    }

    public void setFirst(SQLExpr first) {
        if (this.limit == null) {
            this.limit = new SQLLimit();
        }
        this.limit.setRowCount(first);
    }

    public SQLExpr getOffset() {
        if (this.limit == null) {
            return null;
        }
        return this.limit.getOffset();
    }

    public void setOffset(SQLExpr offset) {
        if (this.limit == null) {
            this.limit = new SQLLimit();
        }
        this.limit.setOffset(offset);
    }

    public boolean isPrior() {
        return this.prior;
    }

    public void setPrior(boolean prior) {
        this.prior = prior;
    }

    public SQLExpr getStartWith() {
        return this.startWith;
    }

    public void setStartWith(SQLExpr startWith) {
        if (startWith != null) {
            startWith.setParent(this);
        }
        this.startWith = startWith;
    }

    public SQLExpr getConnectBy() {
        return this.connectBy;
    }

    public void setConnectBy(SQLExpr connectBy) {
        if (connectBy != null) {
            connectBy.setParent(this);
        }
        this.connectBy = connectBy;
    }

    public boolean isNoCycle() {
        return this.noCycle;
    }

    public void setNoCycle(boolean noCycle) {
        this.noCycle = noCycle;
    }

    public List<SQLExpr> getDistributeBy() {
        return this.distributeBy;
    }

    public List<SQLSelectOrderByItem> getSortBy() {
        return this.sortBy;
    }

    @Override
    protected void accept0(SQLASTVisitor visitor) {
        if (visitor.visit(this)) {
            this.acceptChild(visitor, this.selectList);
            this.acceptChild(visitor, this.from);
            this.acceptChild(visitor, this.into);
            this.acceptChild(visitor, this.where);
            this.acceptChild(visitor, this.startWith);
            this.acceptChild(visitor, this.connectBy);
            this.acceptChild(visitor, this.groupBy);
            this.acceptChild(visitor, this.orderBy);
            this.acceptChild(visitor, this.waitTime);
            this.acceptChild(visitor, this.limit);
        }
        visitor.endVisit(this);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Boolean.valueOf(this.parenthesized).hashCode();
        result = 31 * result + this.distionOption;
        result = 31 * result + (this.from == null ? 0 : this.from.hashCode());
        result = 31 * result + (this.groupBy == null ? 0 : this.groupBy.hashCode());
        result = 31 * result + (this.into == null ? 0 : this.into.hashCode());
        result = 31 * result + (this.selectList == null ? 0 : this.selectList.hashCode());
        result = 31 * result + (this.where == null ? 0 : this.where.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SQLSelectQueryBlock other = (SQLSelectQueryBlock)obj;
        if (this.parenthesized ^ other.parenthesized) {
            return false;
        }
        if (this.distionOption != other.distionOption) {
            return false;
        }
        if (this.from == null ? other.from != null : !this.from.equals(other.from)) {
            return false;
        }
        if (this.groupBy == null ? other.groupBy != null : !this.groupBy.equals(other.groupBy)) {
            return false;
        }
        if (this.into == null ? other.into != null : !this.into.equals(other.into)) {
            return false;
        }
        if (this.selectList == null ? other.selectList != null : !this.selectList.equals(other.selectList)) {
            return false;
        }
        return !(this.where == null ? other.where != null : !this.where.equals(other.where));
    }

    @Override
    public SQLSelectQueryBlock clone() {
        SQLSelectQueryBlock x = new SQLSelectQueryBlock();
        this.cloneTo(x);
        return x;
    }

    public List<SQLExpr> getForUpdateOf() {
        if (this.forUpdateOf == null) {
            this.forUpdateOf = new ArrayList<SQLExpr>(1);
        }
        return this.forUpdateOf;
    }

    public int getForUpdateOfSize() {
        if (this.forUpdateOf == null) {
            return 0;
        }
        return this.forUpdateOf.size();
    }

    public void cloneTo(SQLSelectQueryBlock x) {
        x.distionOption = this.distionOption;
        for (SQLSelectItem item : this.selectList) {
            x.addSelectItem(item.clone());
        }
        if (this.from != null) {
            x.setFrom(this.from.clone());
        }
        if (this.into != null) {
            x.setInto(this.into.clone());
        }
        if (this.where != null) {
            x.setWhere(this.where.clone());
        }
        if (this.startWith != null) {
            x.setStartWith(this.startWith.clone());
        }
        if (this.connectBy != null) {
            x.setConnectBy(this.connectBy.clone());
        }
        x.prior = this.prior;
        x.noCycle = this.noCycle;
        if (this.orderBySiblings != null) {
            x.setOrderBySiblings(this.orderBySiblings.clone());
        }
        if (this.groupBy != null) {
            x.setGroupBy(this.groupBy.clone());
        }
        if (this.orderBy != null) {
            x.setOrderBy(this.orderBy.clone());
        }
        x.parenthesized = this.parenthesized;
        x.forUpdate = this.forUpdate;
        x.noWait = this.noWait;
        if (this.waitTime != null) {
            x.setWaitTime(this.waitTime.clone());
        }
        if (this.limit != null) {
            x.setLimit(this.limit.clone());
        }
    }

    @Override
    public boolean isBracket() {
        return this.bracket;
    }

    @Override
    public void setBracket(boolean bracket) {
        this.bracket = bracket;
    }

    public SQLTableSource findTableSource(String alias) {
        if (this.from == null) {
            return null;
        }
        return this.from.findTableSource(alias);
    }

    public SQLTableSource findTableSourceWithColumn(String column) {
        if (this.from == null) {
            return null;
        }
        return this.from.findTableSourceWithColumn(column);
    }

    public SQLTableSource findTableSourceWithColumn(long columnHash) {
        if (this.from == null) {
            return null;
        }
        return this.from.findTableSourceWithColumn(columnHash);
    }

    @Override
    public boolean replace(SQLExpr expr, SQLExpr target) {
        if (this.where == expr) {
            this.setWhere(target);
            return true;
        }
        return false;
    }

    public SQLSelectItem findSelectItem(String ident) {
        if (ident == null) {
            return null;
        }
        long hash = FnvHash.hashCode64(ident);
        return this.findSelectItem(hash);
    }

    public SQLSelectItem findSelectItem(long identHash) {
        for (SQLSelectItem item : this.selectList) {
            if (!item.match(identHash)) continue;
            return item;
        }
        return null;
    }

    public boolean selectItemHasAllColumn() {
        return this.selectItemHasAllColumn(true);
    }

    public boolean selectItemHasAllColumn(boolean recursive) {
        for (SQLSelectItem item : this.selectList) {
            SQLSelect subSelect;
            SQLSelectQueryBlock queryBlock;
            SQLExpr expr = item.getExpr();
            boolean allColumn = expr instanceof SQLAllColumnExpr || expr instanceof SQLPropertyExpr && ((SQLPropertyExpr)expr).getName().equals("*");
            if (!allColumn) continue;
            if (recursive && this.from instanceof SQLSubqueryTableSource && (queryBlock = (subSelect = ((SQLSubqueryTableSource)this.from).select).getQueryBlock()) != null) {
                return queryBlock.selectItemHasAllColumn();
            }
            return true;
        }
        return false;
    }

    public SQLSelectItem findAllColumnSelectItem() {
        SQLSelectItem allColumnItem = null;
        for (SQLSelectItem item : this.selectList) {
            boolean allColumn;
            SQLExpr expr = item.getExpr();
            boolean bl = allColumn = expr instanceof SQLAllColumnExpr || expr instanceof SQLPropertyExpr && ((SQLPropertyExpr)expr).getName().equals("*");
            if (allColumnItem != null) {
                return null;
            }
            allColumnItem = item;
        }
        return allColumnItem;
    }

    public SQLColumnDefinition findColumn(String columnName) {
        if (this.from == null) {
            return null;
        }
        long hash = FnvHash.hashCode64(columnName);
        return this.from.findColumn(hash);
    }

    public void addCondition(SQLExpr expr) {
        if (expr == null) {
            return;
        }
        this.setWhere(SQLBinaryOpExpr.and(this.where, expr));
    }

    public void limit(int rowCount, int offset) {
        SQLLimit limit = new SQLLimit();
        limit.setRowCount(new SQLIntegerExpr(rowCount));
        if (offset > 0) {
            limit.setOffset(new SQLIntegerExpr(offset));
        }
        this.setLimit(limit);
    }
}

