/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.ast.statement;

import com.alibaba.druid.sql.ast.SQLLimit;
import com.alibaba.druid.sql.ast.SQLObjectImpl;
import com.alibaba.druid.sql.ast.SQLOrderBy;
import com.alibaba.druid.sql.ast.statement.SQLSelectQuery;
import com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.druid.sql.ast.statement.SQLUnionOperator;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;

public class SQLUnionQuery
extends SQLObjectImpl
implements SQLSelectQuery {
    private boolean bracket = false;
    private SQLSelectQuery left;
    private SQLSelectQuery right;
    private SQLUnionOperator operator = SQLUnionOperator.UNION;
    private SQLOrderBy orderBy;
    private SQLLimit limit;

    public SQLUnionOperator getOperator() {
        return this.operator;
    }

    public void setOperator(SQLUnionOperator operator) {
        this.operator = operator;
    }

    public SQLUnionQuery() {
    }

    public SQLUnionQuery(SQLSelectQuery left, SQLUnionOperator operator, SQLSelectQuery right) {
        this.setLeft(left);
        this.operator = operator;
        this.setRight(right);
    }

    public SQLSelectQuery getLeft() {
        return this.left;
    }

    public void setLeft(SQLSelectQuery left) {
        if (left != null) {
            left.setParent(this);
        }
        this.left = left;
    }

    public SQLSelectQuery getRight() {
        return this.right;
    }

    public void setRight(SQLSelectQuery right) {
        if (right != null) {
            right.setParent(this);
        }
        this.right = right;
    }

    public SQLOrderBy getOrderBy() {
        return this.orderBy;
    }

    public void setOrderBy(SQLOrderBy orderBy) {
        if (orderBy != null) {
            orderBy.setParent(this);
        }
        this.orderBy = orderBy;
    }

    @Override
    protected void accept0(SQLASTVisitor visitor) {
        if (visitor.visit(this)) {
            this.acceptChild(visitor, this.left);
            this.acceptChild(visitor, this.right);
            this.acceptChild(visitor, this.orderBy);
            this.acceptChild(visitor, this.limit);
        }
        visitor.endVisit(this);
    }

    public SQLLimit getLimit() {
        return this.limit;
    }

    public void setLimit(SQLLimit limit) {
        if (limit != null) {
            limit.setParent(this);
        }
        this.limit = limit;
    }

    @Override
    public boolean isBracket() {
        return this.bracket;
    }

    @Override
    public void setBracket(boolean bracket) {
        this.bracket = bracket;
    }

    @Override
    public SQLUnionQuery clone() {
        SQLUnionQuery x = new SQLUnionQuery();
        x.bracket = this.bracket;
        if (this.left != null) {
            x.setLeft(this.left.clone());
        }
        if (this.right != null) {
            x.setRight(this.right.clone());
        }
        x.operator = this.operator;
        if (this.orderBy != null) {
            x.setOrderBy(this.orderBy.clone());
        }
        if (this.limit != null) {
            x.setLimit(this.limit.clone());
        }
        return x;
    }

    public SQLSelectQueryBlock getFirstQueryBlock() {
        if (this.left instanceof SQLSelectQueryBlock) {
            return (SQLSelectQueryBlock)this.left;
        }
        if (this.left instanceof SQLUnionQuery) {
            return ((SQLUnionQuery)this.left).getFirstQueryBlock();
        }
        return null;
    }
}

