/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.mysql.parser;

import com.alibaba.druid.sql.ast.SQLDataTypeImpl;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLOrderingSpecification;
import com.alibaba.druid.sql.ast.SQLPartition;
import com.alibaba.druid.sql.ast.SQLPartitionBy;
import com.alibaba.druid.sql.ast.SQLPartitionByHash;
import com.alibaba.druid.sql.ast.SQLPartitionByList;
import com.alibaba.druid.sql.ast.SQLPartitionByRange;
import com.alibaba.druid.sql.ast.SQLSubPartitionBy;
import com.alibaba.druid.sql.ast.SQLSubPartitionByHash;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLIntegerExpr;
import com.alibaba.druid.sql.ast.expr.SQLNumberExpr;
import com.alibaba.druid.sql.ast.statement.SQLAssignItem;
import com.alibaba.druid.sql.ast.statement.SQLCheck;
import com.alibaba.druid.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.druid.sql.ast.statement.SQLCreateTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.ast.statement.SQLTableConstraint;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import com.alibaba.druid.sql.dialect.mysql.ast.MySqlKey;
import com.alibaba.druid.sql.dialect.mysql.ast.MySqlPrimaryKey;
import com.alibaba.druid.sql.dialect.mysql.ast.MySqlUnique;
import com.alibaba.druid.sql.dialect.mysql.ast.MysqlForeignKey;
import com.alibaba.druid.sql.dialect.mysql.ast.expr.MySqlOrderingExpr;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlCreateTableStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlPartitionByKey;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlSubPartitionByKey;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlSubPartitionByList;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlTableIndex;
import com.alibaba.druid.sql.dialect.mysql.parser.MySqlExprParser;
import com.alibaba.druid.sql.dialect.mysql.parser.MySqlSelectParser;
import com.alibaba.druid.sql.parser.ParserException;
import com.alibaba.druid.sql.parser.SQLCreateTableParser;
import com.alibaba.druid.sql.parser.SQLExprParser;
import com.alibaba.druid.sql.parser.Token;

public class MySqlCreateTableParser
extends SQLCreateTableParser {
    public MySqlCreateTableParser(String sql) {
        super(new MySqlExprParser(sql));
    }

    public MySqlCreateTableParser(SQLExprParser exprParser) {
        super(exprParser);
    }

    @Override
    public SQLCreateTableStatement parseCrateTable() {
        return this.parseCrateTable(true);
    }

    @Override
    public MySqlExprParser getExprParser() {
        return (MySqlExprParser)this.exprParser;
    }

    @Override
    public MySqlCreateTableStatement parseCrateTable(boolean acceptCreate) {
        SQLName name;
        MySqlCreateTableStatement stmt = new MySqlCreateTableStatement();
        if (acceptCreate) {
            if (this.lexer.hasComment() && this.lexer.isKeepComments()) {
                stmt.addBeforeComment(this.lexer.readAndResetComments());
            }
            this.accept(Token.CREATE);
        }
        if (this.lexer.identifierEquals("TEMPORARY")) {
            this.lexer.nextToken();
            stmt.setType(SQLCreateTableStatement.Type.GLOBAL_TEMPORARY);
        }
        this.accept(Token.TABLE);
        if (this.lexer.token() == Token.IF || this.lexer.identifierEquals("IF")) {
            this.lexer.nextToken();
            this.accept(Token.NOT);
            this.accept(Token.EXISTS);
            stmt.setIfNotExiists(true);
        }
        stmt.setName(this.exprParser.name());
        if (this.lexer.token() == Token.LIKE) {
            this.lexer.nextToken();
            name = this.exprParser.name();
            stmt.setLike(name);
        }
        if (this.lexer.token() == Token.LPAREN) {
            this.lexer.nextToken();
            if (this.lexer.token() == Token.LIKE) {
                this.lexer.nextToken();
                name = this.exprParser.name();
                stmt.setLike(name);
            } else {
                while (true) {
                    SQLColumnDefinition column;
                    if (this.lexer.token() == Token.IDENTIFIER || this.lexer.token() == Token.LITERAL_CHARS) {
                        column = this.exprParser.parseColumn();
                        stmt.getTableElementList().add(column);
                    } else if (this.lexer.token() == Token.CONSTRAINT || this.lexer.token() == Token.PRIMARY || this.lexer.token() == Token.UNIQUE) {
                        SQLTableConstraint constraint = this.parseConstraint();
                        stmt.getTableElementList().add(constraint);
                    } else if (this.lexer.token() == Token.INDEX) {
                        this.lexer.nextToken();
                        MySqlTableIndex idx = new MySqlTableIndex();
                        if (this.lexer.token() == Token.IDENTIFIER && !"USING".equalsIgnoreCase(this.lexer.stringVal())) {
                            idx.setName(this.exprParser.name());
                        }
                        if (this.lexer.identifierEquals("USING")) {
                            this.lexer.nextToken();
                            idx.setIndexType(this.lexer.stringVal());
                            this.lexer.nextToken();
                        }
                        this.accept(Token.LPAREN);
                        while (true) {
                            idx.addColumn(this.exprParser.parseSelectOrderByItem());
                            if (this.lexer.token() != Token.COMMA) break;
                            this.lexer.nextToken();
                        }
                        this.accept(Token.RPAREN);
                        if (this.lexer.identifierEquals("USING")) {
                            this.lexer.nextToken();
                            idx.setIndexType(this.lexer.stringVal());
                            this.lexer.nextToken();
                        }
                        stmt.getTableElementList().add(idx);
                    } else if (this.lexer.token() == Token.KEY) {
                        stmt.getTableElementList().add(this.parseConstraint());
                    } else if (this.lexer.token() == Token.PRIMARY) {
                        SQLTableConstraint pk = this.parseConstraint();
                        pk.setParent(stmt);
                        stmt.getTableElementList().add(pk);
                    } else if (this.lexer.token() == Token.FOREIGN) {
                        MysqlForeignKey fk = this.getExprParser().parseForeignKey();
                        fk.setParent(stmt);
                        stmt.getTableElementList().add(fk);
                    } else if (this.lexer.token() == Token.CHECK) {
                        SQLCheck check = this.exprParser.parseCheck();
                        stmt.getTableElementList().add(check);
                    } else {
                        column = this.exprParser.parseColumn();
                        stmt.getTableElementList().add(column);
                    }
                    if (this.lexer.token() != Token.COMMA) break;
                    this.lexer.nextToken();
                }
            }
            this.accept(Token.RPAREN);
        }
        while (true) {
            SQLPartitionBy partitionClause;
            SQLPartitionBy clause;
            if (this.lexer.token() == Token.COMMA) {
                this.lexer.nextToken();
            }
            if (this.lexer.identifierEquals("ENGINE")) {
                this.lexer.nextToken();
                if (this.lexer.token() == Token.EQ) {
                    this.lexer.nextToken();
                }
                SQLExpr expr = null;
                if (this.lexer.token() == Token.MERGE) {
                    expr = new SQLIdentifierExpr(this.lexer.stringVal());
                    this.lexer.nextToken();
                } else {
                    expr = this.exprParser.expr();
                }
                stmt.getTableOptions().put("ENGINE", expr);
                continue;
            }
            if (this.lexer.identifierEquals("AUTO_INCREMENT")) {
                this.lexer.nextToken();
                if (this.lexer.token() == Token.EQ) {
                    this.lexer.nextToken();
                }
                stmt.getTableOptions().put("AUTO_INCREMENT", this.exprParser.expr());
                continue;
            }
            if (this.lexer.identifierEquals("AVG_ROW_LENGTH")) {
                this.lexer.nextToken();
                if (this.lexer.token() == Token.EQ) {
                    this.lexer.nextToken();
                }
                stmt.getTableOptions().put("AVG_ROW_LENGTH", this.exprParser.expr());
                continue;
            }
            if (this.lexer.token() == Token.DEFAULT) {
                this.lexer.nextToken();
                this.parseTableOptionCharsetOrCollate(stmt);
                continue;
            }
            if (this.parseTableOptionCharsetOrCollate(stmt)) continue;
            if (this.lexer.identifierEquals("CHECKSUM")) {
                this.lexer.nextToken();
                if (this.lexer.token() == Token.EQ) {
                    this.lexer.nextToken();
                }
                stmt.getTableOptions().put("CHECKSUM", this.exprParser.expr());
                continue;
            }
            if (this.lexer.token() == Token.COMMENT) {
                this.lexer.nextToken();
                if (this.lexer.token() == Token.EQ) {
                    this.lexer.nextToken();
                }
                stmt.setComment(this.exprParser.expr());
                continue;
            }
            if (this.lexer.identifierEquals("CONNECTION")) {
                this.lexer.nextToken();
                if (this.lexer.token() == Token.EQ) {
                    this.lexer.nextToken();
                }
                stmt.getTableOptions().put("CONNECTION", this.exprParser.expr());
                continue;
            }
            if (this.lexer.identifierEquals("DATA")) {
                this.lexer.nextToken();
                this.acceptIdentifier("DIRECTORY");
                if (this.lexer.token() == Token.EQ) {
                    this.lexer.nextToken();
                }
                stmt.getTableOptions().put("DATA DIRECTORY", this.exprParser.expr());
                continue;
            }
            if (this.lexer.identifierEquals("DELAY_KEY_WRITE")) {
                this.lexer.nextToken();
                if (this.lexer.token() == Token.EQ) {
                    this.lexer.nextToken();
                }
                stmt.getTableOptions().put("DELAY_KEY_WRITE", this.exprParser.expr());
                continue;
            }
            if (this.lexer.identifierEquals("INDEX")) {
                this.lexer.nextToken();
                this.acceptIdentifier("DIRECTORY");
                if (this.lexer.token() == Token.EQ) {
                    this.lexer.nextToken();
                }
                stmt.getTableOptions().put("INDEX DIRECTORY", this.exprParser.expr());
                continue;
            }
            if (this.lexer.identifierEquals("INSERT_METHOD")) {
                this.lexer.nextToken();
                if (this.lexer.token() == Token.EQ) {
                    this.lexer.nextToken();
                }
                stmt.getTableOptions().put("INSERT_METHOD", this.exprParser.expr());
                continue;
            }
            if (this.lexer.identifierEquals("KEY_BLOCK_SIZE")) {
                this.lexer.nextToken();
                if (this.lexer.token() == Token.EQ) {
                    this.lexer.nextToken();
                }
                stmt.getTableOptions().put("KEY_BLOCK_SIZE", this.exprParser.expr());
                continue;
            }
            if (this.lexer.identifierEquals("MAX_ROWS")) {
                this.lexer.nextToken();
                if (this.lexer.token() == Token.EQ) {
                    this.lexer.nextToken();
                }
                stmt.getTableOptions().put("MAX_ROWS", this.exprParser.expr());
                continue;
            }
            if (this.lexer.identifierEquals("MIN_ROWS")) {
                this.lexer.nextToken();
                if (this.lexer.token() == Token.EQ) {
                    this.lexer.nextToken();
                }
                stmt.getTableOptions().put("MIN_ROWS", this.exprParser.expr());
                continue;
            }
            if (this.lexer.identifierEquals("PACK_KEYS")) {
                this.lexer.nextToken();
                if (this.lexer.token() == Token.EQ) {
                    this.lexer.nextToken();
                }
                stmt.getTableOptions().put("PACK_KEYS", this.exprParser.expr());
                continue;
            }
            if (this.lexer.identifierEquals("PASSWORD")) {
                this.lexer.nextToken();
                if (this.lexer.token() == Token.EQ) {
                    this.lexer.nextToken();
                }
                stmt.getTableOptions().put("PASSWORD", this.exprParser.expr());
                continue;
            }
            if (this.lexer.identifierEquals("ROW_FORMAT")) {
                this.lexer.nextToken();
                if (this.lexer.token() == Token.EQ) {
                    this.lexer.nextToken();
                }
                stmt.getTableOptions().put("ROW_FORMAT", this.exprParser.expr());
                continue;
            }
            if (this.lexer.identifierEquals("STATS_AUTO_RECALC")) {
                this.lexer.nextToken();
                if (this.lexer.token() == Token.EQ) {
                    this.lexer.nextToken();
                }
                stmt.getTableOptions().put("STATS_AUTO_RECALC", this.exprParser.expr());
                continue;
            }
            if (this.lexer.identifierEquals("STATS_PERSISTENT")) {
                this.lexer.nextToken();
                if (this.lexer.token() == Token.EQ) {
                    this.lexer.nextToken();
                }
                stmt.getTableOptions().put("STATS_PERSISTENT", this.exprParser.expr());
                continue;
            }
            if (this.lexer.identifierEquals("STATS_SAMPLE_PAGES")) {
                this.lexer.nextToken();
                if (this.lexer.token() == Token.EQ) {
                    this.lexer.nextToken();
                }
                stmt.getTableOptions().put("STATS_SAMPLE_PAGES", this.exprParser.expr());
                continue;
            }
            if (this.lexer.token() == Token.UNION) {
                this.lexer.nextToken();
                if (this.lexer.token() == Token.EQ) {
                    this.lexer.nextToken();
                }
                this.accept(Token.LPAREN);
                SQLTableSource tableSrc = this.createSQLSelectParser().parseTableSource();
                stmt.getTableOptions().put("UNION", tableSrc);
                this.accept(Token.RPAREN);
                continue;
            }
            if (this.lexer.token() == Token.TABLESPACE) {
                this.lexer.nextToken();
                MySqlCreateTableStatement.TableSpaceOption option = new MySqlCreateTableStatement.TableSpaceOption();
                option.setName(this.exprParser.name());
                if (this.lexer.identifierEquals("STORAGE")) {
                    this.lexer.nextToken();
                    option.setStorage(this.exprParser.name());
                }
                stmt.getTableOptions().put("TABLESPACE", option);
                continue;
            }
            if (this.lexer.identifierEquals("TABLEGROUP")) {
                this.lexer.nextToken();
                SQLName tableGroup = this.exprParser.name();
                stmt.setTableGroup(tableGroup);
                continue;
            }
            if (this.lexer.identifierEquals("TYPE")) {
                this.lexer.nextToken();
                this.accept(Token.EQ);
                stmt.getTableOptions().put("TYPE", this.exprParser.expr());
                this.lexer.nextToken();
                continue;
            }
            if (this.lexer.token() != Token.PARTITION) break;
            this.lexer.nextToken();
            this.accept(Token.BY);
            boolean linera = false;
            if (this.lexer.identifierEquals("LINEAR")) {
                this.lexer.nextToken();
                linera = true;
            }
            if (this.lexer.token() == Token.KEY) {
                clause = new MySqlPartitionByKey();
                this.lexer.nextToken();
                if (linera) {
                    clause.setLinear(true);
                }
                this.accept(Token.LPAREN);
                if (this.lexer.token() != Token.RPAREN) {
                    while (true) {
                        ((MySqlPartitionByKey)clause).addColumn(this.exprParser.name());
                        if (this.lexer.token() != Token.COMMA) break;
                        this.lexer.nextToken();
                    }
                }
                this.accept(Token.RPAREN);
                partitionClause = clause;
                this.partitionClauseRest(clause);
            } else if (this.lexer.identifierEquals("HASH")) {
                this.lexer.nextToken();
                clause = new SQLPartitionByHash();
                if (linera) {
                    clause.setLinear(true);
                }
                if (this.lexer.token() == Token.KEY) {
                    this.lexer.nextToken();
                    ((SQLPartitionByHash)clause).setKey(true);
                }
                this.accept(Token.LPAREN);
                ((SQLPartitionByHash)clause).setExpr(this.exprParser.expr());
                this.accept(Token.RPAREN);
                partitionClause = clause;
                this.partitionClauseRest(clause);
            } else if (this.lexer.identifierEquals("RANGE")) {
                partitionClause = clause = this.partitionByRange();
                this.partitionClauseRest(clause);
            } else if (this.lexer.identifierEquals("LIST")) {
                this.lexer.nextToken();
                clause = new SQLPartitionByList();
                if (this.lexer.token() == Token.LPAREN) {
                    this.lexer.nextToken();
                    ((SQLPartitionByList)clause).setExpr(this.exprParser.expr());
                    this.accept(Token.RPAREN);
                } else {
                    this.acceptIdentifier("COLUMNS");
                    this.accept(Token.LPAREN);
                    while (true) {
                        ((SQLPartitionByList)clause).addColumn(this.exprParser.name());
                        if (this.lexer.token() != Token.COMMA) break;
                        this.lexer.nextToken();
                    }
                    this.accept(Token.RPAREN);
                }
                partitionClause = clause;
                this.partitionClauseRest(clause);
            } else {
                throw new ParserException("TODO. " + this.lexer.info());
            }
            if (this.lexer.token() == Token.LPAREN) {
                this.lexer.nextToken();
                while (true) {
                    SQLPartition partitionDef = this.getExprParser().parsePartition();
                    partitionClause.addPartition(partitionDef);
                    if (this.lexer.token() != Token.COMMA) break;
                    this.lexer.nextToken();
                }
                this.accept(Token.RPAREN);
            }
            stmt.setPartitioning(partitionClause);
        }
        if (this.lexer.token() == Token.ON) {
            throw new ParserException("TODO. " + this.lexer.info());
        }
        if (this.lexer.token() == Token.AS) {
            this.lexer.nextToken();
        }
        if (this.lexer.token() == Token.SELECT) {
            SQLSelect query = new MySqlSelectParser(this.exprParser).select();
            stmt.setSelect(query);
        }
        while (this.lexer.token() == Token.HINT) {
            this.exprParser.parseHints(stmt.getOptionHints());
        }
        return stmt;
    }

    protected SQLPartitionByRange partitionByRange() {
        this.acceptIdentifier("RANGE");
        SQLPartitionByRange clause = new SQLPartitionByRange();
        if (this.lexer.token() == Token.LPAREN) {
            this.lexer.nextToken();
            clause.setExpr(this.exprParser.expr());
            this.accept(Token.RPAREN);
        } else {
            this.acceptIdentifier("COLUMNS");
            this.accept(Token.LPAREN);
            while (true) {
                clause.addColumn(this.exprParser.name());
                if (this.lexer.token() != Token.COMMA) break;
                this.lexer.nextToken();
            }
            this.accept(Token.RPAREN);
        }
        return clause;
    }

    protected void partitionClauseRest(SQLPartitionBy clause) {
        if (this.lexer.identifierEquals("PARTITIONS")) {
            this.lexer.nextToken();
            SQLIntegerExpr countExpr = this.exprParser.integerExpr();
            clause.setPartitionsCount(countExpr);
        }
        if (this.lexer.token() == Token.PARTITION) {
            this.lexer.nextToken();
            if (this.lexer.identifierEquals("NUM")) {
                this.lexer.nextToken();
            }
            clause.setPartitionsCount(this.exprParser.expr());
            clause.putAttribute("ads.partition", Boolean.TRUE);
        }
        if (this.lexer.identifierEquals("SUBPARTITION")) {
            this.lexer.nextToken();
            this.accept(Token.BY);
            SQLSubPartitionBy subPartitionByClause = null;
            boolean linear = false;
            if (this.lexer.identifierEquals("LINEAR")) {
                this.lexer.nextToken();
                linear = true;
            }
            if (this.lexer.token() == Token.KEY) {
                MySqlSubPartitionByKey subPartitionKey = new MySqlSubPartitionByKey();
                this.lexer.nextToken();
                if (linear) {
                    clause.setLinear(true);
                }
                this.accept(Token.LPAREN);
                while (true) {
                    subPartitionKey.addColumn(this.exprParser.name());
                    if (this.lexer.token() != Token.COMMA) break;
                    this.lexer.nextToken();
                }
                this.accept(Token.RPAREN);
                subPartitionByClause = subPartitionKey;
            } else if (this.lexer.identifierEquals("HASH")) {
                this.lexer.nextToken();
                SQLSubPartitionByHash subPartitionHash = new SQLSubPartitionByHash();
                if (linear) {
                    clause.setLinear(true);
                }
                if (this.lexer.token() == Token.KEY) {
                    this.lexer.nextToken();
                    subPartitionHash.setKey(true);
                }
                this.accept(Token.LPAREN);
                subPartitionHash.setExpr(this.exprParser.expr());
                this.accept(Token.RPAREN);
                subPartitionByClause = subPartitionHash;
            } else if (this.lexer.identifierEquals("LIST")) {
                this.lexer.nextToken();
                MySqlSubPartitionByList subPartitionList = new MySqlSubPartitionByList();
                if (this.lexer.token() == Token.LPAREN) {
                    this.lexer.nextToken();
                    SQLExpr expr = this.exprParser.expr();
                    if (expr instanceof SQLIdentifierExpr && (this.lexer.identifierEquals("bigint") || this.lexer.identifierEquals("long"))) {
                        String dataType = this.lexer.stringVal();
                        this.lexer.nextToken();
                        SQLColumnDefinition column = this.exprParser.createColumnDefinition();
                        column.setName((SQLIdentifierExpr)expr);
                        column.setDataType(new SQLDataTypeImpl(dataType));
                        subPartitionList.addColumn(column);
                        subPartitionList.putAttribute("ads.subPartitionList", Boolean.TRUE);
                    } else {
                        subPartitionList.setExpr(expr);
                    }
                    this.accept(Token.RPAREN);
                } else {
                    this.acceptIdentifier("COLUMNS");
                    this.accept(Token.LPAREN);
                    while (true) {
                        subPartitionList.addColumn(this.exprParser.parseColumn());
                        if (this.lexer.token() != Token.COMMA) break;
                        this.lexer.nextToken();
                    }
                    this.accept(Token.RPAREN);
                }
                subPartitionByClause = subPartitionList;
            }
            if (this.lexer.identifierEquals("SUBPARTITION")) {
                this.lexer.nextToken();
                this.acceptIdentifier("OPTIONS");
                this.accept(Token.LPAREN);
                SQLAssignItem option = this.exprParser.parseAssignItem();
                this.accept(Token.RPAREN);
                option.setParent(subPartitionByClause);
                subPartitionByClause.getOptions().add(option);
            }
            if (this.lexer.identifierEquals("SUBPARTITIONS")) {
                this.lexer.nextToken();
                Number intValue = this.lexer.integerValue();
                SQLNumberExpr numExpr = new SQLNumberExpr(intValue);
                subPartitionByClause.setSubPartitionsCount(numExpr);
                this.lexer.nextToken();
            }
            if (subPartitionByClause != null) {
                subPartitionByClause.setLinear(linear);
                clause.setSubPartitionBy(subPartitionByClause);
            }
        }
    }

    private boolean parseTableOptionCharsetOrCollate(MySqlCreateTableStatement stmt) {
        if (this.lexer.identifierEquals("CHARACTER")) {
            this.lexer.nextToken();
            this.accept(Token.SET);
            if (this.lexer.token() == Token.EQ) {
                this.lexer.nextToken();
            }
            stmt.getTableOptions().put("CHARACTER SET", this.exprParser.expr());
            return true;
        }
        if (this.lexer.identifierEquals("CHARSET")) {
            this.lexer.nextToken();
            if (this.lexer.token() == Token.EQ) {
                this.lexer.nextToken();
            }
            stmt.getTableOptions().put("CHARSET", this.exprParser.expr());
            return true;
        }
        if (this.lexer.identifierEquals("COLLATE")) {
            this.lexer.nextToken();
            if (this.lexer.token() == Token.EQ) {
                this.lexer.nextToken();
            }
            stmt.getTableOptions().put("COLLATE", this.exprParser.expr());
            return true;
        }
        return false;
    }

    @Override
    protected SQLTableConstraint parseConstraint() {
        SQLName name = null;
        boolean hasConstaint = false;
        if (this.lexer.token() == Token.CONSTRAINT) {
            hasConstaint = true;
            this.lexer.nextToken();
        }
        if (this.lexer.token() == Token.IDENTIFIER) {
            name = this.exprParser.name();
        }
        if (this.lexer.token() == Token.KEY) {
            SQLName indexName;
            this.lexer.nextToken();
            MySqlKey key = new MySqlKey();
            key.setHasConstaint(hasConstaint);
            if ((this.lexer.token() == Token.IDENTIFIER || this.lexer.token() == Token.LITERAL_ALIAS) && (indexName = this.exprParser.name()) != null) {
                key.setName(indexName);
            }
            if (this.lexer.identifierEquals("USING")) {
                this.lexer.nextToken();
                key.setIndexType(this.lexer.stringVal());
                this.lexer.nextToken();
            }
            this.accept(Token.LPAREN);
            while (true) {
                SQLExpr expr = this.exprParser.expr();
                if (this.lexer.token() == Token.ASC) {
                    this.lexer.nextToken();
                    expr = new MySqlOrderingExpr(expr, SQLOrderingSpecification.ASC);
                } else if (this.lexer.token() == Token.DESC) {
                    this.lexer.nextToken();
                    expr = new MySqlOrderingExpr(expr, SQLOrderingSpecification.DESC);
                }
                key.addColumn(expr);
                if (this.lexer.token() != Token.COMMA) break;
                this.lexer.nextToken();
            }
            this.accept(Token.RPAREN);
            if (name != null) {
                key.setName(name);
            }
            if (this.lexer.identifierEquals("USING")) {
                this.lexer.nextToken();
                key.setIndexType(this.lexer.stringVal());
                this.lexer.nextToken();
            }
            return key;
        }
        if (this.lexer.token() == Token.PRIMARY) {
            MySqlPrimaryKey pk = this.getExprParser().parsePrimaryKey();
            if (name != null) {
                pk.setName(name);
            }
            pk.setHasConstaint(hasConstaint);
            return pk;
        }
        if (this.lexer.token() == Token.UNIQUE) {
            MySqlUnique uk = this.getExprParser().parseUnique();
            if (name != null) {
                uk.setName(name);
            }
            uk.setHasConstaint(hasConstaint);
            return uk;
        }
        if (this.lexer.token() == Token.FOREIGN) {
            MysqlForeignKey fk = this.getExprParser().parseForeignKey();
            fk.setName(name);
            fk.setHasConstraint(hasConstaint);
            return fk;
        }
        throw new ParserException("TODO. " + this.lexer.info());
    }
}

