/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.rpc.cluster.configurator;

import com.alibaba.dubbo.common.URL;
import com.alibaba.dubbo.common.utils.NetUtils;
import com.alibaba.dubbo.rpc.cluster.Configurator;
import java.util.HashSet;
import java.util.Map;

public abstract class AbstractConfigurator
implements Configurator {
    private final URL configuratorUrl;

    public AbstractConfigurator(URL url) {
        if (url == null) {
            throw new IllegalArgumentException("configurator url == null");
        }
        this.configuratorUrl = url;
    }

    public static void main(String[] args) {
        System.out.println(URL.encode((String)"timeout=100"));
    }

    @Override
    public URL getUrl() {
        return this.configuratorUrl;
    }

    @Override
    public URL configure(URL url) {
        if (this.configuratorUrl == null || this.configuratorUrl.getHost() == null || url == null || url.getHost() == null) {
            return url;
        }
        if (this.configuratorUrl.getPort() != 0) {
            if (url.getPort() == this.configuratorUrl.getPort()) {
                return this.configureIfMatch(url.getHost(), url);
            }
        } else {
            if (url.getParameter("side", "provider").equals("consumer")) {
                return this.configureIfMatch(NetUtils.getLocalHost(), url);
            }
            if (url.getParameter("side", "consumer").equals("provider")) {
                return this.configureIfMatch("0.0.0.0", url);
            }
        }
        return url;
    }

    private URL configureIfMatch(String host, URL url) {
        if ("0.0.0.0".equals(this.configuratorUrl.getHost()) || host.equals(this.configuratorUrl.getHost())) {
            String configApplication = this.configuratorUrl.getParameter("application", this.configuratorUrl.getUsername());
            String currentApplication = url.getParameter("application", url.getUsername());
            if (configApplication == null || "*".equals(configApplication) || configApplication.equals(currentApplication)) {
                HashSet<String> conditionKeys = new HashSet<String>();
                conditionKeys.add("category");
                conditionKeys.add("check");
                conditionKeys.add("dynamic");
                conditionKeys.add("enabled");
                for (Map.Entry entry : this.configuratorUrl.getParameters().entrySet()) {
                    String key = (String)entry.getKey();
                    String value = (String)entry.getValue();
                    if (!key.startsWith("~") && !"application".equals(key) && !"side".equals(key)) continue;
                    conditionKeys.add(key);
                    if (value == null || "*".equals(value) || value.equals(url.getParameter(key.startsWith("~") ? key.substring(1) : key))) continue;
                    return url;
                }
                return this.doConfigure(url, this.configuratorUrl.removeParameters(conditionKeys));
            }
        }
        return url;
    }

    @Override
    public int compareTo(Configurator o) {
        if (o == null) {
            return -1;
        }
        int ipCompare = this.getUrl().getHost().compareTo(o.getUrl().getHost());
        if (ipCompare == 0) {
            int j;
            int i = this.getUrl().getParameter("priority", 0);
            return i < (j = o.getUrl().getParameter("priority", 0)) ? -1 : (i == j ? 0 : 1);
        }
        return ipCompare;
    }

    protected abstract URL doConfigure(URL var1, URL var2);
}

