/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.excel.read.modelbuild;

import com.alibaba.excel.metadata.ExcelColumnProperty;
import com.alibaba.excel.metadata.ExcelHeadProperty;
import com.alibaba.excel.read.context.AnalysisContext;
import com.alibaba.excel.read.event.AnalysisEventListener;
import com.alibaba.excel.util.TypeUtil;
import com.alibaba.excel.write.exception.ExcelGenerateException;
import java.util.List;
import org.apache.commons.beanutils.BeanUtils;

public class ModelBuildEventListener
extends AnalysisEventListener {
    public void invoke(Object object, AnalysisContext context) {
        if (context.getExcelHeadProperty() != null && context.getExcelHeadProperty().getHeadClazz() != null) {
            Object resultModel = this.buildUserModel(context, (List)object);
            context.setCurrentRowAnalysisResult(resultModel);
        }
    }

    private Object buildUserModel(AnalysisContext context, List<String> stringList) {
        Object resultModel;
        ExcelHeadProperty excelHeadProperty = context.getExcelHeadProperty();
        try {
            resultModel = excelHeadProperty.getHeadClazz().newInstance();
        }
        catch (Exception e) {
            throw new ExcelGenerateException(e);
        }
        if (excelHeadProperty != null) {
            for (int i = 0; i < stringList.size(); ++i) {
                Object value;
                ExcelColumnProperty columnProperty = excelHeadProperty.getExcelColumnProperty1(i);
                if (columnProperty == null || (value = TypeUtil.convert(stringList.get(i), columnProperty.getField(), columnProperty.getFormat(), context.use1904WindowDate())) == null) continue;
                try {
                    BeanUtils.setProperty(resultModel, (String)columnProperty.getField().getName(), (Object)value);
                    continue;
                }
                catch (Exception e) {
                    throw new ExcelGenerateException(columnProperty.getField().getName() + " can not set value " + value, e);
                }
            }
        }
        return resultModel;
    }

    @Override
    public void doAfterAllAnalysed(AnalysisContext context) {
    }
}

