/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.app.spring.schema;

import com.taobao.hsf.app.spring.util.HSFSpringConsumerBean;
import com.taobao.hsf.app.spring.util.HSFSpringProviderBean;
import com.taobao.hsf.app.spring.util.HSFSpringRegistryBean;
import com.taobao.hsf.model.metadata.MethodSpecial;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionValidationException;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class HSFBeanDefinitionParser
implements BeanDefinitionParser {
    private final Class clazz;
    static final Map<String, FieldDefenition> providerFieldDefMap = new HashMap<String, FieldDefenition>();
    static final Map<String, FieldDefenition> consumerFieldDefMap;

    public HSFBeanDefinitionParser(Class clazz) {
        this.clazz = clazz;
    }

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        if (this.clazz == HSFSpringProviderBean.class) {
            return this.parseProvider(element, parserContext);
        }
        if (this.clazz == HSFSpringConsumerBean.class) {
            return this.parseConsumer(element, parserContext);
        }
        if (this.clazz == HSFSpringRegistryBean.class) {
            return this.parseRegistry(element, parserContext);
        }
        throw new BeanDefinitionValidationException("Unknown class to definition " + this.clazz.getName());
    }

    private void parseAttr(Element element, RootBeanDefinition beanDef, Map<String, FieldDefenition> fieldDefMap) {
        NamedNodeMap attrMap = element.getAttributes();
        for (int i = 0; i < attrMap.getLength(); ++i) {
            Attr attr = (Attr)attrMap.item(i);
            String name = attr.getName();
            if (null == name || name.isEmpty()) continue;
            FieldDefenition fieldDefenition = fieldDefMap.get(name);
            if (null == fieldDefenition) {
                this.setProperty(beanDef, element, name, name, false);
                continue;
            }
            if (fieldDefenition.isDiscard()) continue;
            this.setProperty(beanDef, element, name, fieldDefenition.getPropName(), fieldDefenition.isRequred());
        }
    }

    public BeanDefinition parseProvider(Element element, ParserContext parserContext) {
        RootBeanDefinition beanDef = new RootBeanDefinition();
        beanDef.setBeanClass(this.clazz);
        beanDef.setLazyInit(false);
        String targetRef = element.getAttribute("ref");
        this.checkAttr("ref", targetRef);
        beanDef.getPropertyValues().addPropertyValue("target", (Object)new RuntimeBeanReference(targetRef));
        this.parseAttr(element, beanDef, providerFieldDefMap);
        ArrayList<MethodSpecial> list = new ArrayList<MethodSpecial>();
        ArrayList<String> configCenterList = new ArrayList<String>();
        NodeList methodSpecials = element.getChildNodes();
        for (int i = 0; i < methodSpecials.getLength(); ++i) {
            int j;
            Node item = methodSpecials.item(i);
            if (!(item instanceof Element)) continue;
            String localName = item.getLocalName();
            if (localName.equals("methodSpecials")) {
                NodeList methodSpecialList = item.getChildNodes();
                for (j = 0; j < methodSpecialList.getLength(); ++j) {
                    Node methodSpecial = methodSpecialList.item(j);
                    if (!(methodSpecial instanceof Element)) continue;
                    String timeout = ((Element)methodSpecial).getAttribute("timeout");
                    String name = ((Element)methodSpecial).getAttribute("name");
                    String retries = ((Element)methodSpecial).getAttribute("retries");
                    MethodSpecial ms = new MethodSpecial();
                    ms.setClientTimeout(Long.valueOf(timeout).longValue());
                    ms.setMethodName(name);
                    if (!retries.isEmpty()) {
                        ms.setRetries(Integer.valueOf(retries).intValue());
                    }
                    list.add(ms);
                }
                continue;
            }
            if (!localName.equals("configserverCenter")) continue;
            NodeList centerList = item.getChildNodes();
            for (j = 0; j < centerList.getLength(); ++j) {
                String name;
                Node center = centerList.item(j);
                if (!(center instanceof Element) || (name = ((Element)center).getAttribute("name")).isEmpty()) continue;
                configCenterList.add(name);
            }
        }
        if (list.size() > 0) {
            beanDef.getPropertyValues().addPropertyValue("methodSpecials", (Object)list.toArray());
        }
        if (configCenterList.size() > 0) {
            beanDef.getPropertyValues().addPropertyValue("configserverCenter", configCenterList);
        }
        String id = this.getId(parserContext, element.getAttribute("id"));
        BeanDefinitionHolder holder = new BeanDefinitionHolder((BeanDefinition)beanDef, id);
        BeanDefinitionReaderUtils.registerBeanDefinition((BeanDefinitionHolder)holder, (BeanDefinitionRegistry)parserContext.getRegistry());
        return beanDef;
    }

    private String getId(ParserContext parserContext, String id) {
        if (id == null || id.length() == 0) {
            id = this.clazz.getSimpleName();
        }
        for (int time = 3; parserContext.getRegistry().containsBeanDefinition(id) && time > 0; --time) {
            id = id + time;
        }
        if (parserContext.getRegistry().containsBeanDefinition(id)) {
            throw new IllegalStateException("Duplicate spring bean id " + id);
        }
        return id;
    }

    private void setProperty(RootBeanDefinition beanDef, Element element, String attrName, String propertyName, boolean required) {
        String attr = element.getAttribute(attrName);
        if (required) {
            this.checkAttr(attrName, attr);
        }
        if (attr != null && !attr.isEmpty()) {
            beanDef.getPropertyValues().addPropertyValue(propertyName, (Object)attr);
        }
    }

    private void checkAttr(String attrName, String attr) {
        if (null == attr || attr.isEmpty()) {
            throw new BeanDefinitionValidationException("attribute " + attrName + " must set.");
        }
    }

    public BeanDefinition parseConsumer(Element element, ParserContext parserContext) {
        RootBeanDefinition beanDef = new RootBeanDefinition();
        beanDef.setBeanClass(this.clazz);
        beanDef.setLazyInit(false);
        this.parseAttr(element, beanDef, consumerFieldDefMap);
        String callbackInvokerRef = element.getAttribute("callbackInvoker");
        if (!callbackInvokerRef.isEmpty()) {
            beanDef.getPropertyValues().addPropertyValue("callbackInvoker", (Object)new RuntimeBeanReference(callbackInvokerRef));
        }
        ArrayList<MethodSpecial> list = new ArrayList<MethodSpecial>();
        ArrayList<String> asyncallMethods = new ArrayList<String>();
        NodeList methodSpecials = element.getChildNodes();
        for (int i = 0; i < methodSpecials.getLength(); ++i) {
            int j;
            Node item = methodSpecials.item(i);
            if (!(item instanceof Element)) continue;
            String localName = item.getLocalName();
            if (localName.equals("asyncallMethods")) {
                NodeList asyncallMethodsList = item.getChildNodes();
                for (j = 0; j < asyncallMethodsList.getLength(); ++j) {
                    Node asyncallMethod = asyncallMethodsList.item(j);
                    if (!(asyncallMethod instanceof Element)) continue;
                    String name = ((Element)asyncallMethod).getAttribute("name");
                    String type = ((Element)asyncallMethod).getAttribute("type");
                    if (name.isEmpty() || type.isEmpty()) continue;
                    String listener = ((Element)asyncallMethod).getAttribute("listener");
                    StringBuilder sb = new StringBuilder();
                    sb.append("name:").append(name).append(";type:").append(type);
                    if (type.equals("callback")) {
                        sb.append(";listener:").append(listener);
                    }
                    asyncallMethods.add(sb.toString());
                }
                continue;
            }
            if (!localName.equals("methodSpecials")) continue;
            NodeList methodSpecialList = item.getChildNodes();
            for (j = 0; j < methodSpecialList.getLength(); ++j) {
                Node methodSpecial = methodSpecialList.item(j);
                if (!(methodSpecial instanceof Element)) continue;
                String timeout = ((Element)methodSpecial).getAttribute("timeout");
                String name = ((Element)methodSpecial).getAttribute("name");
                String retries = ((Element)methodSpecial).getAttribute("retries");
                MethodSpecial ms = new MethodSpecial();
                ms.setClientTimeout(Long.valueOf(timeout).longValue());
                ms.setMethodName(name);
                if (!retries.isEmpty()) {
                    ms.setRetries(Integer.valueOf(retries).intValue());
                }
                list.add(ms);
            }
        }
        if (list.size() > 0) {
            beanDef.getPropertyValues().addPropertyValue("methodSpecials", (Object)list.toArray());
        }
        if (asyncallMethods.size() > 0) {
            beanDef.getPropertyValues().addPropertyValue("asyncallMethods", asyncallMethods);
        }
        String id = this.getId(parserContext, element.getAttribute("id"));
        BeanDefinitionHolder holder = new BeanDefinitionHolder((BeanDefinition)beanDef, id);
        BeanDefinitionReaderUtils.registerBeanDefinition((BeanDefinitionHolder)holder, (BeanDefinitionRegistry)parserContext.getRegistry());
        return beanDef;
    }

    public BeanDefinition parseRegistry(Element element, ParserContext parserContext) {
        String address = System.getProperty("hsf.registry.address", null);
        if (address == null && (address = element.getAttribute("address")) != null) {
            System.setProperty("hsf.registry.address", address);
        }
        return null;
    }

    static {
        providerFieldDefMap.put("interface", new FieldDefenition("serviceInterface", true, false));
        providerFieldDefMap.put("timeout", new FieldDefenition("clientTimeout", false, false));
        providerFieldDefMap.put("version", new FieldDefenition("serviceVersion", false, false));
        providerFieldDefMap.put("group", new FieldDefenition("serviceGroup", false, false));
        providerFieldDefMap.put("tenantID", new FieldDefenition("tenantID", false, false));
        providerFieldDefMap.put("envID", new FieldDefenition("envID", false, false));
        providerFieldDefMap.put("ref", new FieldDefenition(true));
        providerFieldDefMap.put("id", new FieldDefenition(true));
        consumerFieldDefMap = new HashMap<String, FieldDefenition>();
        consumerFieldDefMap.put("interface", new FieldDefenition("interfaceName", true, false));
        consumerFieldDefMap.put("id", new FieldDefenition(true));
    }

    static class FieldDefenition {
        String propName;
        boolean requred;
        final boolean discard;

        public FieldDefenition(String propName, boolean requred, boolean discard) {
            this.propName = propName;
            this.requred = requred;
            this.discard = discard;
        }

        public FieldDefenition(boolean discard) {
            this.discard = discard;
        }

        public String getPropName() {
            return this.propName;
        }

        public void setPropName(String propName) {
            this.propName = propName;
        }

        public boolean isRequred() {
            return this.requred;
        }

        public void setRequred(boolean requred) {
            this.requred = requred;
        }

        public boolean isDiscard() {
            return this.discard;
        }
    }
}

