package com.taobao.hsf.tbremoting.invoke;

import com.taobao.hsf.domain.HSFResponse;
import com.taobao.hsf.exception.HSFException;
import com.taobao.hsf.exception.HSFTimeOutException;
import com.taobao.middleware.logger.support.LoggerHelper;
import com.taobao.remoting.ResponseFuture;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

/**
 * 该类用于持有一个remoting的ResponseFuture，供用户使用<br>
 * 替换之前将ReponseFuture存在ThreadLocal中的方式
 * 
 * @author sixie.xyn
 * 
 */
public class HSFFuture {
    private final Future<Object> future;

    public HSFFuture(Future<Object> future) {
        this.future = future;
    }

    /**
     * 获取远程对象的结果。 如果通信层抛出异常，把异常外包装HSFException。
     * 
     * @param timeout
     *            超时时间
     * @throws HSFException
     * @throws InterruptedException
     */
    public Object getResponse(long timeout) throws HSFException, InterruptedException, Throwable {
        try {
            Object rawResponse = future.get(timeout, TimeUnit.MILLISECONDS);
            if (ResponseFuture.ASYN_NOT_DONE == rawResponse) {
                throw new HSFException("Designated timeout[" + timeout + "ms]time has arrived, but the result has not returned");
            }

            HSFResponse hsfResp = (HSFResponse) rawResponse;
            if (hsfResp.isError()) {
                // 服务端业务异常，客户端打出服务端异常堆栈
                throw new HSFException(hsfResp.getErrorMsg(), hsfResp.getErrorMsg());
            }
            Object appResponse = hsfResp.getAppResponse();
            // 检查对端返回的业务层对象: 如果返回的是异常对象，则重新抛出异常
            if (appResponse instanceof Throwable) {
                throw (Throwable) appResponse;
            }
            return appResponse;
        } catch (ExecutionException e) {
            throw new HSFTimeOutException(getErrorLog(), e);
        } catch (java.util.concurrent.TimeoutException e) {
            throw new HSFTimeOutException(getErrorLog(), e);
        }
    }
    
    private String getErrorLog(){
    	return LoggerHelper.getErrorCodeStr("hsf", "HSF-0002", "Business problems", "");
    }

}
