/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.serializer;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.AfterFilter;
import com.alibaba.fastjson.serializer.BeforeFilter;
import com.alibaba.fastjson.serializer.NameFilter;
import com.alibaba.fastjson.serializer.ObjectSerializer;
import com.alibaba.fastjson.serializer.PropertyFilter;
import com.alibaba.fastjson.serializer.SerialContext;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.alibaba.fastjson.serializer.SerializeWriter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.serializer.ValueFilter;
import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.writer.ObjectWriter;
import java.util.List;

public class JSONSerializer {
    public final SerializeWriter out;
    final JSONWriter raw;
    SerialContext context;

    public JSONSerializer() {
        this(new SerializeWriter());
    }

    public JSONSerializer(SerializeConfig config) {
        this(new SerializeWriter(config, new SerializerFeature[0]));
    }

    public JSONSerializer(JSONWriter raw) {
        this(new SerializeWriter(raw));
    }

    public JSONSerializer(SerializeWriter out) {
        this.out = out;
        this.raw = out.raw;
    }

    public JSONSerializer(SerializeWriter out, SerializeConfig config) {
        this.out = out;
        this.raw = out.raw;
    }

    public static JSONSerializer getJSONSerializer(JSONWriter writer) {
        JSONSerializer serializer = null;
        Object attachment = writer.getAttachment();
        if (attachment == null) {
            serializer = new JSONSerializer(writer);
            attachment = serializer;
            writer.setAttachment(attachment);
        } else {
            serializer = attachment instanceof JSONSerializer ? (JSONSerializer)attachment : new JSONSerializer(writer);
        }
        return serializer;
    }

    public void config(SerializerFeature feature, boolean state) {
        if (!state) {
            throw new JSONException("not support");
        }
        JSONWriter.Context ctx = this.raw.getContext();
        switch (feature) {
            case UseISO8601DateFormat: {
                ctx.setDateFormat("iso8601");
                break;
            }
            case WriteMapNullValue: {
                ctx.config(new JSONWriter.Feature[]{JSONWriter.Feature.WriteNulls});
                break;
            }
            case WriteNullListAsEmpty: {
                ctx.config(new JSONWriter.Feature[]{JSONWriter.Feature.WriteNullListAsEmpty});
                break;
            }
            case WriteNullStringAsEmpty: {
                ctx.config(new JSONWriter.Feature[]{JSONWriter.Feature.WriteNullStringAsEmpty});
                break;
            }
            case WriteNullNumberAsZero: {
                ctx.config(new JSONWriter.Feature[]{JSONWriter.Feature.WriteNullNumberAsZero});
                break;
            }
            case WriteNullBooleanAsFalse: {
                ctx.config(new JSONWriter.Feature[]{JSONWriter.Feature.WriteNullBooleanAsFalse});
                break;
            }
            case BrowserCompatible: {
                ctx.config(new JSONWriter.Feature[]{JSONWriter.Feature.BrowserCompatible});
                break;
            }
            case BrowserSecure: {
                ctx.config(new JSONWriter.Feature[]{JSONWriter.Feature.BrowserSecure});
                break;
            }
            case WriteClassName: {
                ctx.config(new JSONWriter.Feature[]{JSONWriter.Feature.WriteClassName});
                break;
            }
            case WriteNonStringValueAsString: {
                ctx.config(new JSONWriter.Feature[]{JSONWriter.Feature.WriteNonStringValueAsString});
                break;
            }
            case WriteEnumUsingToString: {
                ctx.config(new JSONWriter.Feature[]{JSONWriter.Feature.WriteEnumUsingToString});
                break;
            }
            case NotWriteRootClassName: {
                ctx.config(new JSONWriter.Feature[]{JSONWriter.Feature.NotWriteRootClassName});
                break;
            }
            case IgnoreErrorGetter: {
                ctx.config(new JSONWriter.Feature[]{JSONWriter.Feature.IgnoreErrorGetter});
                break;
            }
            case WriteDateUseDateFormat: {
                ctx.setDateFormat(JSON.DEFAULT_DATE_FORMAT);
                break;
            }
            case BeanToArray: {
                ctx.config(new JSONWriter.Feature[]{JSONWriter.Feature.BeanToArray});
                break;
            }
            case UseSingleQuotes: {
                ctx.config(new JSONWriter.Feature[]{JSONWriter.Feature.UseSingleQuotes});
                break;
            }
        }
    }

    public void write(boolean value) {
        this.raw.writeBool(value);
    }

    public void writeInt(int i) {
        this.raw.writeInt32(i);
    }

    public void write(String text) {
        this.raw.writeString(text);
    }

    public void writeLong(long i) {
        this.raw.writeInt64(i);
    }

    public void writeNull() {
        this.raw.writeNull();
    }

    public final void write(Object object) {
        this.raw.writeAny(object);
    }

    public final void writeAs(Object object, Class type) {
        ObjectWriter objectWriter = this.raw.getObjectWriter(type);
        objectWriter.write(this.raw, object);
    }

    public String toString() {
        return this.raw.toString();
    }

    public List<PropertyFilter> getPropertyFilters() {
        return this.out.getPropertyFilters();
    }

    public List<ValueFilter> getValueFilters() {
        return this.out.getValueFilters();
    }

    public List<NameFilter> getNameFilters() {
        return this.out.getNameFilters();
    }

    public List<BeforeFilter> getBeforeFilters() {
        return this.out.getBeforeFilters();
    }

    public List<AfterFilter> getAfterFilters() {
        return this.out.getAfterFilters();
    }

    public SerializeConfig getMapping() {
        return this.out.config;
    }

    public SerializeWriter getWriter() {
        return this.out;
    }

    public ObjectSerializer getObjectWriter(Class<?> clazz) {
        return this.out.config.getObjectWriter(clazz);
    }

    public static void write(SerializeWriter out, Object object) {
        out.raw.writeAny(object);
    }

    public SerialContext getContext() {
        return this.context;
    }

    public void setContext(SerialContext context) {
        this.context = context;
    }

    public final boolean containsReference(Object value) {
        return this.out.raw.containsReference(value);
    }

    public final void writeReference(Object object) {
        this.out.raw.writeReference(object);
    }

    public final void incrementIndent() {
        this.out.raw.incrementIndent();
    }

    public final void decrementIdent() {
        this.out.raw.decrementIdent();
    }

    public void println() {
    }

    public void setContext(SerialContext parent, Object object, Object fieldName, int features) {
        this.setContext(parent, object, fieldName, features, 0);
    }

    public void setContext(SerialContext parent, Object object, Object fieldName, int features, int fieldFeatures) {
        this.setContext(new SerialContext(parent, object, fieldName, features, fieldFeatures));
    }
}

