/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.common.notify;

import com.alibaba.nacos.common.notify.DefaultPublisher;
import com.alibaba.nacos.common.notify.Event;
import com.alibaba.nacos.common.notify.SlowEvent;
import com.alibaba.nacos.common.notify.listener.Subscriber;
import com.alibaba.nacos.common.utils.ConcurrentHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class DefaultSharePublisher
extends DefaultPublisher {
    private final Map<Class<? extends SlowEvent>, Set<Subscriber>> subMappings = new ConcurrentHashMap<Class<? extends SlowEvent>, Set<Subscriber>>();
    private final Lock lock = new ReentrantLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSubscriber(Subscriber subscriber, Class<? extends Event> subscribeType) {
        Class<? extends Event> subSlowEventType = subscribeType;
        this.subscribers.add(subscriber);
        this.lock.lock();
        try {
            Set<Subscriber> sets = this.subMappings.get(subSlowEventType);
            if (sets == null) {
                ConcurrentHashSet<Subscriber> newSet = new ConcurrentHashSet<Subscriber>();
                newSet.add(subscriber);
                this.subMappings.put(subSlowEventType, newSet);
                return;
            }
            sets.add(subscriber);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSubscriber(Subscriber subscriber, Class<? extends Event> subscribeType) {
        Class<? extends Event> subSlowEventType = subscribeType;
        this.subscribers.remove(subscriber);
        this.lock.lock();
        try {
            Set<Subscriber> sets = this.subMappings.get(subSlowEventType);
            if (sets != null && sets.contains(subscriber)) {
                sets.remove(subscriber);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void receiveEvent(Event event) {
        long currentEventSequence = event.sequence();
        Class<?> slowEventType = event.getClass();
        Set<Subscriber> subscribers = this.subMappings.get(slowEventType);
        if (null == subscribers) {
            LOGGER.debug("[NotifyCenter] No subscribers for slow event {}", (Object)slowEventType.getName());
            return;
        }
        for (Subscriber subscriber : subscribers) {
            if (subscriber.ignoreExpireEvent() && this.lastEventSequence > currentEventSequence) {
                LOGGER.debug("[NotifyCenter] the {} is unacceptable to this subscriber, because had expire", event.getClass());
                continue;
            }
            this.notifySubscriber(subscriber, event);
        }
    }
}

