/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.common.task.engine;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.common.executor.ExecutorFactory;
import com.alibaba.nacos.common.executor.NameThreadFactory;
import com.alibaba.nacos.common.task.NacosTask;
import com.alibaba.nacos.common.task.NacosTaskProcessor;
import com.alibaba.nacos.common.task.engine.NacosTaskExecuteEngine;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractNacosTaskExecuteEngine<T extends NacosTask>
implements NacosTaskExecuteEngine<T> {
    private final Logger log;
    private final ScheduledExecutorService processingExecutor;
    private final ConcurrentHashMap<Object, NacosTaskProcessor> taskProcessors = new ConcurrentHashMap();
    protected final ConcurrentHashMap<Object, T> tasks;
    protected final ReentrantLock lock = new ReentrantLock();
    private NacosTaskProcessor defaultTaskProcessor;

    public AbstractNacosTaskExecuteEngine(String name) {
        this(name, 32, null, 100L);
    }

    public AbstractNacosTaskExecuteEngine(String name, Logger logger) {
        this(name, 32, logger, 100L);
    }

    public AbstractNacosTaskExecuteEngine(String name, Logger logger, long processInterval) {
        this(name, 32, logger, processInterval);
    }

    public AbstractNacosTaskExecuteEngine(String name, int initCapacity, Logger logger) {
        this(name, initCapacity, logger, 100L);
    }

    public AbstractNacosTaskExecuteEngine(String name, int initCapacity, Logger logger, long processInterval) {
        this.log = null != logger ? logger : LoggerFactory.getLogger((String)AbstractNacosTaskExecuteEngine.class.getName());
        this.tasks = new ConcurrentHashMap(initCapacity);
        this.processingExecutor = ExecutorFactory.newSingleScheduledExecutorService(new NameThreadFactory(name));
        this.processingExecutor.scheduleWithFixedDelay(new ProcessRunnable(), processInterval, processInterval, TimeUnit.MILLISECONDS);
    }

    @Override
    public int size() {
        this.lock.lock();
        try {
            int n = this.tasks.size();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean isEmpty() {
        this.lock.lock();
        try {
            boolean bl = this.tasks.isEmpty();
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void addProcessor(Object key, NacosTaskProcessor taskProcessor) {
        this.taskProcessors.putIfAbsent(key, taskProcessor);
    }

    @Override
    public void removeProcessor(Object key) {
        this.taskProcessors.remove(key);
    }

    @Override
    public NacosTaskProcessor getProcessor(Object key) {
        return this.taskProcessors.containsKey(key) ? this.taskProcessors.get(key) : this.defaultTaskProcessor;
    }

    @Override
    public Collection<Object> getAllProcessorKey() {
        return this.taskProcessors.keySet();
    }

    @Override
    public void setDefaultTaskProcessor(NacosTaskProcessor defaultTaskProcessor) {
        this.defaultTaskProcessor = defaultTaskProcessor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T removeTask(Object key) {
        this.lock.lock();
        try {
            NacosTask task = (NacosTask)this.tasks.get(key);
            if (null != task && task.shouldProcess()) {
                NacosTask nacosTask = (NacosTask)this.tasks.remove(key);
                return (T)nacosTask;
            }
            T t = null;
            return t;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public Collection<Object> getAllTaskKeys() {
        HashSet<Object> keys = new HashSet<Object>();
        this.lock.lock();
        try {
            keys.addAll(this.tasks.keySet());
        }
        finally {
            this.lock.unlock();
        }
        return keys;
    }

    @Override
    public void shutdown() throws NacosException {
        this.processingExecutor.shutdown();
    }

    protected Logger getEngineLog() {
        return this.log;
    }

    protected abstract void processTasks();

    private class ProcessRunnable
    implements Runnable {
        private ProcessRunnable() {
        }

        @Override
        public void run() {
            try {
                AbstractNacosTaskExecuteEngine.this.processTasks();
            }
            catch (Throwable e) {
                AbstractNacosTaskExecuteEngine.this.log.error(e.toString(), e);
            }
        }
    }
}

