/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.common.task.engine;

import com.alibaba.nacos.common.task.AbstractDelayTask;
import com.alibaba.nacos.common.task.NacosTaskProcessor;
import com.alibaba.nacos.common.task.engine.AbstractNacosTaskExecuteEngine;
import java.util.Collection;
import org.slf4j.Logger;

public class NacosDelayTaskExecuteEngine
extends AbstractNacosTaskExecuteEngine<AbstractDelayTask> {
    public NacosDelayTaskExecuteEngine(String name) {
        super(name);
    }

    public NacosDelayTaskExecuteEngine(String name, Logger logger) {
        super(name, logger);
    }

    public NacosDelayTaskExecuteEngine(String name, Logger logger, long processInterval) {
        super(name, logger, processInterval);
    }

    public NacosDelayTaskExecuteEngine(String name, int initCapacity, Logger logger) {
        super(name, initCapacity, logger);
    }

    public NacosDelayTaskExecuteEngine(String name, int initCapacity, Logger logger, long processInterval) {
        super(name, initCapacity, logger, processInterval);
    }

    @Override
    protected void processTasks() {
        Collection<Object> keys = this.getAllTaskKeys();
        for (Object taskKey : keys) {
            AbstractDelayTask task = (AbstractDelayTask)this.removeTask(taskKey);
            if (null == task) continue;
            NacosTaskProcessor processor = this.getProcessor(taskKey);
            if (null == processor) {
                this.getEngineLog().error("processor not found for task, so discarded. " + task);
                continue;
            }
            try {
                if (processor.process(task)) continue;
                this.retryFailedTask(taskKey, task);
            }
            catch (Throwable e) {
                this.getEngineLog().error("Nacos task execute error : " + e.toString(), e);
                this.retryFailedTask(taskKey, task);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addTask(Object key, AbstractDelayTask newTask) {
        this.lock.lock();
        try {
            AbstractDelayTask existTask = (AbstractDelayTask)this.tasks.get(key);
            if (null != existTask) {
                newTask.merge(existTask);
            }
            this.tasks.put(key, newTask);
        }
        finally {
            this.lock.unlock();
        }
    }

    private void retryFailedTask(Object key, AbstractDelayTask task) {
        task.setLastProcessTime(System.currentTimeMillis());
        this.addTask(key, task);
    }
}

