/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nls.client.protocol.tts;

import com.alibaba.fastjson.JSON;
import com.alibaba.nls.client.protocol.tts.SpeechSynthesizer;
import com.alibaba.nls.client.protocol.tts.SpeechSynthesizerResponse;
import com.alibaba.nls.client.transport.ConnectionListener;
import java.nio.ByteBuffer;
import java.util.concurrent.CountDownLatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SpeechSynthesizerListener
implements ConnectionListener {
    Logger logger = LoggerFactory.getLogger(SpeechSynthesizerListener.class);
    private CountDownLatch completeLatch;
    private CountDownLatch readyLatch;
    private SpeechSynthesizer speechSynthesizer;

    void setSpeechSynthesizer(SpeechSynthesizer speechSynthesizer) {
        this.speechSynthesizer = speechSynthesizer;
    }

    public abstract void onComplete(SpeechSynthesizerResponse var1);

    public void onOpen() {
        this.logger.info("connection is ok");
    }

    public void onClose(int closeCode, String reason) {
        if (this.speechSynthesizer != null) {
            this.speechSynthesizer.markClosed();
        }
        this.logger.info("connection is closed due to {},code:{}", (Object)reason, (Object)closeCode);
    }

    public void onMessage(String message) {
        if (message == null || message.trim().length() == 0) {
            return;
        }
        this.logger.debug("on message:{}", (Object)message);
        SpeechSynthesizerResponse response = (SpeechSynthesizerResponse)((Object)JSON.parseObject((String)message, SpeechSynthesizerResponse.class));
        if (this.isComplete(response)) {
            this.onComplete(response);
            this.completeLatch.countDown();
        } else if (this.isTaskFailed(response)) {
            this.onFail(response);
            this.completeLatch.countDown();
        } else {
            this.logger.error(message);
        }
    }

    public abstract void onFail(SpeechSynthesizerResponse var1);

    public abstract void onMessage(ByteBuffer var1);

    private boolean isComplete(SpeechSynthesizerResponse response) {
        String name = response.getName();
        return name.equals("SynthesisCompleted");
    }

    private boolean isTaskFailed(SpeechSynthesizerResponse response) {
        String name = response.getName();
        return name.equals("TaskFailed");
    }

    public void setCompleteLatch(CountDownLatch latch) {
        this.completeLatch = latch;
    }
}

