/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nls.client.protocol.tts;

import com.alibaba.fastjson.JSON;
import com.alibaba.nls.client.protocol.tts.FlowingSpeechSynthesizer;
import com.alibaba.nls.client.protocol.tts.FlowingSpeechSynthesizerResponse;
import com.alibaba.nls.client.transport.ConnectionListener;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FlowingSpeechSynthesizerListener
implements ConnectionListener {
    Logger logger = LoggerFactory.getLogger(FlowingSpeechSynthesizerListener.class);
    private FlowingSpeechSynthesizer synthesizer;

    public void setFlowingSpeechSynthesizer(FlowingSpeechSynthesizer synthesizer) {
        this.synthesizer = synthesizer;
    }

    public FlowingSpeechSynthesizer getFlowingSpeechSynthesizer() {
        return this.synthesizer;
    }

    public void onSynthesisStart(FlowingSpeechSynthesizerResponse response) {
        this.logger.info("start stream realtime synthesis");
    }

    public abstract void onSentenceBegin(FlowingSpeechSynthesizerResponse var1);

    public abstract void onAudioData(ByteBuffer var1);

    public void onMessage(ByteBuffer message) {
        this.onAudioData(message);
    }

    public abstract void onSentenceEnd(FlowingSpeechSynthesizerResponse var1);

    public abstract void onSynthesisComplete(FlowingSpeechSynthesizerResponse var1);

    public abstract void onFail(FlowingSpeechSynthesizerResponse var1);

    public abstract void onSentenceSynthesis(FlowingSpeechSynthesizerResponse var1);

    public void onOpen() {
        this.logger.debug("connection is ok");
    }

    public void onClose(int closeCode, String reason) {
        if (this.synthesizer != null) {
            this.synthesizer.markClosed();
        }
        this.logger.debug("connection is closed due to {},code:{}", (Object)reason, (Object)closeCode);
    }

    public void onMessage(String message) {
        if (message == null || message.trim().length() == 0) {
            return;
        }
        this.logger.debug("on message:{}", (Object)message);
        FlowingSpeechSynthesizerResponse response = (FlowingSpeechSynthesizerResponse)((Object)JSON.parseObject((String)message, FlowingSpeechSynthesizerResponse.class));
        if (this.isSynthesisStarted(response)) {
            this.onSynthesisStart(response);
            this.synthesizer.markSynthesisReady();
        } else if (this.isSentenceBegin(response)) {
            this.onSentenceBegin(response);
        } else if (this.isSentenceSynthesis(response)) {
            this.onSentenceSynthesis(response);
        } else if (this.isSentenceEnd(response)) {
            this.onSentenceEnd(response);
        } else if (this.isSynthesisCompleted(response)) {
            this.onSynthesisComplete(response);
            this.synthesizer.markSynthesisComplete();
        } else if (this.isTaskFailed(response)) {
            this.onFail(response);
            this.synthesizer.markFail();
        } else {
            this.logger.error("can not process this message: {}", (Object)message);
        }
    }

    private boolean isSynthesisStarted(FlowingSpeechSynthesizerResponse response) {
        String name = response.getName();
        return name.equals("SynthesisStarted");
    }

    private boolean isSentenceBegin(FlowingSpeechSynthesizerResponse response) {
        String name = response.getName();
        return name.equals("SentenceBegin");
    }

    private boolean isSentenceEnd(FlowingSpeechSynthesizerResponse response) {
        String name = response.getName();
        return name.equals("SentenceEnd");
    }

    private boolean isSynthesisCompleted(FlowingSpeechSynthesizerResponse response) {
        String name = response.getName();
        return name.equals("SynthesisCompleted");
    }

    private boolean isSentenceSynthesis(FlowingSpeechSynthesizerResponse response) {
        String name = response.getName();
        return name.equals("SentenceSynthesis");
    }

    private boolean isTaskFailed(FlowingSpeechSynthesizerResponse response) {
        String name = response.getName();
        return name.equals("TaskFailed");
    }
}

