/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.canal.common.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;

public class ExecutorTemplate {
    private volatile ThreadPoolExecutor executor = null;
    private volatile List<Future> futures = Collections.synchronizedList(new ArrayList());

    public ExecutorTemplate(ThreadPoolExecutor executor) {
        this.executor = executor;
    }

    public void submit(Runnable task) {
        Future<Object> future = this.executor.submit(task, null);
        this.futures.add(future);
        this.check(future);
    }

    public void submit(Callable task) {
        Future future = this.executor.submit(task);
        this.futures.add(future);
        this.check(future);
    }

    private void check(Future future) {
        if (future.isDone()) {
            try {
                future.get();
            }
            catch (Throwable e) {
                this.cacelAllFutures();
                throw new RuntimeException(e);
            }
        }
    }

    public synchronized List<?> waitForResult() {
        ArrayList result = new ArrayList();
        RuntimeException exception = null;
        for (Future future : this.futures) {
            try {
                result.add(future.get());
            }
            catch (Throwable e) {
                exception = new RuntimeException(e);
                break;
            }
        }
        if (exception != null) {
            this.cacelAllFutures();
            throw exception;
        }
        return result;
    }

    public void cacelAllFutures() {
        for (Future future : this.futures) {
            if (future.isDone() || future.isCancelled()) continue;
            future.cancel(true);
        }
    }

    public void clear() {
        this.futures.clear();
    }
}

