/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.rocketmq.shade.io.netty.channel;

import com.alibaba.rocketmq.shade.io.netty.channel.Channel;
import com.alibaba.rocketmq.shade.io.netty.channel.ChannelHandler;
import com.alibaba.rocketmq.shade.io.netty.channel.ChannelHandlerContext;
import com.alibaba.rocketmq.shade.io.netty.channel.ChannelInboundHandlerAdapter;
import com.alibaba.rocketmq.shade.io.netty.channel.ChannelPipeline;
import com.alibaba.rocketmq.shade.io.netty.util.internal.logging.InternalLogger;
import com.alibaba.rocketmq.shade.io.netty.util.internal.logging.InternalLoggerFactory;

@ChannelHandler.Sharable
public abstract class ChannelInitializer<C extends Channel>
extends ChannelInboundHandlerAdapter {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ChannelInitializer.class);

    protected abstract void initChannel(C var1) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void channelRegistered(ChannelHandlerContext ctx) throws Exception {
        ChannelPipeline pipeline = ctx.pipeline();
        boolean success = false;
        try {
            this.initChannel(ctx.channel());
            pipeline.remove(this);
            ctx.fireChannelRegistered();
            success = true;
        }
        catch (Throwable t) {
            logger.warn("Failed to initialize a channel. Closing: " + ctx.channel(), t);
        }
        finally {
            if (pipeline.context(this) != null) {
                pipeline.remove(this);
            }
            if (!success) {
                ctx.close();
            }
        }
    }
}

