/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.simpleimage.analyze.search.engine;

import com.alibaba.simpleimage.analyze.search.cluster.Clusterable;
import com.alibaba.simpleimage.analyze.search.engine.Score;
import com.alibaba.simpleimage.analyze.search.tree.KMeansTree;
import com.alibaba.simpleimage.analyze.search.util.SerializationUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageEngine {
    private Map<Integer, LinkedList<Integer>> simpleInvertedFile;
    private Map<Integer, List<Integer>> simpleHistogramFile;
    private Map<Integer, Float> simpleWeightFile;
    private int total_images;
    private int total_features;
    private int total_words;
    private KMeansTree tree;

    public static void main(String[] args) {
    }

    public void init(String treePath) {
        this.tree = (KMeansTree)SerializationUtils.loadObject(treePath);
        this.simpleHistogramFile = new HashMap<Integer, List<Integer>>();
        this.total_words = this.tree.getLeafsList().size();
        this.total_images = 0;
        this.total_features = 0;
        this.simpleInvertedFile = new HashMap<Integer, LinkedList<Integer>>(this.total_words);
    }

    public int getTotal_features() {
        return this.total_features;
    }

    public List<Score> getRankedList(List<Integer> queryVWList, List<Score> candidate, int topNum) {
        Integer count;
        float queryNorm = 0.0f;
        float dictNorm = 0.0f;
        Float weight = Float.valueOf(0.0f);
        ArrayList<Score> scoreList = new ArrayList<Score>();
        HashMap<Integer, Integer> queryMap = new HashMap<Integer, Integer>();
        for (Integer visualWord : queryVWList) {
            count = (Integer)queryMap.get(visualWord);
            if (count == null) {
                count = 1;
            } else {
                Integer n = count;
                Integer n2 = count = Integer.valueOf(count + 1);
            }
            queryMap.put(visualWord, count);
        }
        for (Map.Entry entry : queryMap.entrySet()) {
            weight = this.simpleWeightFile.get(entry.getKey());
            if (weight == null) {
                weight = Float.valueOf(0.0f);
            }
            queryNorm = (float)((double)queryNorm + (1.0 + Math.log(((Integer)entry.getValue()).intValue())) * (double)weight.floatValue() * (double)weight.floatValue());
        }
        queryNorm = (float)Math.sqrt(queryNorm);
        if (candidate.size() > topNum) {
            candidate = candidate.subList(0, topNum);
        }
        Iterator<Score> iter = candidate.iterator();
        while (iter.hasNext()) {
            float sum = 0.0f;
            HashMap<Integer, Integer> dictMap = new HashMap<Integer, Integer>();
            Integer docId = iter.next().getIdentity();
            List<Integer> dictVWList = this.simpleHistogramFile.get(docId);
            for (Integer visualWord : dictVWList) {
                count = (Integer)dictMap.get(visualWord);
                if (count == null) {
                    count = 1;
                } else {
                    Integer n = count;
                    Integer n3 = count = Integer.valueOf(count + 1);
                }
                dictMap.put(visualWord, count);
            }
            for (Map.Entry entry : dictMap.entrySet()) {
                weight = this.simpleWeightFile.get(entry.getKey());
                if (weight == null) {
                    weight = Float.valueOf(0.0f);
                }
                dictNorm = (float)((double)dictNorm + (1.0 + Math.log(((Integer)entry.getValue()).intValue())) * (double)weight.floatValue() * (double)weight.floatValue());
            }
            dictNorm = (float)Math.sqrt(dictNorm);
            for (Map.Entry entry : dictMap.entrySet()) {
                Integer queryCount;
                Integer dictWord = (Integer)entry.getKey();
                Integer dictCount = (Integer)entry.getValue();
                weight = this.simpleWeightFile.get(entry.getKey());
                if (weight == null) {
                    weight = Float.valueOf(0.0f);
                }
                if ((queryCount = (Integer)queryMap.get(dictWord)) == null) continue;
                sum = (float)((double)sum + (1.0 + Math.log(Math.min(queryCount, dictCount))) * (double)weight.floatValue() * (double)weight.floatValue());
            }
            Score score = new Score(docId, sum /= queryNorm * dictNorm);
            scoreList.add(score);
        }
        Collections.sort(scoreList);
        return scoreList;
    }

    public List<Integer> quntinize(List<? extends Clusterable> points) {
        return this.tree.addImage(points);
    }

    public List<Score> getCandidate(List<Integer> visualWords) {
        Integer vwId;
        List docList;
        HashMap<Integer, Integer> voteMap = new HashMap<Integer, Integer>();
        Iterator<Integer> iter = visualWords.iterator();
        while (iter.hasNext() && (docList = (List)this.simpleInvertedFile.get(vwId = iter.next())) != null) {
            for (Integer docId : docList) {
                Integer vote = (Integer)voteMap.get(docId);
                if (vote == null) {
                    vote = 1;
                } else {
                    Integer n = vote;
                    Integer n2 = vote = Integer.valueOf(vote + 1);
                }
                voteMap.put(docId, vote);
            }
        }
        ArrayList<Score> scoreList = new ArrayList<Score>();
        for (Map.Entry entry : voteMap.entrySet()) {
            scoreList.add(new Score((Integer)entry.getKey(), ((Integer)entry.getValue()).intValue()));
        }
        Collections.sort(scoreList);
        return scoreList;
    }

    public void buildIndex(List<? extends Clusterable> points, int Id) {
        List<Integer> visualWords = this.tree.addImage(points);
        Collections.sort(visualWords);
        this.simpleHistogramFile.put(Id, visualWords);
        for (Integer vw : visualWords) {
            LinkedList<Integer> tmpInvertFile = this.simpleInvertedFile.get(vw);
            if (tmpInvertFile == null) {
                tmpInvertFile = new LinkedList();
            }
            if (!tmpInvertFile.contains(Id)) {
                tmpInvertFile.add(Id);
            }
            this.simpleInvertedFile.put(vw, tmpInvertFile);
        }
        ++this.total_images;
        this.total_features += points.size();
        points.clear();
    }

    public void buildWeight() {
        if (this.simpleInvertedFile == null) {
            return;
        }
        this.simpleWeightFile = new HashMap<Integer, Float>();
        for (Map.Entry<Integer, LinkedList<Integer>> entry : this.simpleInvertedFile.entrySet()) {
            Integer vwId = entry.getKey();
            Integer docNum = entry.getValue().size();
            Float weight = Float.valueOf(0.0f);
            if (docNum > 0) {
                weight = Float.valueOf((float)Math.log(this.total_images / docNum));
            }
            this.simpleWeightFile.put(vwId, weight);
        }
    }

    public void saveIndex(String indexPath) {
        SerializationUtils.saveObject(this.simpleInvertedFile, new File(indexPath));
    }

    public boolean loadIndex(String indexPath) {
        this.simpleInvertedFile = (Map)SerializationUtils.loadObject(indexPath);
        return this.simpleInvertedFile != null;
    }

    public void saveWeight(String weightPath) {
        SerializationUtils.saveObject(this.simpleWeightFile, new File(weightPath));
    }

    public boolean loadWeight(String weightPath) {
        this.simpleWeightFile = (Map)SerializationUtils.loadObject(weightPath);
        return this.simpleWeightFile != null;
    }

    public boolean loadTree(String treePath) {
        this.tree = (KMeansTree)SerializationUtils.loadObject(treePath);
        return this.tree != null;
    }

    public void loadHistogram(String histogramPath) {
        this.simpleHistogramFile = (Map)SerializationUtils.loadObject(histogramPath);
    }

    public void saveHistogram(String histogramPath) {
        SerializationUtils.saveObject(this.simpleHistogramFile, new File(histogramPath));
    }
}

