/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.simpleimage.util;

import com.alibaba.simpleimage.render.DrawTextItem;
import com.alibaba.simpleimage.render.DrawTextParameter;
import com.alibaba.simpleimage.render.WatermarkParameter;
import com.alibaba.simpleimage.util.ImageLog;
import com.alibaba.simpleimage.util.JAIRegisterHelper;
import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;

public class ImageDrawHelper {
    private static ImageLog log;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawText(BufferedImage src, DrawTextParameter dp) {
        if (dp == null || dp.getTextInfo() == null || dp.getTextInfo().size() == 0) {
            return;
        }
        int width = src.getWidth();
        int height = src.getHeight();
        Graphics2D graphics = src.createGraphics();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        try {
            for (DrawTextItem item : dp.getTextInfo()) {
                if (item == null) continue;
                item.drawText(graphics, width, height);
            }
        }
        finally {
            if (graphics != null) {
                graphics.dispose();
            }
            log.debug("After drawText", src);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage drawWatermark(BufferedImage src, WatermarkParameter param) {
        if (param == null) {
            return src;
        }
        if (param.getX() > src.getWidth() || param.getY() > src.getHeight()) {
            throw new IllegalArgumentException("Watermark's coordinate(" + param.getX() + ", " + param.getY() + ") exceed " + "the dimension of background image(" + src.getWidth() + ", " + src.getHeight() + ")");
        }
        Graphics2D graphics = src.createGraphics();
        Composite oldComposite = graphics.getComposite();
        graphics.setComposite(AlphaComposite.getInstance(3, param.getAlpha()));
        try {
            graphics.drawImage(param.getWatermark().getAsBufferedImage(), null, param.getX(), param.getY());
        }
        finally {
            if (graphics != null) {
                graphics.setComposite(oldComposite);
                graphics.dispose();
            }
        }
        return src;
    }

    static {
        JAIRegisterHelper.register();
        log = ImageLog.getLog(ImageDrawHelper.class);
    }
}

