/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.simpleimage.util;

import com.alibaba.simpleimage.ImageWrapper;
import com.alibaba.simpleimage.SimpleImageException;
import com.alibaba.simpleimage.jai.scale.LanczosScaleOp;
import com.alibaba.simpleimage.render.ScaleParameter;
import com.alibaba.simpleimage.util.ImageLog;
import com.alibaba.simpleimage.util.NodeUtils;
import com.sun.media.jai.opimage.SubsampleAverageCRIF;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import javax.media.jai.BorderExtender;
import javax.media.jai.Interpolation;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.RenderedImageAdapter;
import org.w3c.dom.Node;

public class ImageScaleHelper {
    private static ImageLog log = ImageLog.getLog(ImageScaleHelper.class);

    public static ImageWrapper scaleGIF(ImageWrapper imgWrapper, ScaleParameter zoom) throws SimpleImageException {
        Node streamMetadata = imgWrapper.getStreamMetadata();
        int width = 0;
        int height = 0;
        Node screenDescNode = NodeUtils.getChild(streamMetadata, "LogicalScreenDescriptor");
        if (screenDescNode != null) {
            width = NodeUtils.getIntAttr(screenDescNode, "logicalScreenWidth");
            height = NodeUtils.getIntAttr(screenDescNode, "logicalScreenHeight");
        }
        if (width <= 0 || height <= 0) {
            width = imgWrapper.getAsBufferedImage().getWidth();
            height = imgWrapper.getAsBufferedImage().getHeight();
        }
        if (zoom.getMaxWidth() >= width && zoom.getMaxHeight() >= height) {
            return imgWrapper;
        }
        double scale = ImageScaleHelper.computeDoubleScale(width, height, zoom);
        int newWidth = (int)((double)width * scale);
        int newHeight = (int)((double)height * scale);
        NodeUtils.setAttrValue(screenDescNode, "logicalScreenWidth", newWidth);
        NodeUtils.setAttrValue(screenDescNode, "logicalScreenHeight", newHeight);
        NodeUtils.removeChild(streamMetadata, "GlobalColorTable");
        for (int i = 0; i < imgWrapper.getNumOfImages(); ++i) {
            PlanarImage img = imgWrapper.getAsPlanarImage(i);
            Node imgMetadata = imgWrapper.getMetadata(i);
            if (img.getColorModel() instanceof IndexColorModel) {
                throw new SimpleImageException("Unsupported scale image with IndexColorModel, please convert to RGB color model first");
            }
            Node imgDescNode = NodeUtils.getChild(imgMetadata, "ImageDescriptor");
            int x = NodeUtils.getIntAttr(imgDescNode, "imageLeftPosition");
            int y = NodeUtils.getIntAttr(imgDescNode, "imageTopPosition");
            int newX = (int)((double)x * scale);
            int newY = (int)((double)y * scale);
            newX = newX > 0 ? newX : 0;
            newY = newY > 0 ? newY : 0;
            NodeUtils.setAttrValue(imgDescNode, "imageLeftPosition", newX);
            NodeUtils.setAttrValue(imgDescNode, "imageTopPosition", newY);
            int imgWidth = NodeUtils.getIntAttr(imgDescNode, "imageWidth");
            int imgHeight = NodeUtils.getIntAttr(imgDescNode, "imageHeight");
            int newImgWidth = (int)((double)imgWidth * scale);
            int newImgHeight = (int)((double)imgHeight * scale);
            newImgWidth = newImgWidth > 1 ? newImgWidth : 1;
            newImgHeight = newImgHeight > 1 ? newImgHeight : 1;
            NodeUtils.setAttrValue(imgDescNode, "imageWidth", newImgWidth);
            NodeUtils.setAttrValue(imgDescNode, "imageHeight", newImgHeight);
            if (zoom.getAlgorithm() == ScaleParameter.Algorithm.INTERP_BICUBIC) {
                img = ImageScaleHelper.bicubicScaleImage(img, (float)scale, 2);
            } else if (zoom.getAlgorithm() == ScaleParameter.Algorithm.INTERP_BICUBIC_2) {
                img = ImageScaleHelper.bicubicScaleImage(img, (float)scale, 3);
            } else if (zoom.getAlgorithm() == ScaleParameter.Algorithm.SUBSAMPLE_AVG) {
                img = ImageScaleHelper.subsampleavgScaleImage(img, scale);
            } else if (zoom.getAlgorithm() == ScaleParameter.Algorithm.LANCZOS) {
                img = ImageScaleHelper.lanczosScaleImage(img, scale);
            } else if (zoom.getAlgorithm() == ScaleParameter.Algorithm.AUTO) {
                img = ImageScaleHelper.autoScaleImage(img, scale);
            } else {
                throw new IllegalArgumentException("Unknow algorithm");
            }
            imgWrapper.setImage(i, img);
        }
        return imgWrapper;
    }

    public static PlanarImage scale(PlanarImage input, ScaleParameter zoom) {
        int w = input.getWidth();
        int h = input.getHeight();
        if (zoom.getMaxWidth() >= w && zoom.getMaxHeight() >= h) {
            return input;
        }
        if (zoom.getAlgorithm() == ScaleParameter.Algorithm.INTERP_BICUBIC) {
            float scale = ImageScaleHelper.computeFloatScale(w, h, zoom);
            return ImageScaleHelper.bicubicScaleImage(input, scale, 2);
        }
        if (zoom.getAlgorithm() == ScaleParameter.Algorithm.INTERP_BICUBIC_2) {
            float scale = ImageScaleHelper.computeFloatScale(w, h, zoom);
            return ImageScaleHelper.bicubicScaleImage(input, scale, 3);
        }
        if (zoom.getAlgorithm() == ScaleParameter.Algorithm.SUBSAMPLE_AVG) {
            double scale = ImageScaleHelper.computeDoubleScale(w, h, zoom);
            return ImageScaleHelper.subsampleavgScaleImage(input, scale);
        }
        if (zoom.getAlgorithm() == ScaleParameter.Algorithm.LANCZOS) {
            double scale = ImageScaleHelper.computeDoubleScale(w, h, zoom);
            return ImageScaleHelper.lanczosScaleImage(input, scale);
        }
        if (zoom.getAlgorithm() == ScaleParameter.Algorithm.AUTO) {
            double scale = ImageScaleHelper.computeDoubleScale(w, h, zoom);
            return ImageScaleHelper.autoScaleImage(input, scale);
        }
        if (zoom.getAlgorithm() == ScaleParameter.Algorithm.PROGRESSIVE) {
            throw new UnsupportedOperationException("Deprecated method");
        }
        throw new IllegalArgumentException("Unknow algorithm");
    }

    public static float computeFloatScale(int w, int h, ScaleParameter zoom) {
        int maxWidth = zoom.getMaxWidth();
        int maxHeight = zoom.getMaxHeight();
        float scale = 0.0f;
        scale = Math.min((float)maxWidth / (float)w, (float)maxHeight / (float)h);
        return scale;
    }

    public static double computeDoubleScale(int w, int h, ScaleParameter zoom) {
        int maxWidth = zoom.getMaxWidth();
        int maxHeight = zoom.getMaxHeight();
        double scale = 0.0;
        scale = Math.min((double)maxWidth / (double)w, (double)maxHeight / (double)h);
        return scale;
    }

    public static PlanarImage bicubicScaleImage(PlanarImage input, float scale, int alg) {
        RenderingHints qualityHints = new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        qualityHints.put(JAI.KEY_BORDER_EXTENDER, BorderExtender.createInstance((int)1));
        ParameterBlock pb = new ParameterBlock();
        pb.addSource(input);
        pb.add(scale);
        pb.add(scale);
        pb.add(0.0f);
        pb.add(0.0f);
        pb.add(Interpolation.getInstance((int)alg));
        return JAI.create((String)"scale", (ParameterBlock)pb, (RenderingHints)qualityHints);
    }

    public static PlanarImage subsampleavgScaleImage(PlanarImage input, double scale) {
        RenderingHints qualityHints = new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        ParameterBlock pb = new ParameterBlock();
        pb.addSource(input);
        pb.add(scale);
        pb.add(scale);
        SubsampleAverageCRIF factory = new SubsampleAverageCRIF();
        PlanarImage zoomOp = (PlanarImage)factory.create(pb, qualityHints);
        return zoomOp;
    }

    public static PlanarImage lanczosScaleImage(PlanarImage input, double scale) {
        LanczosScaleOp lanczosOp = new LanczosScaleOp(scale, scale);
        BufferedImage dest = lanczosOp.compute(input.getAsBufferedImage());
        return PlanarImage.wrapRenderedImage((RenderedImage)dest);
    }

    public static PlanarImage autoScaleImage(PlanarImage input, double scale) {
        if (input.getWidth() > 3000 || input.getHeight() > 3000) {
            return ImageScaleHelper.subsampleavgScaleImage(input, scale);
        }
        try {
            return ImageScaleHelper.lanczosScaleImage(input, scale);
        }
        catch (Exception e) {
            log.warn("LanczosScale fail : " + e.getMessage(), (RenderedImage)input);
            return ImageScaleHelper.subsampleavgScaleImage(input, scale);
        }
    }

    @Deprecated
    public static PlanarImage progressiveScaleImage(PlanarImage input, int targetWidth, int targetHeight, Object hint, boolean progressive) {
        int h;
        int w;
        boolean isTranslucent;
        BufferedImage img = input.getAsBufferedImage();
        int type = img.getTransparency() == 1 ? 1 : 2;
        BufferedImage ret = img;
        BufferedImage scratchImage = null;
        Graphics2D g2 = null;
        int prevW = ret.getWidth();
        int prevH = ret.getHeight();
        boolean bl = isTranslucent = img.getTransparency() != 1;
        if (progressive) {
            w = img.getWidth();
            h = img.getHeight();
        } else {
            w = targetWidth;
            h = targetHeight;
        }
        do {
            if (progressive && w > targetWidth && (w /= 2) < targetWidth) {
                w = targetWidth;
            }
            if (progressive && h > targetHeight && (h /= 2) < targetHeight) {
                h = targetHeight;
            }
            if (scratchImage == null || isTranslucent) {
                scratchImage = new BufferedImage(w, h, type);
                g2 = scratchImage.createGraphics();
            }
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, hint);
            g2.drawImage(ret, 0, 0, w, h, 0, 0, prevW, prevH, null);
            prevW = w;
            prevH = h;
            ret = scratchImage;
        } while (w != targetWidth || h != targetHeight);
        if (g2 != null) {
            g2.dispose();
        }
        if (targetWidth != ret.getWidth() || targetHeight != ret.getHeight()) {
            scratchImage = new BufferedImage(targetWidth, targetHeight, type);
            g2 = scratchImage.createGraphics();
            g2.drawImage((Image)ret, 0, 0, null);
            g2.dispose();
            ret = scratchImage;
        }
        return new RenderedImageAdapter((RenderedImage)ret);
    }
}

