/*
 * Decompiled with CFR 0.152.
 */
package com.alicp.jetcache.anno.support;

import com.alicp.jetcache.CacheManager;
import com.alicp.jetcache.anno.support.AbstractLifecycle;
import com.alicp.jetcache.anno.support.CacheContext;
import com.alicp.jetcache.anno.support.CacheMonitorManager;
import com.alicp.jetcache.anno.support.CacheNameGenerator;
import com.alicp.jetcache.anno.support.DefaultCacheMonitorManager;
import com.alicp.jetcache.anno.support.DefaultCacheNameGenerator;
import com.alicp.jetcache.anno.support.DefaultEncoderParser;
import com.alicp.jetcache.anno.support.DefaultKeyConvertorParser;
import com.alicp.jetcache.anno.support.EncoderParser;
import com.alicp.jetcache.anno.support.GlobalCacheConfig;
import com.alicp.jetcache.anno.support.KeyConvertorParser;
import com.alicp.jetcache.support.StatInfo;
import com.alicp.jetcache.support.StatInfoLogger;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigProvider
extends AbstractLifecycle {
    private static final Logger logger = LoggerFactory.getLogger(ConfigProvider.class);
    @Resource
    protected GlobalCacheConfig globalCacheConfig;
    protected CacheManager cacheManager;
    protected EncoderParser encoderParser;
    protected KeyConvertorParser keyConvertorParser;
    protected CacheMonitorManager cacheMonitorManager;
    private Consumer<StatInfo> metricsCallback = new StatInfoLogger(false);
    private final CacheMonitorManager defaultCacheMonitorManager = new DefaultCacheMonitorManager();
    private CacheContext cacheContext;

    public ConfigProvider() {
        this.cacheManager = CacheManager.defaultManager();
        this.encoderParser = new DefaultEncoderParser();
        this.keyConvertorParser = new DefaultKeyConvertorParser();
        this.cacheMonitorManager = this.defaultCacheMonitorManager;
    }

    @Override
    public void doInit() {
        this.initDefaultCacheMonitorInstaller();
        this.cacheContext = this.newContext();
    }

    protected void initDefaultCacheMonitorInstaller() {
        if (this.cacheMonitorManager == this.defaultCacheMonitorManager) {
            DefaultCacheMonitorManager cacheMonitorManager = (DefaultCacheMonitorManager)this.cacheMonitorManager;
            cacheMonitorManager.setGlobalCacheConfig(this.globalCacheConfig);
            cacheMonitorManager.setMetricsCallback(this.metricsCallback);
            cacheMonitorManager.setConfigProvider(this);
            cacheMonitorManager.init();
        }
    }

    @Override
    public void doShutdown() {
        try {
            this.shutdownDefaultCacheMonitorInstaller();
            if (this.cacheManager instanceof AutoCloseable) {
                ((AutoCloseable)this.cacheManager).close();
            }
        }
        catch (Exception e) {
            logger.error("close fail", (Throwable)e);
        }
    }

    protected void shutdownDefaultCacheMonitorInstaller() {
        if (this.cacheMonitorManager == this.defaultCacheMonitorManager) {
            ((AbstractLifecycle)((Object)this.cacheMonitorManager)).shutdown();
        }
    }

    public Function<Object, byte[]> parseValueEncoder(String valueEncoder) {
        return this.encoderParser.parseEncoder(valueEncoder);
    }

    public Function<byte[], Object> parseValueDecoder(String valueDecoder) {
        return this.encoderParser.parseDecoder(valueDecoder);
    }

    public Function<Object, Object> parseKeyConvertor(String convertor) {
        return this.keyConvertorParser.parseKeyConvertor(convertor);
    }

    public CacheNameGenerator createCacheNameGenerator(String[] hiddenPackages) {
        return new DefaultCacheNameGenerator(hiddenPackages);
    }

    protected CacheContext newContext() {
        return new CacheContext(this, this.globalCacheConfig);
    }

    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public CacheManager getCacheManager() {
        return this.cacheManager;
    }

    public void setEncoderParser(EncoderParser encoderParser) {
        this.encoderParser = encoderParser;
    }

    public void setKeyConvertorParser(KeyConvertorParser keyConvertorParser) {
        this.keyConvertorParser = keyConvertorParser;
    }

    public CacheMonitorManager getCacheMonitorManager() {
        return this.cacheMonitorManager;
    }

    public void setCacheMonitorManager(CacheMonitorManager cacheMonitorManager) {
        this.cacheMonitorManager = cacheMonitorManager;
    }

    public GlobalCacheConfig getGlobalCacheConfig() {
        return this.globalCacheConfig;
    }

    public void setGlobalCacheConfig(GlobalCacheConfig globalCacheConfig) {
        this.globalCacheConfig = globalCacheConfig;
    }

    public CacheContext getCacheContext() {
        return this.cacheContext;
    }

    public void setMetricsCallback(Consumer<StatInfo> metricsCallback) {
        this.metricsCallback = metricsCallback;
    }
}

