/*
 * Decompiled with CFR 0.152.
 */
package com.arronlong.httpclientutil.evictor;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.http.nio.conn.NHttpClientConnectionManager;
import org.apache.http.util.Args;

public final class NIdleConnectionEvictor {
    private NHttpClientConnectionManager connMgr;
    private final ThreadFactory threadFactory;
    private final Thread thread;
    private final long sleepTimeMs;
    private final long maxIdleTimeMs;
    private volatile Exception exception;

    public NIdleConnectionEvictor(final NHttpClientConnectionManager connMgr, ThreadFactory threadFactory, long sleepTime, TimeUnit sleepTimeUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        this.connMgr = connMgr;
        this.threadFactory = threadFactory != null ? threadFactory : new DefaultThreadFactory();
        this.sleepTimeMs = sleepTimeUnit != null ? sleepTimeUnit.toMillis(sleepTime) : sleepTime;
        this.maxIdleTimeMs = maxIdleTimeUnit != null ? maxIdleTimeUnit.toMillis(maxIdleTime) : maxIdleTime;
        this.thread = this.threadFactory.newThread(new Runnable(){

            @Override
            public void run() {
                try {
                    while (!Thread.currentThread().isInterrupted()) {
                        Thread.sleep(NIdleConnectionEvictor.this.sleepTimeMs);
                        connMgr.closeExpiredConnections();
                        if (NIdleConnectionEvictor.this.maxIdleTimeMs <= 0L) continue;
                        connMgr.closeIdleConnections(NIdleConnectionEvictor.this.maxIdleTimeMs, TimeUnit.MILLISECONDS);
                    }
                }
                catch (Exception ex) {
                    NIdleConnectionEvictor.this.exception = ex;
                }
            }
        });
    }

    public NIdleConnectionEvictor(NHttpClientConnectionManager connMgr, long sleepTime, TimeUnit sleepTimeUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        this(connMgr, null, sleepTime, sleepTimeUnit, maxIdleTime, maxIdleTimeUnit);
    }

    public NIdleConnectionEvictor(NHttpClientConnectionManager connMgr, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        this(connMgr, null, maxIdleTime > 0L ? maxIdleTime : 5L, maxIdleTimeUnit != null ? maxIdleTimeUnit : TimeUnit.SECONDS, maxIdleTime, maxIdleTimeUnit);
    }

    public NIdleConnectionEvictor(long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        this(null, null, maxIdleTime > 0L ? maxIdleTime : 5L, maxIdleTimeUnit != null ? maxIdleTimeUnit : TimeUnit.SECONDS, maxIdleTime, maxIdleTimeUnit);
    }

    public NIdleConnectionEvictor setConnMgr(NHttpClientConnectionManager connMgr) {
        this.connMgr = (NHttpClientConnectionManager)Args.notNull((Object)connMgr, (String)"Connection manager");
        return this;
    }

    public void start() {
        Args.notNull((Object)this.connMgr, (String)"Connection manager");
        this.thread.start();
    }

    public void shutdown() {
        this.thread.interrupt();
    }

    public boolean isRunning() {
        return this.thread.isAlive();
    }

    public void awaitTermination(long time, TimeUnit tunit) throws InterruptedException {
        this.thread.join((tunit != null ? tunit : TimeUnit.MILLISECONDS).toMillis(time));
    }

    public void await() {
        try {
            this.shutdown();
            this.thread.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    static class DefaultThreadFactory
    implements ThreadFactory {
        DefaultThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r, "Connection evictor");
            t.setDaemon(true);
            return t;
        }
    }
}

