/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.amqp.implementation;

import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Locale;
import java.util.Objects;

public class ConnectionStringProperties {
    private final ClientLogger logger = new ClientLogger(ConnectionStringProperties.class);
    private static final String TOKEN_VALUE_SEPARATOR = "=";
    private static final String ENDPOINT_SCHEME_SB_PREFIX = "sb://";
    private static final String ENDPOINT_SCHEME_HTTP_PREFIX = "http://";
    private static final String ENDPOINT_SCHEME_HTTPS_PREFIX = "https://";
    private static final String TOKEN_VALUE_PAIR_DELIMITER = ";";
    private static final String ENDPOINT = "Endpoint";
    private static final String SHARED_ACCESS_KEY_NAME = "SharedAccessKeyName";
    private static final String SHARED_ACCESS_KEY = "SharedAccessKey";
    private static final String SHARED_ACCESS_SIGNATURE = "SharedAccessSignature";
    private static final String SAS_VALUE_PREFIX = "sharedaccesssignature ";
    private static final String ENTITY_PATH = "EntityPath";
    private static final String CONNECTION_STRING_WITH_ACCESS_KEY = "Endpoint={endpoint};SharedAccessKeyName={sharedAccessKeyName};SharedAccessKey={sharedAccessKey};EntityPath={entityPath}";
    private static final String CONNECTION_STRING_WITH_SAS = "Endpoint={endpoint};SharedAccessSignature=SharedAccessSignature {sharedAccessSignature};EntityPath={entityPath}";
    private static final String ERROR_MESSAGE_FORMAT = "Could not parse 'connectionString'. Expected format: Endpoint={endpoint};SharedAccessKeyName={sharedAccessKeyName};SharedAccessKey={sharedAccessKey};EntityPath={entityPath} or Endpoint={endpoint};SharedAccessSignature=SharedAccessSignature {sharedAccessSignature};EntityPath={entityPath}. Actual: %s";
    private static final String ERROR_MESSAGE_ENDPOINT_FORMAT = "'Endpoint' must be provided in 'connectionString'. Actual: %s";
    private final URI endpoint;
    private final String entityPath;
    private final String sharedAccessKeyName;
    private final String sharedAccessKey;
    private final String sharedAccessSignature;

    public ConnectionStringProperties(String connectionString) {
        boolean includesSharedAccessSignature;
        Objects.requireNonNull(connectionString, "'connectionString' cannot be null.");
        if (connectionString.isEmpty()) {
            throw new IllegalArgumentException("'connectionString' cannot be an empty string.");
        }
        String[] tokenValuePairs = connectionString.split(TOKEN_VALUE_PAIR_DELIMITER);
        URI endpoint = null;
        String entityPath = null;
        String sharedAccessKeyName = null;
        String sharedAccessKeyValue = null;
        String sharedAccessSignature = null;
        for (String tokenValuePair : tokenValuePairs) {
            String[] pair = tokenValuePair.split(TOKEN_VALUE_SEPARATOR, 2);
            if (pair.length != 2) {
                throw new IllegalArgumentException(String.format(Locale.US, "Connection string has invalid key value pair: %s", tokenValuePair));
            }
            String key = pair[0].trim();
            String value = pair[1].trim();
            if (key.equalsIgnoreCase(ENDPOINT)) {
                String endpointUri = this.validateAndUpdateDefaultScheme(value, connectionString);
                try {
                    endpoint = new URI(endpointUri);
                    continue;
                }
                catch (URISyntaxException e) {
                    throw new IllegalArgumentException(String.format(Locale.US, "Invalid endpoint: %s", tokenValuePair), e);
                }
            }
            if (key.equalsIgnoreCase(SHARED_ACCESS_KEY_NAME)) {
                sharedAccessKeyName = value;
                continue;
            }
            if (key.equalsIgnoreCase(SHARED_ACCESS_KEY)) {
                sharedAccessKeyValue = value;
                continue;
            }
            if (key.equalsIgnoreCase(ENTITY_PATH)) {
                entityPath = value;
                continue;
            }
            if (key.equalsIgnoreCase(SHARED_ACCESS_SIGNATURE) && value.toLowerCase(Locale.ROOT).startsWith(SAS_VALUE_PREFIX)) {
                sharedAccessSignature = value;
                continue;
            }
            throw new IllegalArgumentException(String.format(Locale.US, "Illegal connection string parameter name: %s", key));
        }
        boolean includesSharedKey = sharedAccessKeyName != null || sharedAccessKeyValue != null;
        boolean hasSharedKeyAndValue = sharedAccessKeyName != null && sharedAccessKeyValue != null;
        boolean bl = includesSharedAccessSignature = sharedAccessSignature != null;
        if (endpoint == null || includesSharedKey && includesSharedAccessSignature || !hasSharedKeyAndValue && !includesSharedAccessSignature) {
            throw new IllegalArgumentException(String.format(Locale.US, ERROR_MESSAGE_FORMAT, connectionString));
        }
        this.endpoint = endpoint;
        this.entityPath = entityPath;
        this.sharedAccessKeyName = sharedAccessKeyName;
        this.sharedAccessKey = sharedAccessKeyValue;
        this.sharedAccessSignature = sharedAccessSignature;
    }

    public URI getEndpoint() {
        return this.endpoint;
    }

    public String getEntityPath() {
        return this.entityPath;
    }

    public String getSharedAccessKeyName() {
        return this.sharedAccessKeyName;
    }

    public String getSharedAccessKey() {
        return this.sharedAccessKey;
    }

    public String getSharedAccessSignature() {
        return this.sharedAccessSignature;
    }

    private String validateAndUpdateDefaultScheme(String endpoint, String connectionString) {
        String updatedEndpoint = endpoint.trim();
        if (CoreUtils.isNullOrEmpty((CharSequence)endpoint)) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format(Locale.US, ERROR_MESSAGE_ENDPOINT_FORMAT, connectionString)));
        }
        String endpointLowerCase = endpoint.toLowerCase(Locale.getDefault());
        if (!(endpointLowerCase.startsWith(ENDPOINT_SCHEME_SB_PREFIX) || endpointLowerCase.startsWith(ENDPOINT_SCHEME_HTTP_PREFIX) || endpointLowerCase.startsWith(ENDPOINT_SCHEME_HTTPS_PREFIX))) {
            updatedEndpoint = ENDPOINT_SCHEME_SB_PREFIX + endpoint;
        }
        return updatedEndpoint;
    }
}

