/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.amqp.implementation;

import com.azure.core.amqp.AmqpTransportType;
import com.azure.core.amqp.ProxyOptions;
import com.azure.core.amqp.implementation.ReactorProvider;
import com.azure.core.amqp.implementation.handler.ConnectionHandler;
import com.azure.core.amqp.implementation.handler.ReceiveLinkHandler;
import com.azure.core.amqp.implementation.handler.SendLinkHandler;
import com.azure.core.amqp.implementation.handler.SessionHandler;
import com.azure.core.amqp.implementation.handler.WebSocketsConnectionHandler;
import com.azure.core.amqp.implementation.handler.WebSocketsProxyConnectionHandler;
import com.azure.core.util.ClientOptions;
import com.azure.core.util.logging.ClientLogger;
import java.time.Duration;
import java.util.Locale;
import org.apache.qpid.proton.engine.SslDomain;

public class ReactorHandlerProvider {
    private final ClientLogger logger = new ClientLogger(ReactorHandlerProvider.class);
    private final ReactorProvider provider;

    public ReactorHandlerProvider(ReactorProvider provider) {
        this.provider = provider;
    }

    public ConnectionHandler createConnectionHandler(String connectionId, String hostname, AmqpTransportType transportType, ProxyOptions proxyOptions, String product, String clientVersion, SslDomain.VerifyMode verifyMode, ClientOptions clientOptions) {
        switch (transportType) {
            case AMQP: {
                return new ConnectionHandler(connectionId, hostname, product, clientVersion, verifyMode, clientOptions);
            }
            case AMQP_WEB_SOCKETS: {
                if (proxyOptions != null && proxyOptions.isProxyAddressConfigured()) {
                    return new WebSocketsProxyConnectionHandler(connectionId, hostname, proxyOptions, product, clientVersion, verifyMode, clientOptions);
                }
                if (WebSocketsProxyConnectionHandler.shouldUseProxy(hostname)) {
                    this.logger.info("System default proxy configured for hostname '{}'. Using proxy.", new Object[]{hostname});
                    return new WebSocketsProxyConnectionHandler(connectionId, hostname, ProxyOptions.SYSTEM_DEFAULTS, product, clientVersion, verifyMode, clientOptions);
                }
                return new WebSocketsConnectionHandler(connectionId, hostname, product, clientVersion, verifyMode, clientOptions);
            }
        }
        throw this.logger.logExceptionAsWarning((RuntimeException)new IllegalArgumentException(String.format(Locale.US, "This transport type '%s' is not supported.", new Object[]{transportType})));
    }

    public SessionHandler createSessionHandler(String connectionId, String hostname, String sessionName, Duration openTimeout) {
        return new SessionHandler(connectionId, hostname, sessionName, this.provider.getReactorDispatcher(), openTimeout);
    }

    public SendLinkHandler createSendLinkHandler(String connectionId, String fullyQualifiedNamespace, String senderName, String entityPath) {
        return new SendLinkHandler(connectionId, fullyQualifiedNamespace, senderName, entityPath);
    }

    public ReceiveLinkHandler createReceiveLinkHandler(String connectionId, String fullyQualifiedNamespace, String receiverName, String entityPath) {
        return new ReceiveLinkHandler(connectionId, fullyQualifiedNamespace, receiverName, entityPath);
    }
}

