/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.util;

import com.azure.core.implementation.ReflectionUtils;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonValue;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

public abstract class ExpandableStringEnum<T extends ExpandableStringEnum<T>> {
    private static final Map<Class<?>, MethodHandle> CONSTRUCTORS = new ConcurrentHashMap();
    private static final Map<Class<?>, ConcurrentHashMap<String, ? extends ExpandableStringEnum<?>>> VALUES = new ConcurrentHashMap();
    private static final ClientLogger LOGGER = new ClientLogger(ExpandableStringEnum.class);
    private String name;
    private Class<T> clazz;

    @Deprecated
    public ExpandableStringEnum() {
    }

    protected static <T extends ExpandableStringEnum<T>> T fromString(String name, Class<T> clazz) {
        if (name == null) {
            return null;
        }
        ConcurrentHashMap clazzValues = VALUES.computeIfAbsent(clazz, key -> new ConcurrentHashMap());
        ExpandableStringEnum value = (ExpandableStringEnum)clazzValues.get(name);
        if (value != null) {
            return (T)value;
        }
        MethodHandle ctor = CONSTRUCTORS.computeIfAbsent(clazz, ExpandableStringEnum::getDefaultConstructor);
        if (ctor == null) {
            return null;
        }
        try {
            value = ctor.invoke();
        }
        catch (Throwable e) {
            LOGGER.warning("Failed to create {}, default constructor threw exception", clazz.getName(), e);
            return null;
        }
        return (T)value.nameAndAddValue(name, value, clazz);
    }

    private static <T> MethodHandle getDefaultConstructor(Class<T> clazz) {
        try {
            MethodHandles.Lookup lookup = ReflectionUtils.getLookupToUse(clazz);
            return lookup.findConstructor(clazz, MethodType.methodType(Void.TYPE));
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            LOGGER.verbose("Can't find or access default constructor for {}, make sure corresponding package is open to azure-core", clazz.getName(), e);
        }
        catch (Exception e) {
            LOGGER.verbose("Failed to get lookup for {}", clazz.getName(), e);
        }
        return null;
    }

    T nameAndAddValue(String name, T value, Class<T> clazz) {
        this.name = name;
        this.clazz = clazz;
        VALUES.get(clazz).put(name, (ExpandableStringEnum<?>)value);
        return (T)this;
    }

    protected static <T extends ExpandableStringEnum<T>> Collection<T> values(Class<T> clazz) {
        return new ArrayList(VALUES.getOrDefault(clazz, new ConcurrentHashMap()).values());
    }

    @JsonValue
    public String toString() {
        return this.name;
    }

    public int hashCode() {
        return Objects.hash(this.clazz, this.name);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.clazz == null || !this.clazz.isAssignableFrom(obj.getClass())) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (this.name == null) {
            return ((ExpandableStringEnum)obj).name == null;
        }
        return this.name.equals(((ExpandableStringEnum)obj).name);
    }
}

