/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.bmr;

import com.baidubce.AbstractBceClient;
import com.baidubce.BceClientConfiguration;
import com.baidubce.BceClientException;
import com.baidubce.auth.SignOptions;
import com.baidubce.http.HttpMethodName;
import com.baidubce.http.handler.BceErrorResponseHandler;
import com.baidubce.http.handler.BceJsonResponseHandler;
import com.baidubce.http.handler.BceMetadataResponseHandler;
import com.baidubce.http.handler.HttpResponseHandler;
import com.baidubce.internal.InternalRequest;
import com.baidubce.internal.RestartableInputStream;
import com.baidubce.model.AbstractBceRequest;
import com.baidubce.model.AbstractBceResponse;
import com.baidubce.services.bmr.model.AddStepsRequest;
import com.baidubce.services.bmr.model.AddStepsResponse;
import com.baidubce.services.bmr.model.ApplicationConfig;
import com.baidubce.services.bmr.model.CreateClusterRequest;
import com.baidubce.services.bmr.model.CreateClusterResponse;
import com.baidubce.services.bmr.model.GetClusterRequest;
import com.baidubce.services.bmr.model.GetClusterResponse;
import com.baidubce.services.bmr.model.GetStepRequest;
import com.baidubce.services.bmr.model.GetStepResponse;
import com.baidubce.services.bmr.model.InstanceGroupConfig;
import com.baidubce.services.bmr.model.ListClustersRequest;
import com.baidubce.services.bmr.model.ListClustersResponse;
import com.baidubce.services.bmr.model.ListInstanceGroupsRequest;
import com.baidubce.services.bmr.model.ListInstanceGroupsResponse;
import com.baidubce.services.bmr.model.ListInstancesRequest;
import com.baidubce.services.bmr.model.ListInstancesResponse;
import com.baidubce.services.bmr.model.ListStepsRequest;
import com.baidubce.services.bmr.model.ListStepsResponse;
import com.baidubce.services.bmr.model.StepConfig;
import com.baidubce.services.bmr.model.TerminateClusterRequest;
import com.baidubce.util.HttpUtils;
import com.baidubce.util.JsonUtils;
import com.baidubce.util.Validate;
import com.fasterxml.jackson.core.JsonGenerator;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class BmrClient
extends AbstractBceClient {
    private static final String VERSION = "v1";
    private static final String CLUSTER = "cluster";
    private static final String INSTANCE_GROUP = "instanceGroup";
    private static final String INSTANCE = "instance";
    private static final String STEP = "step";
    private static final String[] HEADERS_TO_SIGN = new String[]{"host", "x-bce-date"};
    private static final HttpResponseHandler[] BMR_HANDLERS = new HttpResponseHandler[]{new BceMetadataResponseHandler(), new BceErrorResponseHandler(), new BceJsonResponseHandler()};

    public BmrClient() {
        this(new BceClientConfiguration());
    }

    public BmrClient(BceClientConfiguration clientConfiguration) {
        super(clientConfiguration, BMR_HANDLERS);
    }

    public ListClustersResponse listClusters(ListClustersRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, CLUSTER);
        if (request.getMarker() != null) {
            internalRequest.addParameter("marker", request.getMarker());
        }
        if (request.getMaxKeys() >= 0) {
            internalRequest.addParameter("maxKeys", String.valueOf(request.getMaxKeys()));
        }
        return this.invokeHttpClient(internalRequest, ListClustersResponse.class);
    }

    public ListClustersResponse listClusters() {
        return this.listClusters(new ListClustersRequest());
    }

    public ListClustersResponse listClusters(int maxKeys) {
        return this.listClusters(new ListClustersRequest().withMaxKeys(maxKeys));
    }

    public ListClustersResponse listClusters(String marker, int maxKeys) {
        return this.listClusters(new ListClustersRequest().withMaxKeys(maxKeys).withMarker(marker));
    }

    public GetClusterResponse getCluster(GetClusterRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        Validate.checkStringNotEmpty(request.getClusterId(), "The parameter clusterId should not be null or empty string.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, CLUSTER, request.getClusterId());
        return this.invokeHttpClient(internalRequest, GetClusterResponse.class);
    }

    public GetClusterResponse getCluster(String clusterId) {
        return this.getCluster(new GetClusterRequest().withClusterId(clusterId));
    }

    public CreateClusterResponse createCluster(CreateClusterRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        Validate.checkStringNotEmpty(request.getImageType(), "The imageType should not be null or empty string.");
        Validate.checkStringNotEmpty(request.getImageVersion(), "The imageVersion should not be null or empty string.");
        Preconditions.checkNotNull(request.getInstanceGroups(), (Object)"The instanceGroups should not be null.");
        StringWriter writer = new StringWriter();
        try {
            JsonGenerator jsonGenerator = JsonUtils.jsonGeneratorOf(writer);
            jsonGenerator.writeStartObject();
            jsonGenerator.writeStringField("imageType", request.getImageType());
            jsonGenerator.writeStringField("imageVersion", request.getImageVersion());
            jsonGenerator.writeArrayFieldStart("instanceGroups");
            for (InstanceGroupConfig instanceGroup : request.getInstanceGroups()) {
                jsonGenerator.writeStartObject();
                if (instanceGroup.getName() != null) {
                    jsonGenerator.writeStringField("name", instanceGroup.getName());
                }
                jsonGenerator.writeStringField("type", instanceGroup.getType());
                jsonGenerator.writeStringField("instanceType", instanceGroup.getInstanceType());
                jsonGenerator.writeNumberField("instanceCount", instanceGroup.getInstanceCount());
                jsonGenerator.writeEndObject();
            }
            jsonGenerator.writeEndArray();
            if (request.getName() != null) {
                jsonGenerator.writeStringField("name", request.getName());
            }
            if (request.getLogUri() != null) {
                jsonGenerator.writeStringField("logUri", request.getLogUri());
            }
            jsonGenerator.writeBooleanField("autoTerminate", request.getAutoTerminate());
            if (request.getApplications() != null) {
                jsonGenerator.writeArrayFieldStart("applications");
                for (ApplicationConfig application : request.getApplications()) {
                    jsonGenerator.writeStartObject();
                    jsonGenerator.writeStringField("name", application.getName());
                    jsonGenerator.writeStringField("version", application.getVersion());
                    if (application.getProperties() != null) {
                        jsonGenerator.writeObjectFieldStart("properties");
                        for (Map.Entry<String, Object> entry : application.getProperties().entrySet()) {
                            jsonGenerator.writeObjectField(entry.getKey(), entry.getValue());
                        }
                        jsonGenerator.writeEndObject();
                    }
                    jsonGenerator.writeEndObject();
                }
                jsonGenerator.writeEndArray();
            }
            if (request.getSteps() != null) {
                jsonGenerator.writeArrayFieldStart("steps");
                for (StepConfig step : request.getSteps()) {
                    jsonGenerator.writeStartObject();
                    if (step.getName() != null) {
                        jsonGenerator.writeStringField("name", step.getName());
                    }
                    jsonGenerator.writeStringField("type", step.getType());
                    jsonGenerator.writeStringField("actionOnFailure", step.getActionOnFailure());
                    jsonGenerator.writeObjectFieldStart("properties");
                    for (Map.Entry<String, Object> entry : step.getProperties().entrySet()) {
                        jsonGenerator.writeStringField(entry.getKey(), (String)entry.getValue());
                    }
                    jsonGenerator.writeEndObject();
                    jsonGenerator.writeEndObject();
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            jsonGenerator.close();
        }
        catch (IOException e) {
            throw new BceClientException("Fail to generate json", e);
        }
        byte[] json = null;
        try {
            json = writer.toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new BceClientException("Fail to get UTF-8 bytes", e);
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, CLUSTER);
        internalRequest.addHeader("Content-Length", String.valueOf(json.length));
        internalRequest.addHeader("Content-Type", "application/json");
        internalRequest.setContent(RestartableInputStream.wrap(json));
        if (request.getClientToken() != null) {
            internalRequest.addParameter("clientToken", request.getClientToken());
        }
        return this.invokeHttpClient(internalRequest, CreateClusterResponse.class);
    }

    public void terminateCluster(TerminateClusterRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        Validate.checkStringNotEmpty(request.getClusterId(), "The parameter clusterId should not be null or empty string.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.DELETE, CLUSTER, request.getClusterId());
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void terminateCluster(String clusterId) {
        this.terminateCluster(new TerminateClusterRequest().withClusterId(clusterId));
    }

    public ListInstanceGroupsResponse listInstanceGroups(ListInstanceGroupsRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        Validate.checkStringNotEmpty(request.getClusterId(), "The parameter clusterId should not be null or empty string.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, CLUSTER, request.getClusterId(), INSTANCE_GROUP);
        return this.invokeHttpClient(internalRequest, ListInstanceGroupsResponse.class);
    }

    public ListInstanceGroupsResponse listInstanceGroups(String clusterId) {
        return this.listInstanceGroups(new ListInstanceGroupsRequest().withClusterId(clusterId));
    }

    public ListInstancesResponse listInstances(ListInstancesRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        Validate.checkStringNotEmpty(request.getClusterId(), "The parameter clusterId should not be null or empty string.");
        Validate.checkStringNotEmpty(request.getInstanceGroupId(), "The parameter instanceGroupId should not be null or empty string.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, CLUSTER, request.getClusterId(), INSTANCE_GROUP, request.getInstanceGroupId(), INSTANCE);
        return this.invokeHttpClient(internalRequest, ListInstancesResponse.class);
    }

    public ListInstancesResponse listInstances(String clusterId, String instanceGroupId) {
        return this.listInstances(new ListInstancesRequest().withClusterId(clusterId).withInstanceGroupId(instanceGroupId));
    }

    public AddStepsResponse addSteps(AddStepsRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        Preconditions.checkNotNull(request.getSteps(), (Object)"The parameter steps should not be null.");
        Validate.checkStringNotEmpty(request.getClusterId(), "The parameter clusterId should not be null or empty string.");
        StringWriter writer = new StringWriter();
        List<StepConfig> steps = request.getSteps();
        try {
            JsonGenerator jsonGenerator = JsonUtils.jsonGeneratorOf(writer);
            jsonGenerator.writeStartObject();
            jsonGenerator.writeArrayFieldStart("steps");
            for (StepConfig step : steps) {
                jsonGenerator.writeStartObject();
                if (step.getName() != null) {
                    jsonGenerator.writeStringField("name", step.getName());
                }
                jsonGenerator.writeStringField("type", step.getType());
                jsonGenerator.writeStringField("actionOnFailure", step.getActionOnFailure());
                jsonGenerator.writeObjectFieldStart("properties");
                for (String propertyKey : step.getProperties().keySet()) {
                    jsonGenerator.writeObjectField(propertyKey, (Object)step.getProperties().get(propertyKey));
                }
                jsonGenerator.writeEndObject();
                jsonGenerator.writeEndObject();
            }
            jsonGenerator.writeEndArray();
            jsonGenerator.writeEndObject();
            jsonGenerator.close();
        }
        catch (IOException e) {
            throw new BceClientException("Fail to generate json", e);
        }
        byte[] json = null;
        try {
            json = writer.toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new BceClientException("Fail to get UTF-8 bytes", e);
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, CLUSTER, request.getClusterId(), STEP);
        internalRequest.addHeader("Content-Length", String.valueOf(json.length));
        internalRequest.addHeader("Content-Type", "application/json");
        internalRequest.setContent(RestartableInputStream.wrap(json));
        if (request.getClientToken() != null) {
            internalRequest.addParameter("clientToken", request.getClientToken());
        }
        return this.invokeHttpClient(internalRequest, AddStepsResponse.class);
    }

    public ListStepsResponse listSteps(ListStepsRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        Validate.checkStringNotEmpty(request.getClusterId(), "The parameter clusterId should not be null or empty string.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, CLUSTER, request.getClusterId(), STEP);
        if (request.getMarker() != null) {
            internalRequest.addParameter("marker", request.getMarker());
        }
        if (request.getMaxKeys() >= 0) {
            internalRequest.addParameter("maxKeys", String.valueOf(request.getMaxKeys()));
        }
        return this.invokeHttpClient(internalRequest, ListStepsResponse.class);
    }

    public ListStepsResponse listSteps(String clusterId) {
        return this.listSteps(new ListStepsRequest().withClusterId(clusterId));
    }

    public ListStepsResponse listSteps(String clusterId, int maxKeys) {
        return this.listSteps(new ListStepsRequest().withClusterId(clusterId).withMaxKeys(maxKeys));
    }

    public ListStepsResponse listSteps(String clusterId, String marker, int maxKeys) {
        return this.listSteps(new ListStepsRequest().withClusterId(clusterId).withMaxKeys(maxKeys).withMarker(marker));
    }

    public GetStepResponse getStep(GetStepRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        Validate.checkStringNotEmpty(request.getClusterId(), "The parameter clusterId should not be null or empty string.");
        Validate.checkStringNotEmpty(request.getStepId(), "The parameter stepId should not be null or empty string.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, CLUSTER, request.getClusterId(), STEP, request.getStepId());
        return this.invokeHttpClient(internalRequest, GetStepResponse.class);
    }

    public GetStepResponse getStep(String clusterId, String stepId) {
        return this.getStep(new GetStepRequest().withClusterId(clusterId).withStepId(stepId));
    }

    private InternalRequest createRequest(AbstractBceRequest bceRequest, HttpMethodName httpMethod, String ... pathVariables) {
        ArrayList<String> path = new ArrayList<String>();
        path.add(VERSION);
        if (pathVariables != null) {
            for (String pathVariable : pathVariables) {
                path.add(pathVariable);
            }
        }
        URI uri = HttpUtils.appendUri(this.getEndpoint(), path.toArray(new String[path.size()]));
        InternalRequest request = new InternalRequest(httpMethod, uri);
        SignOptions signOptions = new SignOptions();
        signOptions.setHeadersToSign(new HashSet<String>(Arrays.asList(HEADERS_TO_SIGN)));
        request.setSignOptions(signOptions);
        request.setCredentials(bceRequest.getRequestCredentials());
        return request;
    }
}

