/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.bos.model;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Date;
import java.util.Map;

public class ObjectMetadata {
    private Map<String, String> userMetadata = Maps.newHashMap();
    private String bceContentSha256;
    private String contentDisposition;
    private String contentEncoding;
    private long contentLength = -1L;
    private String contentMd5;
    private String contentType;
    private String eTag;
    private long instanceLength = -1L;
    private Date lastModified;
    private String contentRange;

    public ObjectMetadata() {
    }

    public ObjectMetadata(ObjectMetadata other) {
        if (other.userMetadata != null) {
            this.userMetadata = Maps.newHashMap(other.userMetadata);
        }
        this.setBceContentSha256(other.getBceContentSha256());
        this.setContentDisposition(other.getContentDisposition());
        this.setContentEncoding(other.getContentEncoding());
        this.setContentLength(other.getContentLength());
        this.setContentMd5(other.getContentMd5());
        this.setContentType(other.getContentType());
        this.setETag(other.getETag());
        this.setInstanceLength(other.getInstanceLength());
        this.setLastModified(other.getLastModified());
    }

    public Map<String, String> getUserMetadata() {
        return this.userMetadata;
    }

    public void setUserMetadata(Map<String, String> userMetadata) {
        Preconditions.checkNotNull(userMetadata, (Object)"userMetadata should not be null.");
        this.userMetadata = userMetadata;
    }

    public void addUserMetadata(String key, String value) {
        this.userMetadata.put(key, value);
    }

    public String getUserMetaDataOf(String key) {
        return this.userMetadata == null ? null : this.userMetadata.get(key);
    }

    public void setContentRange(String contentRange) {
        this.contentRange = contentRange;
    }

    public String getContentRange() {
        return this.contentRange;
    }

    public String getBceContentSha256() {
        return this.bceContentSha256;
    }

    public void setBceContentSha256(String bceContentSha256) {
        this.bceContentSha256 = bceContentSha256;
    }

    public String getContentDisposition() {
        return this.contentDisposition;
    }

    public void setContentDisposition(String contentDisposition) {
        this.contentDisposition = contentDisposition;
    }

    public String getContentEncoding() {
        return this.contentEncoding;
    }

    public void setContentEncoding(String contentEncoding) {
        this.contentEncoding = contentEncoding;
    }

    public long getContentLength() {
        return this.contentLength;
    }

    public void setContentLength(long contentLength) {
        this.contentLength = contentLength;
    }

    public String getContentMd5() {
        return this.contentMd5;
    }

    public void setContentMd5(String contentMd5) {
        this.contentMd5 = contentMd5;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getETag() {
        return this.eTag;
    }

    public void setETag(String eTag) {
        this.eTag = eTag;
    }

    public long getInstanceLength() {
        return this.instanceLength;
    }

    public void setInstanceLength(long instanceLength) {
        this.instanceLength = instanceLength;
    }

    public Date getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(Date lastModified) {
        this.lastModified = lastModified;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("ObjectMetadata [");
        builder.append("userMetadata=").append(this.userMetadata);
        if (this.bceContentSha256 != null) {
            builder.append(", bceContentSha256=").append(this.bceContentSha256);
        }
        if (this.contentDisposition != null) {
            builder.append(", contentDisposition=").append(this.contentDisposition);
        }
        if (this.contentEncoding != null) {
            builder.append(", contentEncoding=").append(this.contentEncoding);
        }
        if (this.contentLength >= 0L) {
            builder.append(", contentLength=").append(this.contentLength);
        }
        if (this.contentMd5 != null) {
            builder.append(", contentMd5=").append(this.contentMd5);
        }
        if (this.contentType != null) {
            builder.append(", contentType=").append(this.contentType);
        }
        if (this.eTag != null) {
            builder.append(", eTag=").append(this.eTag);
        }
        if (this.instanceLength >= 0L) {
            builder.append(", instanceLength=").append(this.instanceLength);
        }
        if (this.lastModified != null) {
            builder.append(", lastModified=").append(this.lastModified);
        }
        builder.append(']');
        return builder.toString();
    }
}

