/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.lss;

import com.baidubce.AbstractBceClient;
import com.baidubce.BceClientConfiguration;
import com.baidubce.BceClientException;
import com.baidubce.http.HttpMethodName;
import com.baidubce.http.handler.BceErrorResponseHandler;
import com.baidubce.http.handler.BceJsonResponseHandler;
import com.baidubce.http.handler.BceMetadataResponseHandler;
import com.baidubce.http.handler.HttpResponseHandler;
import com.baidubce.internal.InternalRequest;
import com.baidubce.internal.RestartableInputStream;
import com.baidubce.model.AbstractBceRequest;
import com.baidubce.services.lss.model.AntiLeech;
import com.baidubce.services.lss.model.Audio;
import com.baidubce.services.lss.model.Auth;
import com.baidubce.services.lss.model.CreateNotificationRequest;
import com.baidubce.services.lss.model.CreateNotificationResponse;
import com.baidubce.services.lss.model.CreatePresetRequest;
import com.baidubce.services.lss.model.CreatePresetResponse;
import com.baidubce.services.lss.model.CreateSessionRequest;
import com.baidubce.services.lss.model.CreateSessionResponse;
import com.baidubce.services.lss.model.DeleteNotificationRequest;
import com.baidubce.services.lss.model.DeleteNotificationResponse;
import com.baidubce.services.lss.model.DeletePresetRequest;
import com.baidubce.services.lss.model.DeletePresetResponse;
import com.baidubce.services.lss.model.DeleteSessionRequest;
import com.baidubce.services.lss.model.DeleteSessionResponse;
import com.baidubce.services.lss.model.Encryption;
import com.baidubce.services.lss.model.GetNotificationRequest;
import com.baidubce.services.lss.model.GetNotificationResponse;
import com.baidubce.services.lss.model.GetPresetRequest;
import com.baidubce.services.lss.model.GetPresetResponse;
import com.baidubce.services.lss.model.GetSecurityPolicyRequest;
import com.baidubce.services.lss.model.GetSecurityPolicyResponse;
import com.baidubce.services.lss.model.GetSessionRequest;
import com.baidubce.services.lss.model.GetSessionResponse;
import com.baidubce.services.lss.model.Hls;
import com.baidubce.services.lss.model.ListNotificationsRequest;
import com.baidubce.services.lss.model.ListNotificationsResponse;
import com.baidubce.services.lss.model.ListPresetsRequest;
import com.baidubce.services.lss.model.ListPresetsResponse;
import com.baidubce.services.lss.model.ListSecurityPoliciesRequest;
import com.baidubce.services.lss.model.ListSecurityPoliciesResponse;
import com.baidubce.services.lss.model.ListSessionsRequest;
import com.baidubce.services.lss.model.ListSessionsResponse;
import com.baidubce.services.lss.model.LivePublishInfo;
import com.baidubce.services.lss.model.LiveThumbnail;
import com.baidubce.services.lss.model.PauseSessionRequest;
import com.baidubce.services.lss.model.PauseSessionResponse;
import com.baidubce.services.lss.model.RefreshSessionRequest;
import com.baidubce.services.lss.model.RefreshSessionResponse;
import com.baidubce.services.lss.model.ResumeSessionRequest;
import com.baidubce.services.lss.model.ResumeSessionResponse;
import com.baidubce.services.lss.model.Rtmp;
import com.baidubce.services.lss.model.StartPullSessionRequest;
import com.baidubce.services.lss.model.StartPullSessionResponse;
import com.baidubce.services.lss.model.UpdateSecurityPolicyInnerRequest;
import com.baidubce.services.lss.model.UpdateSecurityPolicyRequest;
import com.baidubce.services.lss.model.UpdateSecurityPolicyResponse;
import com.baidubce.services.lss.model.Video;
import com.baidubce.services.lss.model.Watermarks;
import com.baidubce.util.HttpUtils;
import com.baidubce.util.JsonUtils;
import com.baidubce.util.Validate;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.ArrayList;

public class LssClient
extends AbstractBceClient {
    private static final String VERSION = "v5";
    private static final String LIVE_PRESET = "preset";
    private static final String LIVE_SESSION = "session";
    private static final String LIVE_NOTIFICATION = "notification";
    private static final String LIVE_SECURITY_POLICY = "securitypolicy";
    private static final String STATUS = "status";
    private static final String PAUSE = "pause";
    private static final String RESUME = "resume";
    private static final String REFRESH = "refresh";
    private static final String PULL = "pull";
    private static HttpResponseHandler[] lssHandlers = new HttpResponseHandler[]{new BceMetadataResponseHandler(), new BceErrorResponseHandler(), new BceJsonResponseHandler()};

    public LssClient() {
        this(new BceClientConfiguration());
    }

    public LssClient(BceClientConfiguration clientConfiguration) {
        super(clientConfiguration, lssHandlers);
    }

    public CreatePresetResponse createPreset(CreatePresetRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        Validate.checkStringNotEmpty(request.getName(), "The parameter name should NOT be null or empty string.");
        if (request.getAudio() != null) {
            Validate.checkNotNull(request.getAudio().getBitRateInBps(), "The parameter bitRateInBps in audio should NOT be null.");
            Validate.checkIsTrue(request.getAudio().getBitRateInBps() > 0, "The audio's parameter bitRateInBps should be greater than zero.");
        }
        if (request.getVideo() != null) {
            Validate.checkNotNull(request.getVideo().getBitRateInBps(), "The parameter bitRateInBps in video should NOT be null.");
            Validate.checkIsTrue(request.getVideo().getBitRateInBps() > 0, "The video's parameter bitRateInBps should be greater than zero.");
            Validate.checkNotNull(request.getVideo().getMaxFrameRate(), "The parameter maxFrameRate in video should NOT be null.");
            Validate.checkIsTrue(request.getVideo().getMaxFrameRate().floatValue() > 0.0f, "The video's parameter maxFrameRate should be greater than zero.");
            Validate.checkNotNull(request.getVideo().getMaxWidthInPixel(), "The parameter maxWidthInPixel in video should NOT be null.");
            Validate.checkIsTrue(request.getVideo().getMaxWidthInPixel() > 0, "The video's parameter maxWidthInPixel should be greater than zero.");
            Validate.checkNotNull(request.getVideo().getMaxHeightInPixel(), "The parameter maxHeightInPixel in video should NOT be null.");
            Validate.checkIsTrue(request.getVideo().getMaxHeightInPixel() > 0, "The video's parameter maxHeightInPixel should be greater than zero.");
        }
        request.setThumbnail(null);
        request.setWatermarks(null);
        InternalRequest internalRequest = this.createRequest(HttpMethodName.POST, request, LIVE_PRESET);
        return this.invokeHttpClient(internalRequest, CreatePresetResponse.class);
    }

    public CreatePresetResponse createPreset(String name, String description, Audio audio, Video video, Hls hls, Rtmp rtmp, LiveThumbnail thumbnail, Watermarks watermarks) {
        CreatePresetRequest request = new CreatePresetRequest();
        request.setForwardOnly(false);
        request.setName(name);
        request.setDescription(description);
        request.setAudio(audio);
        request.setVideo(video);
        request.setHls(hls);
        request.setRtmp(rtmp);
        request.setThumbnail(thumbnail);
        request.setWatermarks(watermarks);
        return this.createPreset(request);
    }

    public CreatePresetResponse createForwardOnlyPreset(String name, String description, Hls hls, Rtmp rtmp, LiveThumbnail thumbnail, Watermarks watermarks) {
        CreatePresetRequest request = new CreatePresetRequest();
        request.setForwardOnly(true);
        request.setName(name);
        request.setDescription(description);
        request.setHls(hls);
        request.setRtmp(rtmp);
        request.setThumbnail(thumbnail);
        request.setWatermarks(watermarks);
        return this.createPreset(request);
    }

    public ListPresetsResponse listPresets() {
        ListPresetsRequest request = new ListPresetsRequest();
        InternalRequest internalRequest = this.createRequest(HttpMethodName.GET, request, LIVE_PRESET);
        return this.invokeHttpClient(internalRequest, ListPresetsResponse.class);
    }

    public GetPresetResponse getPreset(String name) {
        GetPresetRequest request = new GetPresetRequest();
        request.setName(name);
        return this.getPreset(request);
    }

    public GetPresetResponse getPreset(GetPresetRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        Validate.checkStringNotEmpty(request.getName(), "The parameter name should NOT be null or empty string.");
        InternalRequest internalRequest = this.createRequest(HttpMethodName.GET, request, LIVE_PRESET, request.getName());
        return this.invokeHttpClient(internalRequest, GetPresetResponse.class);
    }

    public DeletePresetResponse deletePreset(String name) {
        DeletePresetRequest request = new DeletePresetRequest();
        request.setName(name);
        return this.deletePreset(request);
    }

    public DeletePresetResponse deletePreset(DeletePresetRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        Validate.checkStringNotEmpty(request.getName(), "The parameter name should NOT be null or empty string.");
        InternalRequest internalRequest = this.createRequest(HttpMethodName.DELETE, request, LIVE_PRESET, request.getName());
        return this.invokeHttpClient(internalRequest, DeletePresetResponse.class);
    }

    public CreateSessionResponse createSession(String description, String preset, String notification, String securityPolicy, LivePublishInfo publish) {
        CreateSessionRequest request = new CreateSessionRequest();
        request.withPreset(preset).withDescription(description).withNotification(notification);
        request.withSecurityPolicy(securityPolicy).withPublish(publish);
        return this.createSession(request);
    }

    public CreateSessionResponse createSession(CreateSessionRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        Validate.checkStringNotEmpty(request.getPreset(), "The parameter preset should NOT be null or empty string.");
        InternalRequest internalRequest = this.createRequest(HttpMethodName.POST, request, LIVE_SESSION);
        return this.invokeHttpClient(internalRequest, CreateSessionResponse.class);
    }

    public ListSessionsResponse listSessions() {
        ListSessionsRequest request = new ListSessionsRequest();
        return this.listSessions(request);
    }

    public ListSessionsResponse listSessions(String status) {
        ListSessionsRequest request = new ListSessionsRequest().withStatus(status);
        return this.listSessions(request);
    }

    public ListSessionsResponse listSessions(ListSessionsRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        InternalRequest internalRequest = this.createRequest(HttpMethodName.GET, request, LIVE_SESSION);
        if (request.getStatus() != null) {
            Validate.checkStringNotEmpty(request.getStatus(), "The parameter status should NOT be empty string.");
            internalRequest.addParameter(STATUS, request.getStatus());
        }
        return this.invokeHttpClient(internalRequest, ListSessionsResponse.class);
    }

    public GetSessionResponse getSession(String sessionId) {
        GetSessionRequest request = new GetSessionRequest();
        request.setSessionId(sessionId);
        return this.getSession(request);
    }

    public GetSessionResponse getSession(GetSessionRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        Validate.checkStringNotEmpty(request.getSessionId(), "The parameter sessionId should NOT be null or empty string.");
        InternalRequest internalRequest = this.createRequest(HttpMethodName.GET, request, LIVE_SESSION, request.getSessionId());
        return this.invokeHttpClient(internalRequest, GetSessionResponse.class);
    }

    public DeleteSessionResponse deleteSession(String sessionId) {
        DeleteSessionRequest request = new DeleteSessionRequest();
        request.setSessionId(sessionId);
        return this.deleteSession(request);
    }

    public DeleteSessionResponse deleteSession(DeleteSessionRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        Validate.checkStringNotEmpty(request.getSessionId(), "The parameter sessionId should NOT be null or empty string.");
        InternalRequest internalRequest = this.createRequest(HttpMethodName.DELETE, request, LIVE_SESSION, request.getSessionId());
        return this.invokeHttpClient(internalRequest, DeleteSessionResponse.class);
    }

    public PauseSessionResponse pauseSession(String sessionId) {
        PauseSessionRequest request = new PauseSessionRequest();
        request.setSessionId(sessionId);
        return this.pauseSession(request);
    }

    public PauseSessionResponse pauseSession(PauseSessionRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        Validate.checkStringNotEmpty(request.getSessionId(), "The parameter sessionId should NOT be null or empty string.");
        InternalRequest internalRequest = this.createRequest(HttpMethodName.PUT, request, LIVE_SESSION, request.getSessionId());
        internalRequest.addParameter(PAUSE, null);
        return this.invokeHttpClient(internalRequest, PauseSessionResponse.class);
    }

    public ResumeSessionResponse resumeSession(String sessionId) {
        ResumeSessionRequest request = new ResumeSessionRequest();
        request.setSessionId(sessionId);
        return this.resumeSession(request);
    }

    public ResumeSessionResponse resumeSession(ResumeSessionRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        Validate.checkStringNotEmpty(request.getSessionId(), "The parameter sessionId should NOT be null or empty string.");
        InternalRequest internalRequest = this.createRequest(HttpMethodName.PUT, request, LIVE_SESSION, request.getSessionId());
        internalRequest.addParameter(RESUME, null);
        return this.invokeHttpClient(internalRequest, ResumeSessionResponse.class);
    }

    public RefreshSessionResponse refreshSession(String sessionId) {
        RefreshSessionRequest request = new RefreshSessionRequest();
        request.setSessionId(sessionId);
        return this.refreshSession(request);
    }

    public RefreshSessionResponse refreshSession(RefreshSessionRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        Validate.checkStringNotEmpty(request.getSessionId(), "The parameter sessionId should NOT be null or empty string.");
        InternalRequest internalRequest = this.createRequest(HttpMethodName.PUT, request, LIVE_SESSION, request.getSessionId());
        internalRequest.addParameter(REFRESH, null);
        return this.invokeHttpClient(internalRequest, RefreshSessionResponse.class);
    }

    public StartPullSessionResponse startPullSession(String sessionId) {
        StartPullSessionRequest request = new StartPullSessionRequest().withSessionId(sessionId);
        return this.startPullSession(request);
    }

    public StartPullSessionResponse startPullSession(StartPullSessionRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        Validate.checkStringNotEmpty(request.getSessionId(), "The parameter sessionId should NOT be null or empty string.");
        InternalRequest internalRequest = this.createRequest(HttpMethodName.PUT, request, LIVE_SESSION, request.getSessionId());
        internalRequest.addParameter(PULL, null);
        return this.invokeHttpClient(internalRequest, StartPullSessionResponse.class);
    }

    public ListNotificationsResponse listNotifications() {
        ListNotificationsRequest request = new ListNotificationsRequest();
        InternalRequest internalRequest = this.createRequest(HttpMethodName.GET, request, LIVE_NOTIFICATION);
        return this.invokeHttpClient(internalRequest, ListNotificationsResponse.class);
    }

    public DeleteNotificationResponse deleteNotification(String name) {
        DeleteNotificationRequest request = new DeleteNotificationRequest();
        request.setName(name);
        return this.deleteNotification(request);
    }

    public DeleteNotificationResponse deleteNotification(DeleteNotificationRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        Validate.checkStringNotEmpty(request.getName(), "The parameter name should NOT be null or empty string.");
        InternalRequest internalRequest = this.createRequest(HttpMethodName.DELETE, request, LIVE_NOTIFICATION, request.getName());
        return this.invokeHttpClient(internalRequest, DeleteNotificationResponse.class);
    }

    public GetNotificationResponse getNotification(String name) {
        GetNotificationRequest request = new GetNotificationRequest();
        request.setName(name);
        return this.getNotification(request);
    }

    public GetNotificationResponse getNotification(GetNotificationRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        Validate.checkStringNotEmpty(request.getName(), "The parameter name should NOT be null or empty string.");
        InternalRequest internalRequest = this.createRequest(HttpMethodName.GET, request, LIVE_NOTIFICATION, request.getName());
        return this.invokeHttpClient(internalRequest, GetNotificationResponse.class);
    }

    public CreateNotificationResponse createNotification(String name, String endpoint) {
        CreateNotificationRequest request = new CreateNotificationRequest();
        request.withName(name).withEndpoint(endpoint);
        return this.createNotification(request);
    }

    public CreateNotificationResponse createNotification(CreateNotificationRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        Validate.checkStringNotEmpty(request.getName(), "The parameter name should NOT be null or empty string.");
        Validate.checkStringNotEmpty(request.getEndpoint(), "The parameter endpoint should NOT be null or empty string.");
        InternalRequest internalRequest = this.createRequest(HttpMethodName.POST, request, LIVE_NOTIFICATION);
        return this.invokeHttpClient(internalRequest, CreateNotificationResponse.class);
    }

    public ListSecurityPoliciesResponse listSecurityPolicies() {
        ListSecurityPoliciesRequest request = new ListSecurityPoliciesRequest();
        InternalRequest internalRequest = this.createRequest(HttpMethodName.GET, request, LIVE_SECURITY_POLICY);
        return this.invokeHttpClient(internalRequest, ListSecurityPoliciesResponse.class);
    }

    public GetSecurityPolicyResponse getSecurityPolicy(String name) {
        GetSecurityPolicyRequest request = new GetSecurityPolicyRequest();
        request.setName(name);
        return this.getSecurityPolicy(request);
    }

    public GetSecurityPolicyResponse getSecurityPolicy(GetSecurityPolicyRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        Validate.checkStringNotEmpty(request.getName(), "The parameter name should NOT be null or empty string.");
        InternalRequest internalRequest = this.createRequest(HttpMethodName.GET, request, LIVE_SECURITY_POLICY, request.getName());
        return this.invokeHttpClient(internalRequest, GetSecurityPolicyResponse.class);
    }

    public UpdateSecurityPolicyResponse updateSecurityPolicy(String name, Auth auth, AntiLeech antiLeech, Encryption encryption) {
        UpdateSecurityPolicyRequest request = new UpdateSecurityPolicyRequest();
        request.withName(name).withAuth(auth).withAntiLeech(antiLeech).withEncryption(encryption);
        return this.updateSecurityPolicy(request);
    }

    public UpdateSecurityPolicyResponse updateSecurityPolicy(UpdateSecurityPolicyRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        Validate.checkStringNotEmpty(request.getName(), "The parameter name should NOT be null or empty string.");
        UpdateSecurityPolicyInnerRequest innerRequest = new UpdateSecurityPolicyInnerRequest();
        innerRequest.withAuth(request.getAuth()).withAntiLeech(request.getAntiLeech()).withEncryption(request.getEncryption());
        InternalRequest internalRequest = this.createRequest(HttpMethodName.PUT, innerRequest, LIVE_SECURITY_POLICY, request.getName());
        return this.invokeHttpClient(internalRequest, UpdateSecurityPolicyResponse.class);
    }

    private InternalRequest createRequest(HttpMethodName httpMethod, AbstractBceRequest request, String ... pathVariables) {
        ArrayList<String> pathComponents = new ArrayList<String>();
        pathComponents.add(VERSION);
        if (pathVariables != null) {
            for (String pathVariable : pathVariables) {
                pathComponents.add(pathVariable);
            }
        }
        URI uri = HttpUtils.appendUri(this.getEndpoint(), pathComponents.toArray(new String[pathComponents.size()]));
        InternalRequest internalRequest = new InternalRequest(httpMethod, uri);
        internalRequest.setCredentials(request.getRequestCredentials());
        if (httpMethod == HttpMethodName.POST || httpMethod == HttpMethodName.PUT) {
            this.fillRequestPayload(internalRequest, request);
        }
        return internalRequest;
    }

    private InternalRequest fillRequestPayload(InternalRequest internalRequest, AbstractBceRequest request) {
        String strJson = JsonUtils.toJsonString(request);
        byte[] requestJson = null;
        try {
            requestJson = strJson.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new BceClientException("Unsupported encode.", e);
        }
        internalRequest.addHeader("Content-Length", String.valueOf(requestJson.length));
        internalRequest.addHeader("Content-Type", "application/json; charset=utf-8");
        internalRequest.setContent(RestartableInputStream.wrap(requestJson));
        return internalRequest;
    }
}

