/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.moladb.example;

import com.baidubce.BceClientException;
import com.baidubce.BceServiceException;
import com.baidubce.auth.DefaultBceCredentials;
import com.baidubce.services.moladb.MolaDbClient;
import com.baidubce.services.moladb.MolaDbClientConfiguration;
import com.baidubce.services.moladb.model.AttributeDefinition;
import com.baidubce.services.moladb.model.AttributeValue;
import com.baidubce.services.moladb.model.AttributeValueUpdate;
import com.baidubce.services.moladb.model.BatchGetItemRequest;
import com.baidubce.services.moladb.model.BatchGetItemResponse;
import com.baidubce.services.moladb.model.BatchWriteItemRequest;
import com.baidubce.services.moladb.model.BatchWriteItemResponse;
import com.baidubce.services.moladb.model.CreateInstanceRequest;
import com.baidubce.services.moladb.model.CreateTableRequest;
import com.baidubce.services.moladb.model.CreateTableResponse;
import com.baidubce.services.moladb.model.DeleteInstanceRequest;
import com.baidubce.services.moladb.model.DeleteItemRequest;
import com.baidubce.services.moladb.model.DeleteItemResponse;
import com.baidubce.services.moladb.model.DeleteRequest;
import com.baidubce.services.moladb.model.DeleteTableRequest;
import com.baidubce.services.moladb.model.GetInstanceRequest;
import com.baidubce.services.moladb.model.GetInstanceResponse;
import com.baidubce.services.moladb.model.GetItemRequest;
import com.baidubce.services.moladb.model.GetItemResponse;
import com.baidubce.services.moladb.model.GetTableRequest;
import com.baidubce.services.moladb.model.GetTableResponse;
import com.baidubce.services.moladb.model.Key;
import com.baidubce.services.moladb.model.KeySchemaElement;
import com.baidubce.services.moladb.model.KeysAndAttributes;
import com.baidubce.services.moladb.model.ListInstancesResponse;
import com.baidubce.services.moladb.model.ListTablesRequest;
import com.baidubce.services.moladb.model.ListTablesResponse;
import com.baidubce.services.moladb.model.ProvisionedThroughput;
import com.baidubce.services.moladb.model.PutItemRequest;
import com.baidubce.services.moladb.model.PutItemResponse;
import com.baidubce.services.moladb.model.PutRequest;
import com.baidubce.services.moladb.model.QueryRequest;
import com.baidubce.services.moladb.model.QueryResponse;
import com.baidubce.services.moladb.model.UpdateItemRequest;
import com.baidubce.services.moladb.model.UpdateItemResponse;
import com.baidubce.services.moladb.model.UpdateTableRequest;
import com.baidubce.services.moladb.model.UpdateTableResponse;
import com.baidubce.services.moladb.model.WriteRequest;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class MolaDbExample {
    private static final String ENDPOINT = "http://moladb.bj.baidubce.com";
    private static final String ACCESS_KEY_ID = "Your access key";
    private static final String SECRET_ACCESS_KEY = "Your secret access key";
    private static final String TABLE1 = "blogData";
    private static final String TABLE2 = "userData";
    private static final String KEYATTR1 = "subject";
    private static final String KEYATTR2 = "date";
    private MolaDbClient molaDbClient;

    public MolaDbExample(MolaDbClient client) {
        this.molaDbClient = client;
    }

    private void createTable() {
        try {
            String tableName = TABLE1;
            ProvisionedThroughput prov = new ProvisionedThroughput();
            prov.withReadCapacityUnits(100L).withWriteCapacityUnits(200L);
            ArrayList<AttributeDefinition> attributeDefs = new ArrayList<AttributeDefinition>();
            attributeDefs.add(new AttributeDefinition().withAttributeName(KEYATTR1).withAttributeType("S"));
            attributeDefs.add(new AttributeDefinition().withAttributeName(KEYATTR2).withAttributeType("S"));
            CreateTableRequest req = new CreateTableRequest(tableName).withAttributeDefinitions(attributeDefs);
            req.withProvisionedThroughput(prov);
            ArrayList<KeySchemaElement> keySchema = new ArrayList<KeySchemaElement>();
            keySchema.add(new KeySchemaElement().withAttributeName(KEYATTR1).withKeyType("Hash"));
            keySchema.add(new KeySchemaElement().withAttributeName(KEYATTR2).withKeyType("Range"));
            req.withKeySchema(keySchema);
            CreateTableResponse result = null;
            result = this.molaDbClient.createTable(req);
            System.out.println("result:" + result.toString());
            tableName = TABLE2;
            attributeDefs = new ArrayList();
            attributeDefs.add(new AttributeDefinition().withAttributeName("city").withAttributeType("S"));
            attributeDefs.add(new AttributeDefinition().withAttributeName("autherName").withAttributeType("S"));
            req = new CreateTableRequest(tableName).withAttributeDefinitions(attributeDefs);
            req.withProvisionedThroughput(prov);
            keySchema = new ArrayList();
            keySchema.add(new KeySchemaElement().withAttributeName("city").withKeyType("Hash"));
            keySchema.add(new KeySchemaElement().withAttributeName("autherName").withKeyType("Range"));
            req.withKeySchema(keySchema);
            result = null;
            result = this.molaDbClient.createTable(req);
            System.out.println("result:" + result.toString());
        }
        catch (BceServiceException ase) {
            System.out.println("Caught an moladb, which means your request made it to moladb, but was rejected with an error responseContent for some reason.");
            System.out.println("Error Message:    " + ase.getMessage());
            System.out.println("HTTP ErrorDescription Code: " + ase.getStatusCode());
            System.out.println("Moladb Error Code:   " + ase.getErrorCode());
            System.out.println("Error Type:       " + (Object)((Object)ase.getErrorType()));
            System.out.println("Request ID:       " + ase.getRequestId());
            ase.printStackTrace();
        }
        catch (BceClientException ace) {
            System.out.println("Caught an MoladbClientException, which means the client encountered a serious internal problem while trying to communicate with Moladb, such as not being able to access the network.");
            System.out.println("Error Message: " + ace.getMessage());
            ace.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void updateTable() {
        try {
            String tableName = TABLE1;
            UpdateTableRequest req = new UpdateTableRequest(tableName);
            ProvisionedThroughput prov = new ProvisionedThroughput();
            long read = 100L;
            long write = 200L;
            for (int index = 0; index < 6; ++index) {
                prov.withReadCapacityUnits(read *= 2L).withWriteCapacityUnits(write *= 2L);
                req.withProvisionedThroughput(prov);
                UpdateTableResponse result = this.molaDbClient.updateTable(req);
                System.out.println("result:" + result.toString());
            }
        }
        catch (BceServiceException ase) {
            System.out.println("Caught an moladb, which means your request made it to moladb, but was rejected with an error responseContent for some reason.");
            System.out.println("Error Message:    " + ase.getMessage());
            System.out.println("HTTP ErrorDescription Code: " + ase.getStatusCode());
            System.out.println("Moladb Error Code:   " + ase.getErrorCode());
            System.out.println("Error Type:       " + (Object)((Object)ase.getErrorType()));
            System.out.println("Request ID:       " + ase.getRequestId());
            ase.printStackTrace();
        }
        catch (BceClientException ace) {
            System.out.println("Caught an MoladbClientException, which means the client encountered a serious internal problem while trying to communicate with Moladb, such as not being able to access the network.");
            System.out.println("Error Message: " + ace.getMessage());
            ace.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void deleteTable() {
        try {
            DeleteTableRequest req1 = new DeleteTableRequest(TABLE1);
            DeleteTableRequest req2 = new DeleteTableRequest(TABLE2);
            this.molaDbClient.deleteTable(req1);
            this.molaDbClient.deleteTable(req2);
        }
        catch (BceServiceException ase) {
            System.out.println("Caught an moladb, which means your request made it to moladb, but was rejected with an error responseContent for some reason.");
            System.out.println("Error Message:    " + ase.getMessage());
            System.out.println("HTTP ErrorDescription Code: " + ase.getStatusCode());
            System.out.println("Moladb Error Code:   " + ase.getErrorCode());
            System.out.println("Error Type:       " + (Object)((Object)ase.getErrorType()));
            System.out.println("Request ID:       " + ase.getRequestId());
            ase.printStackTrace();
        }
        catch (BceClientException ace) {
            System.out.println("Caught an MoladbClientException, which means the client encountered a serious internal problem while trying to communicate with Moladb, such as not being able to access the network.");
            System.out.println("Error Message: " + ace.getMessage());
            ace.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void listTables() {
        try {
            ListTablesRequest req = new ListTablesRequest();
            ListTablesResponse result = this.molaDbClient.listTables(req);
            List<String> tables = result.getTableNames();
            for (int i = 0; i < tables.size(); ++i) {
                System.out.println("tables:" + tables.get(i));
            }
            System.out.println("all tables:" + tables.toString());
            System.out.println("result:" + result.toString());
        }
        catch (BceServiceException ase) {
            System.out.println("Caught an moladb, which means your request made it to moladb, but was rejected with an error responseContent for some reason.");
            System.out.println("Error Message:    " + ase.getMessage());
            System.out.println("HTTP ErrorDescription Code: " + ase.getStatusCode());
            System.out.println("Moladb Error Code:   " + ase.getErrorCode());
            System.out.println("Error Type:       " + (Object)((Object)ase.getErrorType()));
            System.out.println("Request ID:       " + ase.getRequestId());
            ase.printStackTrace();
        }
        catch (BceClientException ace) {
            System.out.println("Caught an MoladbClientException, which means the client encountered a serious internal problem while trying to communicate with Moladb, such as not being able to access the network.");
            System.out.println("Error Message: " + ace.getMessage());
            ace.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void getTable() {
        try {
            GetTableRequest req = new GetTableRequest(TABLE1);
            GetTableResponse result = this.molaDbClient.getTable(req);
            System.out.println("result:" + result.toString());
        }
        catch (BceServiceException ase) {
            System.out.println("Caught an moladb, which means your request made it to moladb, but was rejected with an error responseContent for some reason.");
            System.out.println("Error Message:    " + ase.getMessage());
            System.out.println("HTTP ErrorDescription Code: " + ase.getStatusCode());
            System.out.println("Moladb Error Code:   " + ase.getErrorCode());
            System.out.println("Error Type:       " + (Object)((Object)ase.getErrorType()));
            System.out.println("Request ID:       " + ase.getRequestId());
            ase.printStackTrace();
        }
        catch (BceClientException ace) {
            System.out.println("Caught an MoladbClientException, which means the client encountered a serious internal problem while trying to communicate with Moladb, such as not being able to access the network.");
            System.out.println("Error Message: " + ace.getMessage());
            ace.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void putItem() {
        try {
            String tableName = TABLE1;
            HashMap<String, AttributeValue> item = new HashMap<String, AttributeValue>();
            item.put(KEYATTR1, new AttributeValue().withS("how to use moladb?"));
            item.put(KEYATTR2, new AttributeValue().withS("2015/01/02"));
            item.put("body", new AttributeValue().withB("so easy".getBytes()));
            PutItemRequest putItemRequest = new PutItemRequest(tableName).withItem(item);
            PutItemResponse result = this.molaDbClient.putItem(putItemRequest);
            System.out.println("result:" + result.toString());
            HashMap<String, AttributeValue> item3 = new HashMap<String, AttributeValue>();
            item3.put(KEYATTR1, new AttributeValue("how to use moladb?"));
            item3.put(KEYATTR2, new AttributeValue("2015/01/02"));
            item3.put("desc", new AttributeValue().withS("it is an artical about how to use moladb in bce"));
            PutItemRequest req3 = new PutItemRequest(tableName);
            req3.withItem(item3);
            PutItemResponse result3 = this.molaDbClient.putItem(req3);
            System.out.println("result3:" + result3.toString());
        }
        catch (BceServiceException ase) {
            System.out.println("Caught an moladb, which means your request made it to moladb, but was rejected with an error responseContent for some reason.");
            System.out.println("Error Message:    " + ase.getMessage());
            System.out.println("HTTP ErrorDescription Code: " + ase.getStatusCode());
            System.out.println("Moladb Error Code:   " + ase.getErrorCode());
            System.out.println("Error Type:       " + (Object)((Object)ase.getErrorType()));
            System.out.println("Request ID:       " + ase.getRequestId());
            ase.printStackTrace();
        }
        catch (BceClientException ace) {
            System.out.println("Caught an MoladbClientException, which means the client encountered a serious internal problem while trying to communicate with Moladb, such as not being able to access the network.");
            System.out.println("Error Message: " + ace.getMessage());
            ace.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void getItem() {
        try {
            System.out.println("=====================Start.=======================");
            String tableName = TABLE1;
            Key keyToGet = new Key();
            keyToGet.withAttribute(KEYATTR1, new AttributeValue().withS("how to use moladb?"));
            keyToGet.withAttribute(KEYATTR2, new AttributeValue().withS("2015/01/02"));
            ArrayList<String> attributesToGet = new ArrayList<String>();
            attributesToGet.add("desc");
            attributesToGet.add("body");
            GetItemRequest request = new GetItemRequest(tableName);
            request.withKey(keyToGet).withConsistentRead(false);
            request.withAttributesToGet(attributesToGet);
            GetItemResponse result = this.molaDbClient.getItem(request);
            System.out.println("result:" + result.toString());
            System.out.println("=====================End.=======================");
        }
        catch (BceServiceException ase) {
            System.out.println("Caught an moladb, which means your request made it to moladb, but was rejected with an error responseContent for some reason.");
            System.out.println("Error Message:    " + ase.getMessage());
            System.out.println("HTTP ErrorDescription Code: " + ase.getStatusCode());
            System.out.println("Moladb Error Code:   " + ase.getErrorCode());
            System.out.println("Error Type:       " + (Object)((Object)ase.getErrorType()));
            System.out.println("Request ID:       " + ase.getRequestId());
            ase.printStackTrace();
        }
        catch (BceClientException ace) {
            System.out.println("Caught an MoladbClientException, which means the client encountered a serious internal problem while trying to communicate with Moladb, such as not being able to access the network.");
            System.out.println("Error Message: " + ace.getMessage());
            ace.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void updateItem() {
        try {
            System.out.println("=====================Start.=======================");
            String tableName = TABLE1;
            HashMap<String, AttributeValueUpdate> updateItems = new HashMap<String, AttributeValueUpdate>();
            Key keyToUpdate = new Key();
            keyToUpdate.withAttribute(KEYATTR1, new AttributeValue().withS("how to use moladb?"));
            keyToUpdate.withAttribute(KEYATTR2, new AttributeValue().withS("2015/01/02"));
            updateItems.put("tags", new AttributeValueUpdate().withAction("Put").withValue(new AttributeValue().withS("c++ java php")));
            updateItems.put("desc", new AttributeValueUpdate().withAction("Delete"));
            UpdateItemRequest updateItemRequest = new UpdateItemRequest().withTableName(tableName).withKey(keyToUpdate).withAttributeUpdates(updateItems);
            UpdateItemResponse result = this.molaDbClient.updateItem(updateItemRequest);
            System.out.println("result:" + result.toString());
            System.out.println("=====================End.=======================");
        }
        catch (BceServiceException ase) {
            System.out.println("Caught an moladb, which means your request made it to moladb, but was rejected with an error responseContent for some reason.");
            System.out.println("Error Message:    " + ase.getMessage());
            System.out.println("HTTP ErrorDescription Code: " + ase.getStatusCode());
            System.out.println("Moladb Error Code:   " + ase.getErrorCode());
            System.out.println("Error Type:       " + (Object)((Object)ase.getErrorType()));
            System.out.println("Request ID:       " + ase.getRequestId());
            ase.printStackTrace();
        }
        catch (BceClientException ace) {
            System.out.println("Caught an MoladbClientException, which means the client encountered a serious internal problem while trying to communicate with Moladb, such as not being able to access the network.");
            System.out.println("Error Message: " + ace.getMessage());
            ace.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void deleteItem() {
        try {
            System.out.println("=====================Start.=======================");
            String tableName = TABLE1;
            Key keyToDel = new Key();
            keyToDel.withAttribute(KEYATTR1, new AttributeValue().withS("how to use moladb?"));
            keyToDel.withAttribute(KEYATTR2, new AttributeValue().withS("2015/01/02"));
            DeleteItemRequest request = new DeleteItemRequest().withTableName(tableName).withKey(keyToDel);
            DeleteItemResponse result = this.molaDbClient.deleteItem(request);
            System.out.println("result:" + result.toString());
            System.out.println("=====================End.=======================");
        }
        catch (BceServiceException mse) {
            System.out.println("Caught an moladb, which means your request made it to moladb, but was rejected with an error responseContent for some reason.");
            System.out.println("Error Message:    " + mse.getMessage());
            System.out.println("HTTP ErrorDescription Code: " + mse.getStatusCode());
            System.out.println("Moladb Error Code:   " + mse.getErrorCode());
            System.out.println("Error Type:       " + (Object)((Object)mse.getErrorType()));
            System.out.println("Request ID:       " + mse.getRequestId());
            mse.printStackTrace();
        }
        catch (BceClientException mce) {
            System.out.println("Caught an MoladbClientException, which means the client encountered a serious internal problem while trying to communicate with Moladb, such as not being able to access the network.");
            System.out.println("Error Message: " + mce.getMessage());
            mce.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void batchWriteItem() {
        try {
            System.out.println("=====================Start.=======================");
            String tableName1 = TABLE1;
            String tableName2 = TABLE2;
            HashMap<String, List<WriteRequest>> requestItems = new HashMap<String, List<WriteRequest>>();
            HashMap<String, AttributeValue> item1 = new HashMap<String, AttributeValue>();
            item1.put("body", new AttributeValue().withB("bce is provided by baidu".getBytes()));
            item1.put("auther", new AttributeValue().withS("moladb"));
            item1.put(KEYATTR1, new AttributeValue().withS("how to use bce"));
            item1.put(KEYATTR2, new AttributeValue().withS("2015/04/01"));
            ArrayList<PutRequest> actionOnTable1 = new ArrayList<PutRequest>();
            actionOnTable1.add(new PutRequest().withItem(item1));
            requestItems.put(tableName1, actionOnTable1);
            HashMap<String, AttributeValue> item2 = new HashMap<String, AttributeValue>();
            item2.put("body", new AttributeValue().withB("bcc is very fast".getBytes()));
            item2.put("auther", new AttributeValue().withS("baidubce"));
            item2.put(KEYATTR1, new AttributeValue().withS("how to use bcc?"));
            item2.put(KEYATTR2, new AttributeValue().withS("2015/03/09"));
            actionOnTable1.add(new PutRequest().withItem(item2));
            ArrayList<WriteRequest> actionOnTable2 = new ArrayList<WriteRequest>();
            Key delKey1 = new Key();
            delKey1.withAttribute("city", new AttributeValue().withS("shanghai"));
            delKey1.withAttribute("autherName", new AttributeValue().withS("moladb"));
            HashMap<String, AttributeValue> item3 = new HashMap<String, AttributeValue>();
            item3.put("age", new AttributeValue().withN("100"));
            item3.put("city", new AttributeValue().withS("nanjing"));
            item3.put("autherName", new AttributeValue().withS("moladb"));
            actionOnTable2.add(new DeleteRequest().withKey(delKey1));
            actionOnTable2.add(new PutRequest().withItem(item3));
            requestItems.put(tableName2, actionOnTable2);
            BatchWriteItemRequest batchWriteItemRequest = new BatchWriteItemRequest();
            batchWriteItemRequest.withRequestItems(requestItems);
            System.out.println("request:" + batchWriteItemRequest.toString());
            int backoff = 1000;
            int maxRetry = 10;
            BatchWriteItemResponse result = this.molaDbClient.batchWriteItem(batchWriteItemRequest);
            for (int retryCount = 0; result.getUnprocessedItems() != null && !result.getUnprocessedItems().isEmpty() && retryCount < maxRetry; ++retryCount) {
                Thread.sleep(backoff *= 2);
                batchWriteItemRequest.withRequestItems(result.getUnprocessedItems());
                result = this.molaDbClient.batchWriteItem(batchWriteItemRequest);
            }
            System.out.println("=====================End.=======================");
        }
        catch (BceServiceException ase) {
            System.out.println("Caught an moladb, which means your request made it to moladb, but was rejected with an error responseContent for some reason.");
            System.out.println("Error Message:    " + ase.getMessage());
            System.out.println("HTTP ErrorDescription Code: " + ase.getStatusCode());
            System.out.println("Moladb Error Code:   " + ase.getErrorCode());
            System.out.println("Error Type:       " + (Object)((Object)ase.getErrorType()));
            System.out.println("Request ID:       " + ase.getRequestId());
            ase.printStackTrace();
        }
        catch (BceClientException ace) {
            System.out.println("Caught an MoladbClientException, which means the client encountered a serious internal problem while trying to communicate with Moladb, such as not being able to access the network.");
            System.out.println("Error Message: " + ace.getMessage());
            ace.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void batchGetItem() {
        try {
            System.out.println("=====================Start.=======================");
            String tableName1 = TABLE1;
            String tableName2 = TABLE2;
            HashMap<String, KeysAndAttributes> reqs = new HashMap<String, KeysAndAttributes>();
            ArrayList<Key> keys1 = new ArrayList<Key>();
            Key table1key1 = new Key();
            table1key1.withAttribute(KEYATTR1, new AttributeValue().withS("how to use moladb?"));
            table1key1.withAttribute(KEYATTR2, new AttributeValue().withS("2015/01/02"));
            keys1.add(table1key1);
            Key table1key2 = new Key();
            table1key2.withAttribute(KEYATTR1, new AttributeValue().withS("how to use bce"));
            table1key2.withAttribute(KEYATTR2, new AttributeValue().withS("2015/04/01"));
            keys1.add(table1key2);
            ArrayList<String> attrs = new ArrayList<String>();
            attrs.add("body");
            reqs.put(tableName1, new KeysAndAttributes().withKeys(keys1).withAttributesToGet(attrs));
            ArrayList<Key> keys2 = new ArrayList<Key>();
            Key table2key1 = new Key();
            table2key1.withAttribute("city", new AttributeValue().withS("shanghai"));
            table2key1.withAttribute("autherName", new AttributeValue().withS("moladb"));
            keys2.add(table2key1);
            Key table2key2 = new Key();
            table2key2.withAttribute("city", new AttributeValue().withS("nanjing"));
            table2key2.withAttribute("autherName", new AttributeValue().withS("moladb"));
            keys2.add(table2key2);
            Key table2key3 = new Key();
            table2key3.withAttribute("city", new AttributeValue().withS("beijing"));
            table2key3.withAttribute("autherName", new AttributeValue().withS("bcc"));
            keys2.add(table2key3);
            reqs.put(tableName2, new KeysAndAttributes().withKeys(keys2).withConsistentRead(true));
            BatchGetItemRequest batchGetItemRequest = new BatchGetItemRequest().withRequestItems(reqs);
            BatchGetItemResponse result = this.molaDbClient.batchGetItem(batchGetItemRequest);
            int maxRetryCount = 10;
            int backoff = 1000;
            for (int retryCount = 0; result.getUnprocessedItems() != null && !result.getUnprocessedItems().isEmpty() && retryCount < maxRetryCount; ++retryCount) {
                Thread.sleep(backoff *= 2);
                batchGetItemRequest.withRequestItems(result.getUnprocessedItems());
                result = this.molaDbClient.batchGetItem(batchGetItemRequest);
            }
            System.out.println("result:" + result.toString());
            System.out.println("=====================End.=======================");
        }
        catch (BceServiceException ase) {
            System.out.println("Caught an moladb, which means your request made it to moladb, but was rejected with an error responseContent for some reason.");
            System.out.println("Error Message:    " + ase.getMessage());
            System.out.println("HTTP ErrorDescription Code: " + ase.getStatusCode());
            System.out.println("Moladb Error Code:   " + ase.getErrorCode());
            System.out.println("Error Type:       " + (Object)((Object)ase.getErrorType()));
            System.out.println("Request ID:       " + ase.getRequestId());
            ase.printStackTrace();
        }
        catch (BceClientException ace) {
            System.out.println("Caught an MoladbClientException, which means the client encountered a serious internal problem while trying to communicate with Moladb, such as not being able to access the network.");
            System.out.println("Error Message: " + ace.getMessage());
            ace.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void query() {
        try {
            String tableName = TABLE1;
            String format = "2013/%02d/%02d";
            for (int i = 0; i < 10; ++i) {
                HashMap<String, AttributeValue> item = new HashMap<String, AttributeValue>();
                int mounth = i * 17 % 12 + 1;
                int day = i * 13 % 27 + 1;
                String date = String.format(format, mounth, day);
                System.out.println("date:" + date);
                item.put(KEYATTR1, new AttributeValue("how to use moladb?"));
                item.put(KEYATTR2, new AttributeValue(date));
                item.put("body", new AttributeValue("yes"));
                System.out.println("put record:" + ((Object)item).toString());
                PutItemRequest putItemRequest = new PutItemRequest(tableName).withItem(item);
                this.molaDbClient.putItem(putItemRequest);
            }
            System.out.println("=====================Start.=======================");
            AttributeValue keyAttr1 = new AttributeValue().withS("how to use moladb?");
            AttributeValue lowBound = new AttributeValue().withS("2013/01/01");
            AttributeValue upBound = new AttributeValue().withS("2015/02/03");
            String keyExpression = "subject = :HashKeyValue AND date BETWEEN :LowBound AND :UpBound";
            HashMap<String, AttributeValue> expressionAttributes = new HashMap<String, AttributeValue>();
            expressionAttributes.put(":HashKeyValue", keyAttr1);
            expressionAttributes.put(":LowBound", lowBound);
            expressionAttributes.put(":UpBound", upBound);
            QueryRequest request = new QueryRequest(tableName);
            ArrayList<String> attributesToGet = new ArrayList<String>();
            attributesToGet.add(KEYATTR1);
            attributesToGet.add(KEYATTR2);
            request.withAttributesToGet(attributesToGet).withLimit(100).withKeyConditionExpression(keyExpression).withExpressionAttributeValues(expressionAttributes);
            QueryResponse result = this.molaDbClient.query(request);
            List<Map<String, AttributeValue>> allRecord = result.getItems();
            while (result.getLastEvaluatedKey() != null) {
                request.withExclusiveStartKey(result.getLastEvaluatedKey());
                result = this.molaDbClient.query(request);
                allRecord.addAll(result.getItems());
            }
            System.out.println("all record:\n" + allRecord.toString());
            System.out.println("=====================End.=======================");
        }
        catch (BceServiceException ase) {
            System.out.println("Caught an moladb, which means your request made it to moladb, but was rejected with an error responseContent for some reason.");
            System.out.println("Error Message:    " + ase.getMessage());
            System.out.println("HTTP ErrorDescription Code: " + ase.getStatusCode());
            System.out.println("Moladb Error Code:   " + ase.getErrorCode());
            System.out.println("Error Type:       " + (Object)((Object)ase.getErrorType()));
            System.out.println("Request ID:       " + ase.getRequestId());
            ase.printStackTrace();
        }
        catch (BceClientException ace) {
            System.out.println("Caught an MoladbClientException, which means the client encountered a serious internal problem while trying to communicate with Moladb, such as not being able to access the network.");
            System.out.println("Error Message: " + ace.getMessage());
            ace.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void createInstanceExample(String insName) {
        try {
            CreateInstanceRequest req = new CreateInstanceRequest();
            req.withInstanceName(insName).withDescription("blog data");
            this.molaDbClient.createInstance(req);
        }
        catch (BceServiceException ase) {
            System.out.println("Caught an moladb, which means your request made it to moladb, but was rejected with an error responseContent for some reason.");
            System.out.println("Error Message:    " + ase.getMessage());
            System.out.println("HTTP ErrorDescription Code: " + ase.getStatusCode());
            System.out.println("Moladb Error Code:   " + ase.getErrorCode());
            System.out.println("Error Type:       " + (Object)((Object)ase.getErrorType()));
            System.out.println("Request ID:       " + ase.getRequestId());
            ase.printStackTrace();
        }
        catch (BceClientException ace) {
            System.out.println("Caught an MoladbClientException, which means the client encountered a serious internal problem while trying to communicate with Moladb, such as not being able to access the network.");
            System.out.println("Error Message: " + ace.getMessage());
            ace.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void statInstanceExample(String insName) {
        try {
            GetInstanceRequest req = new GetInstanceRequest(insName);
            GetInstanceResponse getRet = this.molaDbClient.getInstance(req);
            System.out.println("instance:" + insName + " description:" + getRet.getDescription());
            List<String> tables = getRet.getTableNames();
            Iterator<String> iter = tables.iterator();
            while (iter.hasNext()) {
                System.out.println("instance:" + insName + " has table:" + iter.next());
            }
            ListInstancesResponse listRet = this.molaDbClient.listInstances();
            List<String> names = listRet.getInstanceNames();
            Iterator<String> iter2 = names.iterator();
            while (iter2.hasNext()) {
                System.out.println("list instance, return:" + iter2.next());
            }
        }
        catch (BceServiceException ase) {
            System.out.println("Caught an moladb, which means your request made it to moladb, but was rejected with an error responseContent for some reason.");
            System.out.println("Error Message:    " + ase.getMessage());
            System.out.println("HTTP ErrorDescription Code: " + ase.getStatusCode());
            System.out.println("Moladb Error Code:   " + ase.getErrorCode());
            System.out.println("Error Type:       " + (Object)((Object)ase.getErrorType()));
            System.out.println("Request ID:       " + ase.getRequestId());
            ase.printStackTrace();
        }
        catch (BceClientException ace) {
            System.out.println("Caught an MoladbClientException, which means the client encountered a serious internal problem while trying to communicate with Moladb, such as not being able to access the network.");
            System.out.println("Error Message: " + ace.getMessage());
            ace.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void deleteInstance(String insName) {
        try {
            DeleteInstanceRequest req = new DeleteInstanceRequest(insName);
            this.molaDbClient.deleteInstance(req);
        }
        catch (BceServiceException ase) {
            System.out.println("Caught an moladb, which means your request made it to moladb, but was rejected with an error responseContent for some reason.");
            System.out.println("Error Message:    " + ase.getMessage());
            System.out.println("HTTP ErrorDescription Code: " + ase.getStatusCode());
            System.out.println("Moladb Error Code:   " + ase.getErrorCode());
            System.out.println("Error Type:       " + (Object)((Object)ase.getErrorType()));
            System.out.println("Request ID:       " + ase.getRequestId());
            ase.printStackTrace();
        }
        catch (BceClientException ace) {
            System.out.println("Caught an MoladbClientException, which means the client encountered a serious internal problem while trying to communicate with Moladb, such as not being able to access the network.");
            System.out.println("Error Message: " + ace.getMessage());
            ace.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) throws IOException {
        System.out.println("===========================================");
        System.out.println("Getting Started with Baidu Moladb");
        System.out.println("===========================================\n");
        DefaultBceCredentials credentials = null;
        try {
            credentials = new DefaultBceCredentials(ACCESS_KEY_ID, SECRET_ACCESS_KEY);
        }
        catch (Exception e) {
            throw new BceClientException("Cannot load the credentials from the credential profiles file. Please make sure that your credentials file is at the correct and is in valid format.", e);
        }
        String insName = "blogDatabase";
        MolaDbClientConfiguration conf = new MolaDbClientConfiguration();
        conf.setCredentials(credentials);
        conf.setEndpoint(ENDPOINT);
        MolaDbClient molaDbClient = new MolaDbClient(conf);
        molaDbClient.setDefaultInstanceName(insName);
        MolaDbExample example = new MolaDbExample(molaDbClient);
        example.createInstanceExample(insName);
        example.statInstanceExample(insName);
        example.createTable();
        example.updateTable();
        example.getTable();
        example.listTables();
        example.putItem();
        example.getItem();
        example.updateItem();
        example.deleteItem();
        example.batchWriteItem();
        example.batchGetItem();
        example.query();
        example.deleteTable();
        example.deleteInstance(insName);
        System.out.println("end now");
    }
}

