/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.moladb.model;

import com.baidubce.BceClientException;
import com.baidubce.auth.BceCredentials;
import com.baidubce.model.AbstractBceRequest;
import com.baidubce.services.moladb.model.DeleteRequest;
import com.baidubce.services.moladb.model.PutRequest;
import com.baidubce.services.moladb.model.WriteRequest;
import com.baidubce.util.JsonUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BatchWriteItemRequest
extends AbstractBceRequest {
    private Map<String, List<WriteRequest>> requestItems;

    public String toString() {
        HashMap rootObj = new HashMap();
        HashMap<String, List<Object>> reqItems = new HashMap<String, List<Object>>();
        for (Map.Entry<String, List<WriteRequest>> entry : this.requestItems.entrySet()) {
            String tableName = entry.getKey();
            List<WriteRequest> val = entry.getValue();
            reqItems.put(tableName, this.toJsonObj(val));
        }
        rootObj.put("requestItems", reqItems);
        return JsonUtils.toJsonString(rootObj);
    }

    public BatchWriteItemRequest withRequestItems(Map<String, List<WriteRequest>> requestItems) {
        this.setRequestItems(requestItems);
        return this;
    }

    public void setRequestItems(Map<String, List<WriteRequest>> requestItems) {
        this.requestItems = requestItems;
    }

    public Map<String, List<WriteRequest>> getRequestItems() {
        return this.requestItems;
    }

    @Override
    public BatchWriteItemRequest withRequestCredentials(BceCredentials credentials) {
        this.setRequestCredentials(credentials);
        return this;
    }

    protected List<Object> toJsonObj(List<WriteRequest> requests) {
        ArrayList<Object> objList = new ArrayList<Object>();
        for (WriteRequest req : requests) {
            if (req instanceof DeleteRequest) {
                HashMap<String, Map<String, Object>> deleteObj = new HashMap<String, Map<String, Object>>();
                deleteObj.put("deleteRequest", ((DeleteRequest)req).toJsonObj());
                objList.add(deleteObj);
                continue;
            }
            if (req instanceof PutRequest) {
                HashMap<String, Map<String, Object>> putObj = new HashMap<String, Map<String, Object>>();
                putObj.put("putRequest", ((PutRequest)req).toJsonObj());
                objList.add(putObj);
                continue;
            }
            throw new BceClientException("Unknow write request:" + req.toString());
        }
        return objList;
    }
}

